/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Either;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;

public class ResourceOrTagArgument<T>
implements ArgumentType<Result<T>> {
    private static final Collection<String> EXAMPLES = Arrays.asList("foo", "foo:bar", "012", "#skeletons", "#minecraft:skeletons");
    private static final Dynamic2CommandExceptionType ERROR_UNKNOWN_TAG = new Dynamic2CommandExceptionType((tag, type) -> Component.translatableEscape("argument.resource_tag.not_found", tag, type));
    private static final Dynamic3CommandExceptionType ERROR_INVALID_TAG_TYPE = new Dynamic3CommandExceptionType((tag, type, expectedType) -> Component.translatableEscape("argument.resource_tag.invalid_type", tag, type, expectedType));
    private final HolderLookup<T> registryLookup;
    final ResourceKey<? extends Registry<T>> registryKey;

    public ResourceOrTagArgument(CommandBuildContext registryAccess, ResourceKey<? extends Registry<T>> registryRef) {
        this.registryKey = registryRef;
        this.registryLookup = registryAccess.lookupOrThrow(registryRef);
    }

    public static <T> ResourceOrTagArgument<T> resourceOrTag(CommandBuildContext registryRef, ResourceKey<? extends Registry<T>> registryAccess) {
        return new ResourceOrTagArgument<T>(registryRef, registryAccess);
    }

    public static <T> Result<T> getResourceOrTag(CommandContext<CommandSourceStack> context, String name, ResourceKey<Registry<T>> registryRef) throws CommandSyntaxException {
        Result result = (Result)context.getArgument(name, Result.class);
        Optional<Result<T>> optional = result.cast(registryRef);
        return optional.orElseThrow(() -> result.unwrap().map(entry -> {
            ResourceKey resourceKey2 = entry.key();
            return ResourceArgument.ERROR_INVALID_RESOURCE_TYPE.create((Object)resourceKey2.location(), (Object)resourceKey2.registry(), (Object)registryRef.location());
        }, entryList -> {
            TagKey tagKey = entryList.key();
            return ERROR_INVALID_TAG_TYPE.create((Object)tagKey.location(), tagKey.registry(), (Object)registryRef.location());
        }));
    }

    public Result<T> parse(StringReader stringReader) throws CommandSyntaxException {
        if (stringReader.canRead() && stringReader.peek() == '#') {
            int i = stringReader.getCursor();
            try {
                stringReader.skip();
                ResourceLocation resourceLocation = ResourceLocation.read(stringReader);
                TagKey tagKey = TagKey.create(this.registryKey, resourceLocation);
                HolderSet.Named named = this.registryLookup.get(tagKey).orElseThrow(() -> ERROR_UNKNOWN_TAG.createWithContext((ImmutableStringReader)stringReader, (Object)resourceLocation, (Object)this.registryKey.location()));
                return new TagResult(named);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                stringReader.setCursor(i);
                throw commandSyntaxException;
            }
        }
        ResourceLocation resourceLocation2 = ResourceLocation.read(stringReader);
        ResourceKey resourceKey = ResourceKey.create(this.registryKey, resourceLocation2);
        Holder.Reference reference = this.registryLookup.get(resourceKey).orElseThrow(() -> ResourceArgument.ERROR_UNKNOWN_RESOURCE.createWithContext((ImmutableStringReader)stringReader, (Object)resourceLocation2, (Object)this.registryKey.location()));
        return new ResourceResult(reference);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> commandContext, SuggestionsBuilder suggestionsBuilder) {
        SharedSuggestionProvider.suggestResource(this.registryLookup.listTagIds().map(TagKey::location), suggestionsBuilder, "#");
        return SharedSuggestionProvider.suggestResource(this.registryLookup.listElementIds().map(ResourceKey::location), suggestionsBuilder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    public static interface Result<T>
    extends Predicate<Holder<T>> {
        public Either<Holder.Reference<T>, HolderSet.Named<T>> unwrap();

        public <E> Optional<Result<E>> cast(ResourceKey<? extends Registry<E>> var1);

        public String asPrintable();
    }

    record TagResult<T>(HolderSet.Named<T> tag) implements Result<T>
    {
        @Override
        @Override
        public Either<Holder.Reference<T>, HolderSet.Named<T>> unwrap() {
            return Either.right(this.tag);
        }

        @Override
        @Override
        public <E> Optional<Result<E>> cast(ResourceKey<? extends Registry<E>> registryRef) {
            return this.tag.key().isFor(registryRef) ? Optional.of(this) : Optional.empty();
        }

        @Override
        @Override
        public boolean test(Holder<T> holder) {
            return this.tag.contains(holder);
        }

        @Override
        @Override
        public String asPrintable() {
            return "#" + String.valueOf(this.tag.key().location());
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((Holder)object);
        }
    }

    record ResourceResult<T>(Holder.Reference<T> value) implements Result<T>
    {
        @Override
        @Override
        public Either<Holder.Reference<T>, HolderSet.Named<T>> unwrap() {
            return Either.left(this.value);
        }

        @Override
        @Override
        public <E> Optional<Result<E>> cast(ResourceKey<? extends Registry<E>> registryRef) {
            return this.value.key().isFor(registryRef) ? Optional.of(this) : Optional.empty();
        }

        @Override
        @Override
        public boolean test(Holder<T> holder) {
            return holder.equals(this.value);
        }

        @Override
        @Override
        public String asPrintable() {
            return this.value.key().location().toString();
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((Holder)object);
        }
    }

    public static class Info<T>
    implements ArgumentTypeInfo<ResourceOrTagArgument<T>, Template> {
        @Override
        @Override
        public void serializeToNetwork(Template properties, FriendlyByteBuf buf) {
            buf.writeResourceKey(properties.registryKey);
        }

        @Override
        @Override
        public Template deserializeFromNetwork(FriendlyByteBuf friendlyByteBuf) {
            return new Template(friendlyByteBuf.readRegistryKey());
        }

        @Override
        @Override
        public void serializeToJson(Template properties, JsonObject json) {
            json.addProperty("registry", properties.registryKey.location().toString());
        }

        @Override
        @Override
        public Template unpack(ResourceOrTagArgument<T> argumentType) {
            return new Template(argumentType.registryKey);
        }

        @Override
        public /* synthetic */ ArgumentTypeInfo.Template deserializeFromNetwork(FriendlyByteBuf buf) {
            return this.deserializeFromNetwork(buf);
        }

        public final class Template
        implements ArgumentTypeInfo.Template<ResourceOrTagArgument<T>> {
            final ResourceKey<? extends Registry<T>> registryKey;

            Template(ResourceKey<? extends Registry<T>> registryRef) {
                this.registryKey = registryRef;
            }

            @Override
            @Override
            public ResourceOrTagArgument<T> instantiate(CommandBuildContext commandBuildContext) {
                return new ResourceOrTagArgument(commandBuildContext, this.registryKey);
            }

            @Override
            @Override
            public ArgumentTypeInfo<ResourceOrTagArgument<T>, ?> type() {
                return Info.this;
            }

            @Override
            public /* synthetic */ ArgumentType instantiate(CommandBuildContext commandRegistryAccess) {
                return this.instantiate(commandRegistryAccess);
            }
        }
    }
}

