/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands;

@FunctionalInterface
public interface CommandResultCallback {
    public static final CommandResultCallback EMPTY = new CommandResultCallback(){

        @Override
        @Override
        public void onResult(boolean successful, int returnValue) {
        }

        @Override
        public String toString() {
            return "<empty>";
        }
    };

    public void onResult(boolean var1, int var2);

    default public void onSuccess(int successful) {
        this.onResult(true, successful);
    }

    default public void onFailure() {
        this.onResult(false, 0);
    }

    public static CommandResultCallback chain(CommandResultCallback a, CommandResultCallback b) {
        if (a == EMPTY) {
            return b;
        }
        if (b == EMPTY) {
            return a;
        }
        return (successful, returnValue) -> {
            a.onResult(successful, returnValue);
            b.onResult(successful, returnValue);
        };
    }
}

