/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BlockUtil {
    public static FoundRectangle getLargestRectangleAround(BlockPos center, Direction.Axis primaryAxis, int primaryMaxBlocks, Direction.Axis secondaryAxis, int secondaryMaxBlocks, Predicate<BlockPos> predicate) {
        BlockPos.MutableBlockPos mutableBlockPos = center.mutable();
        Direction direction = Direction.get(Direction.AxisDirection.NEGATIVE, primaryAxis);
        Direction direction2 = direction.getOpposite();
        Direction direction3 = Direction.get(Direction.AxisDirection.NEGATIVE, secondaryAxis);
        Direction direction4 = direction3.getOpposite();
        int i = BlockUtil.getLimit(predicate, mutableBlockPos.set(center), direction, primaryMaxBlocks);
        int j = BlockUtil.getLimit(predicate, mutableBlockPos.set(center), direction2, primaryMaxBlocks);
        int k = i;
        IntBounds[] intBoundss = new IntBounds[k + 1 + j];
        intBoundss[k] = new IntBounds(BlockUtil.getLimit(predicate, mutableBlockPos.set(center), direction3, secondaryMaxBlocks), BlockUtil.getLimit(predicate, mutableBlockPos.set(center), direction4, secondaryMaxBlocks));
        int l = intBoundss[k].min;
        for (int m = 1; m <= i; ++m) {
            IntBounds intBounds = intBoundss[k - (m - 1)];
            intBoundss[k - m] = new IntBounds(BlockUtil.getLimit(predicate, mutableBlockPos.set(center).move(direction, m), direction3, intBounds.min), BlockUtil.getLimit(predicate, mutableBlockPos.set(center).move(direction, m), direction4, intBounds.max));
        }
        for (int n = 1; n <= j; ++n) {
            IntBounds intBounds2 = intBoundss[k + n - 1];
            intBoundss[k + n] = new IntBounds(BlockUtil.getLimit(predicate, mutableBlockPos.set(center).move(direction2, n), direction3, intBounds2.min), BlockUtil.getLimit(predicate, mutableBlockPos.set(center).move(direction2, n), direction4, intBounds2.max));
        }
        int o = 0;
        int p = 0;
        int q = 0;
        int r = 0;
        int[] is = new int[intBoundss.length];
        for (int s = l; s >= 0; --s) {
            for (int t = 0; t < intBoundss.length; ++t) {
                IntBounds intBounds3 = intBoundss[t];
                int u = l - intBounds3.min;
                int v = l + intBounds3.max;
                is[t] = s >= u && s <= v ? v + 1 - s : 0;
            }
            Pair<IntBounds, Integer> pair = BlockUtil.getMaxRectangleLocation(is);
            IntBounds intBounds4 = (IntBounds)pair.getFirst();
            int w = 1 + intBounds4.max - intBounds4.min;
            int x = (Integer)pair.getSecond();
            if (w * x <= q * r) continue;
            o = intBounds4.min;
            p = s;
            q = w;
            r = x;
        }
        return new FoundRectangle(center.relative(primaryAxis, o - k).relative(secondaryAxis, p - l), q, r);
    }

    private static int getLimit(Predicate<BlockPos> predicate, BlockPos.MutableBlockPos pos, Direction direction, int max) {
        int i;
        for (i = 0; i < max && predicate.test(pos.move(direction)); ++i) {
        }
        return i;
    }

    @VisibleForTesting
    static Pair<IntBounds, Integer> getMaxRectangleLocation(int[] heights) {
        int i = 0;
        int j = 0;
        int k = 0;
        IntArrayList intStack = new IntArrayList();
        intStack.push(0);
        for (int l = 1; l <= heights.length; ++l) {
            int m;
            int n = m = l == heights.length ? 0 : heights[l];
            while (!intStack.isEmpty()) {
                int n2 = heights[intStack.topInt()];
                if (m >= n2) {
                    intStack.push(l);
                    break;
                }
                intStack.popInt();
                int o = intStack.isEmpty() ? 0 : intStack.topInt() + 1;
                if (n2 * (l - o) <= k * (j - i)) continue;
                j = l;
                i = o;
                k = n2;
            }
            if (!intStack.isEmpty()) continue;
            intStack.push(l);
        }
        return new Pair((Object)new IntBounds(i, j - 1), (Object)k);
    }

    public static Optional<BlockPos> getTopConnectedBlock(BlockGetter world, BlockPos pos, Block intermediateBlock, Direction direction, Block endBlock) {
        BlockState blockState;
        BlockPos.MutableBlockPos mutableBlockPos = pos.mutable();
        do {
            mutableBlockPos.move(direction);
        } while ((blockState = world.getBlockState(mutableBlockPos)).is(intermediateBlock));
        if (blockState.is(endBlock)) {
            return Optional.of(mutableBlockPos);
        }
        return Optional.empty();
    }

    public static class IntBounds {
        public final int min;
        public final int max;

        public IntBounds(int min, int max) {
            this.min = min;
            this.max = max;
        }

        @Override
        public String toString() {
            return "IntBounds{min=" + this.min + ", max=" + this.max + "}";
        }
    }

    public static class FoundRectangle {
        public final BlockPos minCorner;
        public final int axis1Size;
        public final int axis2Size;

        public FoundRectangle(BlockPos lowerLeft, int width, int height) {
            this.minCorner = lowerLeft;
            this.axis1Size = width;
            this.axis2Size = height;
        }
    }
}

