/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.util;

import com.destroystokyo.paper.profile.CraftPlayerProfile;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.authlib.GameProfile;
import io.papermc.paper.math.BlockPosition;
import io.papermc.paper.math.FinePosition;
import io.papermc.paper.math.Position;
import it.unimi.dsi.fastutil.objects.ObjectRBTreeSet;
import java.lang.ref.Cleaner;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Queue;
import java.util.SortedSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.DefaultUncaughtExceptionHandlerWithName;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.util.Waitable;
import org.bukkit.entity.Entity;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;

public final class MCUtil {
    public static final ThreadPoolExecutor asyncExecutor = new ThreadPoolExecutor(0, 2, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("Paper Async Task Handler Thread - %1$d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandlerWithName(MinecraftServer.LOGGER)).build());
    public static final ThreadPoolExecutor cleanerExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("Paper Object Cleaner").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandlerWithName(MinecraftServer.LOGGER)).build());
    public static final long INVALID_CHUNK_KEY = MCUtil.getCoordinateKey(Integer.MAX_VALUE, Integer.MAX_VALUE);
    public static final Executor MAIN_EXECUTOR = run -> {
        if (!MCUtil.isMainThread()) {
            MinecraftServer.getServer().execute(run);
        } else {
            run.run();
        }
    };

    public static Runnable once(Runnable run) {
        AtomicBoolean ran = new AtomicBoolean(false);
        return () -> {
            if (ran.compareAndSet(false, true)) {
                run.run();
            }
        };
    }

    public static <T> Runnable once(List<T> list, Consumer<T> cb) {
        return MCUtil.once(() -> list.forEach(cb));
    }

    private static Runnable makeCleanerCallback(Runnable run) {
        return MCUtil.once(() -> cleanerExecutor.execute(run));
    }

    public static Runnable registerCleaner(Object obj, Runnable run) {
        Runnable cleaner = MCUtil.makeCleanerCallback(run);
        CleanerHolder.CLEANER.register(obj, cleaner);
        return cleaner;
    }

    public static <T> Runnable registerListCleaner(Object obj, List<T> list, Consumer<T> cleaner) {
        return MCUtil.registerCleaner(obj, () -> {
            list.forEach(cleaner);
            list.clear();
        });
    }

    public static <T> Runnable registerCleaner(Object obj, T resource, Consumer<T> cleaner) {
        return MCUtil.registerCleaner(obj, () -> cleaner.accept(resource));
    }

    public static List<ChunkPos> getSpiralOutChunks(BlockPos blockposition, int radius) {
        ArrayList list = Lists.newArrayList();
        list.add(new ChunkPos(blockposition.getX() >> 4, blockposition.getZ() >> 4));
        for (int r = 1; r <= radius; ++r) {
            int x = -r;
            int z = r;
            while (x <= r && z > -r) {
                list.add(new ChunkPos(blockposition.getX() + (x << 4) >> 4, blockposition.getZ() + (z << 4) >> 4));
                list.add(new ChunkPos(blockposition.getX() - (x << 4) >> 4, blockposition.getZ() - (z << 4) >> 4));
                if (x < r) {
                    ++x;
                    continue;
                }
                --z;
            }
        }
        return list;
    }

    public static int fastFloor(double x) {
        int truncated = (int)x;
        return x < (double)truncated ? truncated - 1 : truncated;
    }

    public static int fastFloor(float x) {
        int truncated = (int)x;
        return (double)x < (double)truncated ? truncated - 1 : truncated;
    }

    public static float normalizeYaw(float f) {
        float f1 = f % 360.0f;
        if (f1 >= 180.0f) {
            f1 -= 360.0f;
        }
        if (f1 < -180.0f) {
            f1 += 360.0f;
        }
        return f1;
    }

    public static String stack() {
        return ExceptionUtils.getFullStackTrace((Throwable)new Throwable());
    }

    public static String stack(String str) {
        return ExceptionUtils.getFullStackTrace((Throwable)new Throwable(str));
    }

    public static long getCoordinateKey(BlockPos blockPos) {
        return (long)(blockPos.getZ() >> 4) << 32 | (long)(blockPos.getX() >> 4) & 0xFFFFFFFFL;
    }

    public static long getCoordinateKey(net.minecraft.world.entity.Entity entity) {
        return (long)(MCUtil.fastFloor(entity.getZ()) >> 4) << 32 | (long)(MCUtil.fastFloor(entity.getX()) >> 4) & 0xFFFFFFFFL;
    }

    public static long getCoordinateKey(ChunkPos pair) {
        return (long)pair.z << 32 | (long)pair.x & 0xFFFFFFFFL;
    }

    public static long getCoordinateKey(int x, int z) {
        return (long)z << 32 | (long)x & 0xFFFFFFFFL;
    }

    public static int getCoordinateX(long key) {
        return (int)key;
    }

    public static int getCoordinateZ(long key) {
        return (int)(key >>> 32);
    }

    public static int getChunkCoordinate(double coordinate) {
        return MCUtil.fastFloor(coordinate) >> 4;
    }

    public static int getBlockCoordinate(double coordinate) {
        return MCUtil.fastFloor(coordinate);
    }

    public static long getBlockKey(int x, int y, int z) {
        return (long)x & 0x7FFFFFFL | ((long)z & 0x7FFFFFFL) << 27 | (long)y << 54;
    }

    public static long getBlockKey(BlockPos pos) {
        return (long)pos.getX() & 0x7FFFFFFL | ((long)pos.getZ() & 0x7FFFFFFL) << 27 | (long)pos.getY() << 54;
    }

    public static long getBlockKey(net.minecraft.world.entity.Entity entity) {
        return MCUtil.getBlockKey(MCUtil.getBlockCoordinate(entity.getX()), MCUtil.getBlockCoordinate(entity.getY()), MCUtil.getBlockCoordinate(entity.getZ()));
    }

    public static <T> void mergeSortedSets(Consumer<T> consumer, Comparator<? super T> comparator, SortedSet<T> ... sets) {
        ObjectRBTreeSet all = new ObjectRBTreeSet(comparator);
        for (SortedSet<T> set : sets) {
            if (set == null) continue;
            all.addAll(set);
        }
        all.forEach(consumer);
    }

    private MCUtil() {
    }

    public static <T> CompletableFuture<T> ensureMain(CompletableFuture<T> future) {
        return future.thenApplyAsync(r -> r, MAIN_EXECUTOR);
    }

    public static <T> void thenOnMain(CompletableFuture<T> future, Consumer<T> consumer) {
        future.thenAcceptAsync((Consumer)consumer, MAIN_EXECUTOR);
    }

    public static <T> void thenOnMain(CompletableFuture<T> future, BiConsumer<T, Throwable> consumer) {
        future.whenCompleteAsync((BiConsumer)consumer, MAIN_EXECUTOR);
    }

    public static boolean isMainThread() {
        return MinecraftServer.getServer().isSameThread();
    }

    public static BukkitTask scheduleTask(int ticks, Runnable runnable) {
        return MCUtil.scheduleTask(ticks, runnable, null);
    }

    public static BukkitTask scheduleTask(int ticks, Runnable runnable, String taskName) {
        return MinecraftServer.getServer().server.getScheduler().scheduleInternalTask(runnable, ticks, taskName);
    }

    public static void processQueue() {
        Runnable runnable;
        Queue<Runnable> processQueue = MCUtil.getProcessQueue();
        while ((runnable = processQueue.poll()) != null) {
            try {
                runnable.run();
            }
            catch (Exception e) {
                MinecraftServer.LOGGER.error("Error executing task", (Throwable)e);
            }
        }
    }

    public static <T> T processQueueWhileWaiting(CompletableFuture<T> future) {
        try {
            if (MCUtil.isMainThread()) {
                while (!future.isDone()) {
                    try {
                        return future.get(1L, TimeUnit.MILLISECONDS);
                    }
                    catch (TimeoutException ignored) {
                        MCUtil.processQueue();
                    }
                }
            }
            return future.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void ensureMain(Runnable run) {
        MCUtil.ensureMain(null, run);
    }

    public static void ensureMain(String reason, Runnable run) {
        if (!MCUtil.isMainThread()) {
            if (reason != null) {
                MinecraftServer.LOGGER.warn("Asynchronous " + reason + "!", (Throwable)new IllegalStateException());
            }
            MCUtil.getProcessQueue().add(run);
            return;
        }
        run.run();
    }

    private static Queue<Runnable> getProcessQueue() {
        return MinecraftServer.getServer().processQueue;
    }

    public static <T> T ensureMain(Supplier<T> run) {
        return MCUtil.ensureMain(null, run);
    }

    public static <T> T ensureMain(String reason, final Supplier<T> run) {
        if (!MCUtil.isMainThread()) {
            if (reason != null) {
                MinecraftServer.LOGGER.warn("Asynchronous " + reason + "! Blocking thread until it returns ", (Throwable)new IllegalStateException());
            }
            Waitable wait = new Waitable<T>(){

                @Override
                protected T evaluate() {
                    return run.get();
                }
            };
            MCUtil.getProcessQueue().add(wait);
            try {
                return wait.get();
            }
            catch (InterruptedException | ExecutionException e) {
                MinecraftServer.LOGGER.warn("Encountered exception", (Throwable)e);
                return null;
            }
        }
        return run.get();
    }

    public static PlayerProfile toBukkit(GameProfile profile) {
        return CraftPlayerProfile.asBukkitMirror(profile);
    }

    public static double distance(net.minecraft.world.entity.Entity e1, net.minecraft.world.entity.Entity e2) {
        return Math.sqrt(MCUtil.distanceSq(e1, e2));
    }

    public static double distance(BlockPos e1, BlockPos e2) {
        return Math.sqrt(MCUtil.distanceSq(e1, e2));
    }

    public static double distance(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.sqrt(MCUtil.distanceSq(x1, y1, z1, x2, y2, z2));
    }

    public static double distanceSq(net.minecraft.world.entity.Entity e1, net.minecraft.world.entity.Entity e2) {
        return MCUtil.distanceSq(e1.getX(), e1.getY(), e1.getZ(), e2.getX(), e2.getY(), e2.getZ());
    }

    public static double distanceSq(BlockPos pos1, BlockPos pos2) {
        return MCUtil.distanceSq(pos1.getX(), pos1.getY(), pos1.getZ(), pos2.getX(), pos2.getY(), pos2.getZ());
    }

    public static double distanceSq(double x1, double y1, double z1, double x2, double y2, double z2) {
        return (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2) + (z1 - z2) * (z1 - z2);
    }

    public static Location toLocation(Level world, double x, double y, double z) {
        return new Location((World)world.getWorld(), x, y, z);
    }

    public static Location toLocation(Level world, BlockPos pos) {
        return new Location((World)world.getWorld(), (double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
    }

    public static Location toLocation(net.minecraft.world.entity.Entity entity) {
        return new Location((World)entity.getCommandSenderWorld().getWorld(), entity.getX(), entity.getY(), entity.getZ());
    }

    public static BlockPos toBlockPosition(Location loc) {
        return new BlockPos(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
    }

    public static BlockPos toBlockPos(Position pos) {
        return new BlockPos(pos.blockX(), pos.blockY(), pos.blockZ());
    }

    public static FinePosition toPosition(Vec3 vector) {
        return Position.fine((double)vector.x, (double)vector.y, (double)vector.z);
    }

    public static BlockPosition toPosition(Vec3i vector) {
        return Position.block((int)vector.getX(), (int)vector.getY(), (int)vector.getZ());
    }

    public static Vec3 toVec3(Position position) {
        return new Vec3(position.x(), position.y(), position.z());
    }

    public static boolean isEdgeOfChunk(BlockPos pos) {
        int modX = pos.getX() & 0xF;
        int modZ = pos.getZ() & 0xF;
        return modX == 0 || modX == 15 || modZ == 0 || modZ == 15;
    }

    public static void scheduleAsyncTask(Runnable run) {
        asyncExecutor.execute(run);
    }

    @Nonnull
    public static ServerLevel getNMSWorld(@Nonnull World world) {
        return ((CraftWorld)world).getHandle();
    }

    public static ServerLevel getNMSWorld(@Nonnull Entity entity) {
        return MCUtil.getNMSWorld(entity.getWorld());
    }

    public static BlockFace toBukkitBlockFace(Direction enumDirection) {
        switch (enumDirection) {
            case DOWN: {
                return BlockFace.DOWN;
            }
            case UP: {
                return BlockFace.UP;
            }
            case NORTH: {
                return BlockFace.NORTH;
            }
            case SOUTH: {
                return BlockFace.SOUTH;
            }
            case WEST: {
                return BlockFace.WEST;
            }
            case EAST: {
                return BlockFace.EAST;
            }
        }
        return null;
    }

    @NotNull
    public static <T> List<T> copyListAndAdd(@NotNull List<T> original, @NotNull T newElement) {
        return ImmutableList.builderWithExpectedSize((int)(original.size() + 1)).addAll(original).add(newElement).build();
    }

    @NotNull
    public static <T> List<T> copyListAndRemoveIf(@NotNull List<T> original, @NotNull Predicate<T> removalPredicate) {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)original.size());
        for (int i = 0; i < original.size(); ++i) {
            T value = original.get(i);
            if (removalPredicate.test(value)) continue;
            builder.add(value);
        }
        return builder.build();
    }

    private static final class CleanerHolder {
        private static final Cleaner CLEANER = Cleaner.create();

        private CleanerHolder() {
        }
    }
}

