/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.threadedregions.scheduler;

import ca.spottedleaf.concurrentutil.util.ConcurrentUtil;
import ca.spottedleaf.concurrentutil.util.Validate;
import io.papermc.paper.threadedregions.scheduler.GlobalRegionScheduler;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Level;
import org.bukkit.plugin.IllegalPluginAccessException;
import org.bukkit.plugin.Plugin;

public class FoliaGlobalRegionScheduler
implements GlobalRegionScheduler {
    private long tickCount = 0L;
    private final Object stateLock = new Object();
    private final Long2ObjectOpenHashMap<List<GlobalScheduledTask>> tasksByDeadline = new Long2ObjectOpenHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        List run;
        Object object = this.stateLock;
        synchronized (object) {
            ++this.tickCount;
            run = this.tasksByDeadline.isEmpty() ? null : (List)this.tasksByDeadline.remove(this.tickCount);
        }
        if (run == null) {
            return;
        }
        int len = run.size();
        for (int i = 0; i < len; ++i) {
            ((GlobalScheduledTask)run.get(i)).run();
        }
    }

    public void execute(Plugin plugin, Runnable run) {
        Validate.notNull(plugin, "Plugin may not be null");
        Validate.notNull(run, "Runnable may not be null");
        this.run(plugin, task -> run.run());
    }

    public ScheduledTask run(Plugin plugin, Consumer<ScheduledTask> task) {
        return this.runDelayed(plugin, task, 1L);
    }

    public ScheduledTask runDelayed(Plugin plugin, Consumer<ScheduledTask> task, long delayTicks) {
        Validate.notNull(plugin, "Plugin may not be null");
        Validate.notNull(task, "Task may not be null");
        if (delayTicks <= 0L) {
            throw new IllegalArgumentException("Delay ticks may not be <= 0");
        }
        if (!plugin.isEnabled()) {
            throw new IllegalPluginAccessException("Plugin attempted to register task while disabled");
        }
        GlobalScheduledTask ret = new GlobalScheduledTask(plugin, -1L, task);
        this.scheduleInternal(ret, delayTicks);
        if (!plugin.isEnabled()) {
            ret.cancel();
        }
        return ret;
    }

    public ScheduledTask runAtFixedRate(Plugin plugin, Consumer<ScheduledTask> task, long initialDelayTicks, long periodTicks) {
        Validate.notNull(plugin, "Plugin may not be null");
        Validate.notNull(task, "Task may not be null");
        if (initialDelayTicks <= 0L) {
            throw new IllegalArgumentException("Initial delay ticks may not be <= 0");
        }
        if (periodTicks <= 0L) {
            throw new IllegalArgumentException("Period ticks may not be <= 0");
        }
        if (!plugin.isEnabled()) {
            throw new IllegalPluginAccessException("Plugin attempted to register task while disabled");
        }
        GlobalScheduledTask ret = new GlobalScheduledTask(plugin, periodTicks, task);
        this.scheduleInternal(ret, initialDelayTicks);
        if (!plugin.isEnabled()) {
            ret.cancel();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelTasks(Plugin plugin) {
        Validate.notNull(plugin, "Plugin may not be null");
        ArrayList<GlobalScheduledTask> toCancel = new ArrayList<GlobalScheduledTask>();
        Object object = this.stateLock;
        synchronized (object) {
            for (List tasks : this.tasksByDeadline.values()) {
                int len = tasks.size();
                for (int i = 0; i < len; ++i) {
                    GlobalScheduledTask task = (GlobalScheduledTask)tasks.get(i);
                    if (task.plugin != plugin) continue;
                    toCancel.add(task);
                }
            }
        }
        int len = toCancel.size();
        for (int i = 0; i < len; ++i) {
            ((GlobalScheduledTask)toCancel.get(i)).cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleInternal(GlobalScheduledTask task, long delay) {
        Object object = this.stateLock;
        synchronized (object) {
            ((List)this.tasksByDeadline.computeIfAbsent(this.tickCount + delay, keyInMap -> new ArrayList())).add(task);
        }
    }

    private final class GlobalScheduledTask
    implements ScheduledTask,
    Runnable {
        private static final int STATE_IDLE = 0;
        private static final int STATE_EXECUTING = 1;
        private static final int STATE_EXECUTING_CANCELLED = 2;
        private static final int STATE_FINISHED = 3;
        private static final int STATE_CANCELLED = 4;
        private final Plugin plugin;
        private final long repeatDelay;
        private Consumer<ScheduledTask> run;
        private volatile int state;
        private static final VarHandle STATE_HANDLE = ConcurrentUtil.getVarHandle(GlobalScheduledTask.class, "state", Integer.TYPE);

        private GlobalScheduledTask(Plugin plugin, long repeatDelay, Consumer<ScheduledTask> run) {
            this.plugin = plugin;
            this.repeatDelay = repeatDelay;
            this.run = run;
        }

        private final int getStateVolatile() {
            return STATE_HANDLE.get(this);
        }

        private final int compareAndExchangeStateVolatile(int expect, int update) {
            return STATE_HANDLE.compareAndExchange(this, expect, update);
        }

        private final void setStateVolatile(int value) {
            STATE_HANDLE.setVolatile(this, value);
        }

        @Override
        public void run() {
            boolean repeating = this.isRepeatingTask();
            if (0 != this.compareAndExchangeStateVolatile(0, 1)) {
                return;
            }
            try {
                this.run.accept(this);
            }
            catch (Throwable throwable) {
                this.plugin.getLogger().log(Level.WARNING, "Global task for " + this.plugin.getDescription().getFullName() + " generated an exception", throwable);
            }
            finally {
                boolean reschedule = false;
                if (!repeating) {
                    this.setStateVolatile(3);
                } else if (1 == this.compareAndExchangeStateVolatile(1, 0)) {
                    reschedule = true;
                }
                if (!reschedule) {
                    this.run = null;
                } else {
                    FoliaGlobalRegionScheduler.this.scheduleInternal(this, this.repeatDelay);
                }
            }
        }

        public Plugin getOwningPlugin() {
            return this.plugin;
        }

        public boolean isRepeatingTask() {
            return this.repeatDelay > 0L;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public ScheduledTask.CancelledState cancel() {
            int curr = this.getStateVolatile();
            block7: while (true) {
                switch (curr) {
                    case 0: {
                        curr = this.compareAndExchangeStateVolatile(0, 4);
                        if (0 != curr) continue block7;
                        this.state = 4;
                        this.run = null;
                        return ScheduledTask.CancelledState.CANCELLED_BY_CALLER;
                    }
                    case 1: {
                        if (!this.isRepeatingTask()) {
                            return ScheduledTask.CancelledState.RUNNING;
                        }
                        curr = this.compareAndExchangeStateVolatile(1, 2);
                        if (1 == curr) return ScheduledTask.CancelledState.NEXT_RUNS_CANCELLED;
                        continue block7;
                    }
                    case 2: {
                        return ScheduledTask.CancelledState.NEXT_RUNS_CANCELLED_ALREADY;
                    }
                    case 3: {
                        return ScheduledTask.CancelledState.ALREADY_EXECUTED;
                    }
                    case 4: {
                        return ScheduledTask.CancelledState.CANCELLED_ALREADY;
                    }
                }
                break;
            }
            throw new IllegalStateException("Unknown state: " + curr);
        }

        public ScheduledTask.ExecutionState getExecutionState() {
            int state = this.getStateVolatile();
            switch (state) {
                case 0: {
                    return ScheduledTask.ExecutionState.IDLE;
                }
                case 1: {
                    return ScheduledTask.ExecutionState.RUNNING;
                }
                case 2: {
                    return ScheduledTask.ExecutionState.CANCELLED_RUNNING;
                }
                case 3: {
                    return ScheduledTask.ExecutionState.FINISHED;
                }
                case 4: {
                    return ScheduledTask.ExecutionState.CANCELLED;
                }
            }
            throw new IllegalStateException("Unknown state: " + state);
        }
    }
}

