/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.plugin.provider.source;

import io.papermc.paper.plugin.PluginInitializerManager;
import io.papermc.paper.plugin.entrypoint.EntrypointHandler;
import io.papermc.paper.plugin.provider.source.ProviderSource;
import io.papermc.paper.plugin.provider.type.PluginFileType;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Set;
import java.util.function.Function;
import java.util.jar.JarFile;
import org.bukkit.plugin.InvalidPluginException;
import org.jetbrains.annotations.Nullable;

public class FileProviderSource
implements ProviderSource<Path, Path> {
    private final Function<Path, String> contextChecker;
    private final boolean applyRemap;

    public FileProviderSource(Function<Path, String> contextChecker, boolean applyRemap) {
        this.contextChecker = contextChecker;
        this.applyRemap = applyRemap;
    }

    public FileProviderSource(Function<Path, String> contextChecker) {
        this(contextChecker, true);
    }

    @Override
    public Path prepareContext(Path context) throws IOException {
        String source = this.contextChecker.apply(context);
        if (Files.notExists(context, new LinkOption[0])) {
            throw new IllegalArgumentException(source + " does not exist, cannot load a plugin from it!");
        }
        if (!Files.isRegularFile(context, new LinkOption[0])) {
            throw new IllegalArgumentException(source + " is not a file, cannot load a plugin from it!");
        }
        if (!context.getFileName().toString().endsWith(".jar")) {
            throw new IllegalArgumentException(source + " is not a jar file, cannot load a plugin from it!");
        }
        try {
            context = this.checkUpdate(context);
        }
        catch (Exception exception) {
            throw new RuntimeException(source + " failed to update!", exception);
        }
        if (this.applyRemap && PluginInitializerManager.instance().pluginRemapper != null) {
            context = PluginInitializerManager.instance().pluginRemapper.rewritePlugin(context);
        }
        return context;
    }

    @Override
    public void registerProviders(EntrypointHandler entrypointHandler, Path context) throws Exception {
        String source = this.contextChecker.apply(context);
        JarFile file = new JarFile(context.toFile(), true, 1, JarFile.runtimeVersion());
        PluginFileType<?, ?> type = PluginFileType.guessType(file);
        if (type == null) {
            if (file.getEntry("META-INF/versions.list") != null) {
                throw new RuntimeException(new IllegalArgumentException(String.valueOf(context) + " appears to be a server jar! Server jars do not belong in the plugin folder."));
            }
            throw new RuntimeException(new IllegalArgumentException(source + " does not contain a " + String.join((CharSequence)" or ", PluginFileType.getConfigTypes()) + "! Could not determine plugin type, cannot load a plugin from it!"));
        }
        type.register(entrypointHandler, file, context);
    }

    private Path checkUpdate(Path file) throws InvalidPluginException {
        block5: {
            PluginInitializerManager pluginSystem = PluginInitializerManager.instance();
            Path updateDirectory = pluginSystem.pluginUpdatePath();
            if (updateDirectory == null || !Files.isDirectory(updateDirectory, new LinkOption[0])) {
                return file;
            }
            try {
                String pluginName = this.getPluginName(file);
                UpdateFileVisitor visitor = new UpdateFileVisitor(pluginName);
                Files.walkFileTree(updateDirectory, Set.of(), 1, visitor);
                if (visitor.getValidPlugin() == null) break block5;
                Path updateLocation = visitor.getValidPlugin();
                try {
                    Files.copy(updateLocation, file, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException exception) {
                    throw new RuntimeException("Could not copy '" + String.valueOf(updateLocation) + "' to '" + String.valueOf(file) + "' in update plugin process", exception);
                }
                File newName = new File(file.toFile().getParentFile(), updateLocation.toFile().getName());
                file.toFile().renameTo(newName);
                updateLocation.toFile().delete();
                return newName.toPath();
            }
            catch (Exception e) {
                throw new InvalidPluginException((Throwable)e);
            }
        }
        return file;
    }

    private String getPluginName(Path path) throws Exception {
        try (JarFile file = new JarFile(path.toFile());){
            PluginFileType<?, ?> type = PluginFileType.guessType(file);
            if (type == null) {
                throw new IllegalArgumentException(String.valueOf(path) + " does not contain a " + String.join((CharSequence)" or ", PluginFileType.getConfigTypes()) + "! Could not determine plugin type, cannot load a plugin from it!");
            }
            String string = type.getConfig(file).getName();
            return string;
        }
    }

    private class UpdateFileVisitor
    implements FileVisitor<Path> {
        private final String targetName;
        @Nullable
        private Path validPlugin;

        private UpdateFileVisitor(String targetName) {
            this.targetName = targetName;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            try {
                String updatePluginName = FileProviderSource.this.getPluginName(file);
                if (this.targetName.equals(updatePluginName)) {
                    this.validPlugin = file;
                    return FileVisitResult.TERMINATE;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Nullable
        public Path getValidPlugin() {
            return this.validPlugin;
        }
    }
}

