/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.configuration.type.fallback;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.math.NumberUtils;
import org.spigotmc.SpigotWorldConfig;
import org.spongepowered.configurate.serialize.SerializationException;

public abstract sealed class FallbackValue {
    private static final String DEFAULT_VALUE = "default";
    static final ContextKey<SpigotWorldConfig> SPIGOT_WORLD_CONFIG = new ContextKey("SpigotWorldConfig");
    static final ContextKey<Supplier<MinecraftServer>> MINECRAFT_SERVER = new ContextKey("MinecraftServer");
    private final Map<ContextKey<?>, Object> contextMap;

    protected FallbackValue(Map<ContextKey<?>, Object> contextMap) {
        for (ContextKey<?> contextKey : this.required()) {
            Preconditions.checkArgument((boolean)contextMap.containsKey(contextKey), (Object)(String.valueOf(contextMap) + " is missing " + String.valueOf(contextKey)));
        }
        this.contextMap = contextMap;
    }

    protected abstract String serialize();

    protected abstract Set<ContextKey<?>> required();

    protected <T> T get(ContextKey<T> contextKey) {
        return (T)Objects.requireNonNull(this.contextMap.get(contextKey), "Missing " + String.valueOf(contextKey));
    }

    static class ContextKey<T> {
        private final String name;

        ContextKey(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        Map<ContextKey<?>, Object> singleton(T value) {
            return Map.of(this, value);
        }
    }

    public static abstract non-sealed class Int
    extends FallbackValue {
        private final OptionalInt value;

        Int(Map<ContextKey<?>, Object> contextMap, OptionalInt value) {
            super(contextMap);
            this.value = value.isEmpty() ? value : this.process(value.getAsInt());
        }

        public int value() {
            return this.value.orElseGet(this::fallback);
        }

        @Override
        protected final String serialize() {
            return this.value.isPresent() ? String.valueOf(this.value.getAsInt()) : FallbackValue.DEFAULT_VALUE;
        }

        protected OptionalInt process(int value) {
            return OptionalInt.of(value);
        }

        protected abstract int fallback();

        protected static OptionalInt fromObject(Object obj) throws SerializationException {
            if (obj instanceof OptionalInt) {
                OptionalInt optionalInt = (OptionalInt)obj;
                return optionalInt;
            }
            if (obj instanceof String) {
                String string = (String)obj;
                if (FallbackValue.DEFAULT_VALUE.equalsIgnoreCase(string)) {
                    return OptionalInt.empty();
                }
                if (NumberUtils.isParsable((String)string)) {
                    return OptionalInt.of(Integer.parseInt(string));
                }
            } else if (obj instanceof Integer) {
                Integer num = (Integer)obj;
                return OptionalInt.of(num);
            }
            throw new SerializationException(String.valueOf(obj) + " is not a integer or 'default'");
        }
    }
}

