/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.adventure;

import io.papermc.paper.adventure.PaperAdventure;
import java.util.List;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.util.FormattedCharSequence;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.jetbrains.annotations.Nullable;

public final class AdventureComponent
implements Component {
    final net.kyori.adventure.text.Component adventure;
    private @MonotonicNonNull Component vanilla;

    public AdventureComponent(net.kyori.adventure.text.Component adventure) {
        this.adventure = adventure;
    }

    public Component deepConverted() {
        Component vanilla = this.vanilla;
        if (vanilla == null) {
            this.vanilla = vanilla = (Component)PaperAdventure.WRAPPER_AWARE_SERIALIZER.serialize(this.adventure);
        }
        return vanilla;
    }

    public @Nullable Component deepConvertedIfPresent() {
        return this.vanilla;
    }

    @Override
    public Style getStyle() {
        return this.deepConverted().getStyle();
    }

    @Override
    public ComponentContents getContents() {
        if (this.adventure instanceof TextComponent) {
            return PlainTextContents.create(((TextComponent)this.adventure).content());
        }
        return this.deepConverted().getContents();
    }

    @Override
    public String getString() {
        return PlainTextComponentSerializer.plainText().serialize(this.adventure);
    }

    @Override
    public List<Component> getSiblings() {
        return this.deepConverted().getSiblings();
    }

    @Override
    public MutableComponent plainCopy() {
        return this.deepConverted().plainCopy();
    }

    @Override
    public MutableComponent copy() {
        return this.deepConverted().copy();
    }

    @Override
    public FormattedCharSequence getVisualOrderText() {
        return this.deepConverted().getVisualOrderText();
    }

    public net.kyori.adventure.text.Component adventure$component() {
        return this.adventure;
    }

    public int hashCode() {
        return this.deepConverted().hashCode();
    }

    public boolean equals(Object obj) {
        return this.deepConverted().equals(obj);
    }
}

