/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.util.misc;

import com.destroystokyo.paper.util.misc.PooledLinkedHashSets;
import io.papermc.paper.util.IntegerUtil;
import io.papermc.paper.util.MCUtil;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.ChunkPos;

public abstract class AreaMap<E> {
    protected final Object2LongOpenHashMap<E> objectToLastCoordinate = new Object2LongOpenHashMap();
    protected final Object2IntOpenHashMap<E> objectToViewDistance = new Object2IntOpenHashMap();
    protected final Long2ObjectOpenHashMap<PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<E>> areaMap;
    protected final PooledLinkedHashSets<E> pooledHashSets;
    protected final ChangeCallback<E> addCallback;
    protected final ChangeCallback<E> removeCallback;
    protected final ChangeSourceCallback<E> changeSourceCallback;

    public AreaMap() {
        this(new PooledLinkedHashSets());
    }

    public AreaMap(PooledLinkedHashSets<E> pooledHashSets) {
        this(pooledHashSets, null, null);
    }

    public AreaMap(PooledLinkedHashSets<E> pooledHashSets, ChangeCallback<E> addCallback, ChangeCallback<E> removeCallback) {
        this(pooledHashSets, addCallback, removeCallback, null);
    }

    public AreaMap(PooledLinkedHashSets<E> pooledHashSets, ChangeCallback<E> addCallback, ChangeCallback<E> removeCallback, ChangeSourceCallback<E> changeSourceCallback) {
        this.objectToViewDistance.defaultReturnValue(-1);
        this.objectToLastCoordinate.defaultReturnValue(Long.MIN_VALUE);
        this.areaMap = new Long2ObjectOpenHashMap(1024, 0.7f);
        this.pooledHashSets = pooledHashSets;
        this.addCallback = addCallback;
        this.removeCallback = removeCallback;
        this.changeSourceCallback = changeSourceCallback;
    }

    @Nullable
    public final PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<E> getObjectsInRange(long key) {
        return (PooledLinkedHashSets.PooledObjectLinkedOpenHashSet)this.areaMap.get(key);
    }

    @Nullable
    public final PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<E> getObjectsInRange(ChunkPos chunkPos) {
        return (PooledLinkedHashSets.PooledObjectLinkedOpenHashSet)this.areaMap.get(MCUtil.getCoordinateKey(chunkPos));
    }

    @Nullable
    public final PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<E> getObjectsInRange(int chunkX, int chunkZ) {
        return (PooledLinkedHashSets.PooledObjectLinkedOpenHashSet)this.areaMap.get(MCUtil.getCoordinateKey(chunkX, chunkZ));
    }

    public final long getLastCoordinate(E object) {
        return this.objectToLastCoordinate.getOrDefault(object, Long.MIN_VALUE);
    }

    public final int getLastViewDistance(E object) {
        return this.objectToViewDistance.getOrDefault(object, -1);
    }

    public final int size() {
        return this.areaMap.size();
    }

    public final void addOrUpdate(E object, int chunkX, int chunkZ, int viewDistance) {
        int oldViewDistance = this.objectToViewDistance.put(object, viewDistance);
        long newPos = MCUtil.getCoordinateKey(chunkX, chunkZ);
        long oldPos = this.objectToLastCoordinate.put(object, newPos);
        if (oldViewDistance == -1) {
            this.addObject(object, chunkX, chunkZ, Integer.MIN_VALUE, Integer.MIN_VALUE, viewDistance);
            this.addObjectCallback(object, chunkX, chunkZ, viewDistance);
        } else {
            this.updateObject(object, oldPos, newPos, oldViewDistance, viewDistance);
            this.updateObjectCallback(object, oldPos, newPos, oldViewDistance, viewDistance);
        }
    }

    public final boolean update(E object, int chunkX, int chunkZ, int viewDistance) {
        int oldViewDistance = this.objectToViewDistance.replace(object, viewDistance);
        if (oldViewDistance == -1) {
            return false;
        }
        long newPos = MCUtil.getCoordinateKey(chunkX, chunkZ);
        long oldPos = this.objectToLastCoordinate.put(object, newPos);
        this.updateObject(object, oldPos, newPos, oldViewDistance, viewDistance);
        this.updateObjectCallback(object, oldPos, newPos, oldViewDistance, viewDistance);
        return true;
    }

    protected void updateObjectCallback(E Object2, long oldPosition, long newPosition, int oldViewDistance, int newViewDistance) {
        if (newPosition != oldPosition && this.changeSourceCallback != null) {
            this.changeSourceCallback.accept(Object2, oldPosition, newPosition);
        }
    }

    public final boolean add(E object, int chunkX, int chunkZ, int viewDistance) {
        int oldViewDistance = this.objectToViewDistance.putIfAbsent(object, viewDistance);
        if (oldViewDistance != -1) {
            return false;
        }
        long newPos = MCUtil.getCoordinateKey(chunkX, chunkZ);
        this.objectToLastCoordinate.put(object, newPos);
        this.addObject(object, chunkX, chunkZ, Integer.MIN_VALUE, Integer.MIN_VALUE, viewDistance);
        this.addObjectCallback(object, chunkX, chunkZ, viewDistance);
        return true;
    }

    protected void addObjectCallback(E object, int chunkX, int chunkZ, int viewDistance) {
    }

    public final boolean remove(E object) {
        long position = this.objectToLastCoordinate.removeLong(object);
        int viewDistance = this.objectToViewDistance.removeInt(object);
        if (viewDistance == -1) {
            return false;
        }
        int currentX = MCUtil.getCoordinateX(position);
        int currentZ = MCUtil.getCoordinateZ(position);
        this.removeObject(object, currentX, currentZ, currentX, currentZ, viewDistance);
        this.removeObjectCallback(object, currentX, currentZ, viewDistance);
        return true;
    }

    protected void removeObjectCallback(E object, int chunkX, int chunkZ, int viewDistance) {
    }

    protected abstract PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<E> getEmptySetFor(E var1);

    protected void validate(E object, int viewDistance) {
        int entiesGot = 0;
        int expectedEntries = 2 * viewDistance + 1;
        expectedEntries *= expectedEntries;
        if (viewDistance < 0) {
            expectedEntries = 0;
        }
        long currPosition = this.objectToLastCoordinate.getLong(object);
        int centerX = MCUtil.getCoordinateX(currPosition);
        int centerZ = MCUtil.getCoordinateZ(currPosition);
        ObjectIterator iterator = this.areaMap.long2ObjectEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)iterator.next();
            long key = entry.getLongKey();
            PooledLinkedHashSets.PooledObjectLinkedOpenHashSet map = (PooledLinkedHashSets.PooledObjectLinkedOpenHashSet)entry.getValue();
            if (map.referenceCount == 0) {
                throw new IllegalStateException("Invalid map");
            }
            if (!map.contains(object)) continue;
            ++entiesGot;
            int chunkX = MCUtil.getCoordinateX(key);
            int chunkZ = MCUtil.getCoordinateZ(key);
            int dist = Math.max(IntegerUtil.branchlessAbs(chunkX - centerX), IntegerUtil.branchlessAbs(chunkZ - centerZ));
            if (dist <= viewDistance) continue;
            throw new IllegalStateException("Expected view distance " + viewDistance + ", got " + dist);
        }
        if (entiesGot != expectedEntries) {
            throw new IllegalStateException("Expected " + expectedEntries + ", got " + entiesGot);
        }
    }

    private void addObjectTo(E object, int chunkX, int chunkZ, int currChunkX, int currChunkZ, int prevChunkX, int prevChunkZ) {
        PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<E> empty;
        long key = MCUtil.getCoordinateKey(chunkX, chunkZ);
        PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<E> current = (PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<E>)this.areaMap.putIfAbsent(key, empty = this.getEmptySetFor(object));
        if (current != null) {
            PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<E> next = this.pooledHashSets.findMapWith(current, object);
            if (next == current) {
                throw new IllegalStateException("Expected different map: got " + next.toString());
            }
            this.areaMap.put(key, next);
            current = next;
        } else {
            current = empty;
        }
        if (this.addCallback != null) {
            try {
                this.addCallback.accept(object, chunkX, chunkZ, currChunkX, currChunkZ, prevChunkX, prevChunkZ, current);
            }
            catch (Throwable ex) {
                if (ex instanceof ThreadDeath) {
                    throw (ThreadDeath)ex;
                }
                MinecraftServer.LOGGER.error("Add callback for map threw exception ", ex);
            }
        }
    }

    private void removeObjectFrom(E object, int chunkX, int chunkZ, int currChunkX, int currChunkZ, int prevChunkX, int prevChunkZ) {
        long key = MCUtil.getCoordinateKey(chunkX, chunkZ);
        PooledLinkedHashSets.PooledObjectLinkedOpenHashSet current = (PooledLinkedHashSets.PooledObjectLinkedOpenHashSet)this.areaMap.get(key);
        if (current == null) {
            throw new IllegalStateException("Current map may not be null for " + String.valueOf(object) + ", (" + chunkX + "," + chunkZ + ")");
        }
        PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<E> next = this.pooledHashSets.findMapWithout(current, object);
        if (next == current) {
            throw new IllegalStateException("Current map [" + next.toString() + "] should have contained " + String.valueOf(object) + ", (" + chunkX + "," + chunkZ + ")");
        }
        if (next != null) {
            this.areaMap.put(key, next);
        } else {
            this.areaMap.remove(key);
        }
        if (this.removeCallback != null) {
            try {
                this.removeCallback.accept(object, chunkX, chunkZ, currChunkX, currChunkZ, prevChunkX, prevChunkZ, next);
            }
            catch (Throwable ex) {
                if (ex instanceof ThreadDeath) {
                    throw (ThreadDeath)ex;
                }
                MinecraftServer.LOGGER.error("Remove callback for map threw exception ", ex);
            }
        }
    }

    private void addObject(E object, int chunkX, int chunkZ, int prevChunkX, int prevChunkZ, int viewDistance) {
        int maxX = chunkX + viewDistance;
        int maxZ = chunkZ + viewDistance;
        int minX = chunkX - viewDistance;
        int minZ = chunkZ - viewDistance;
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                this.addObjectTo(object, x, z, chunkX, chunkZ, prevChunkX, prevChunkZ);
            }
        }
    }

    private void removeObject(E object, int chunkX, int chunkZ, int currentChunkX, int currentChunkZ, int viewDistance) {
        int maxX = chunkX + viewDistance;
        int maxZ = chunkZ + viewDistance;
        int minX = chunkX - viewDistance;
        int minZ = chunkZ - viewDistance;
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                this.removeObjectFrom(object, x, z, currentChunkX, currentChunkZ, chunkX, chunkZ);
            }
        }
    }

    protected static int sign(int val) {
        return 1 | val >> 31;
    }

    private void updateObject(E object, long oldPosition, long newPosition, int oldViewDistance, int newViewDistance) {
        int currZ;
        int currX;
        int minZ;
        int maxZ;
        int minX;
        int maxX;
        int totalZ;
        int toX = MCUtil.getCoordinateX(newPosition);
        int toZ = MCUtil.getCoordinateZ(newPosition);
        int fromX = MCUtil.getCoordinateX(oldPosition);
        int fromZ = MCUtil.getCoordinateZ(oldPosition);
        int dx = toX - fromX;
        int dz = toZ - fromZ;
        int totalX = IntegerUtil.branchlessAbs(fromX - toX);
        if (Math.max(totalX, totalZ = IntegerUtil.branchlessAbs(fromZ - toZ)) > 2 * Math.max(newViewDistance, oldViewDistance)) {
            this.removeObject(object, fromX, fromZ, fromX, fromZ, oldViewDistance);
            this.addObject(object, toX, toZ, fromX, fromZ, newViewDistance);
            return;
        }
        if (oldViewDistance != newViewDistance) {
            int oldMinX = fromX - oldViewDistance;
            int oldMinZ = fromZ - oldViewDistance;
            int oldMaxX = fromX + oldViewDistance;
            int oldMaxZ = fromZ + oldViewDistance;
            for (int currX2 = oldMinX; currX2 <= oldMaxX; ++currX2) {
                for (int currZ2 = oldMinZ; currZ2 <= oldMaxZ; ++currZ2) {
                    if (Math.max(IntegerUtil.branchlessAbs(currX2 - toX), IntegerUtil.branchlessAbs(currZ2 - toZ)) <= newViewDistance) continue;
                    this.removeObjectFrom(object, currX2, currZ2, toX, toZ, fromX, fromZ);
                }
            }
            int newMinX = toX - newViewDistance;
            int newMinZ = toZ - newViewDistance;
            int newMaxX = toX + newViewDistance;
            int newMaxZ = toZ + newViewDistance;
            for (int currX3 = newMinX; currX3 <= newMaxX; ++currX3) {
                for (int currZ3 = newMinZ; currZ3 <= newMaxZ; ++currZ3) {
                    if (Math.max(IntegerUtil.branchlessAbs(currX3 - fromX), IntegerUtil.branchlessAbs(currZ3 - fromZ)) <= oldViewDistance) continue;
                    this.addObjectTo(object, currX3, currZ3, toX, toZ, fromX, fromZ);
                }
            }
            return;
        }
        int up = AreaMap.sign(dz);
        int right = AreaMap.sign(dx);
        if (dx != 0) {
            maxX = toX + oldViewDistance * right + right;
            minX = fromX + oldViewDistance * right + right;
            maxZ = fromZ + oldViewDistance * up + up;
            minZ = toZ - oldViewDistance * up;
            for (currX = minX; currX != maxX; currX += right) {
                for (currZ = minZ; currZ != maxZ; currZ += up) {
                    this.addObjectTo(object, currX, currZ, toX, toZ, fromX, fromZ);
                }
            }
        }
        if (dz != 0) {
            maxX = toX + oldViewDistance * right + right;
            minX = toX - oldViewDistance * right;
            maxZ = toZ + oldViewDistance * up + up;
            minZ = fromZ + oldViewDistance * up + up;
            for (currX = minX; currX != maxX; currX += right) {
                for (currZ = minZ; currZ != maxZ; currZ += up) {
                    this.addObjectTo(object, currX, currZ, toX, toZ, fromX, fromZ);
                }
            }
        }
        if (dx != 0) {
            maxX = toX - oldViewDistance * right;
            minX = fromX - oldViewDistance * right;
            maxZ = fromZ + oldViewDistance * up + up;
            minZ = toZ - oldViewDistance * up;
            for (currX = minX; currX != maxX; currX += right) {
                for (currZ = minZ; currZ != maxZ; currZ += up) {
                    this.removeObjectFrom(object, currX, currZ, toX, toZ, fromX, fromZ);
                }
            }
        }
        if (dz != 0) {
            maxX = fromX + oldViewDistance * right + right;
            minX = fromX - oldViewDistance * right;
            maxZ = toZ - oldViewDistance * up;
            minZ = fromZ - oldViewDistance * up;
            for (currX = minX; currX != maxX; currX += right) {
                for (currZ = minZ; currZ != maxZ; currZ += up) {
                    this.removeObjectFrom(object, currX, currZ, toX, toZ, fromX, fromZ);
                }
            }
        }
    }

    @FunctionalInterface
    public static interface ChangeCallback<E> {
        public void accept(E var1, int var2, int var3, int var4, int var5, int var6, int var7, PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<E> var8);
    }

    @FunctionalInterface
    public static interface ChangeSourceCallback<E> {
        public void accept(E var1, long var2, long var4);
    }
}

