/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.loottable;

import com.destroystokyo.paper.loottable.LootableInventory;
import com.destroystokyo.paper.loottable.PaperLootable;
import com.destroystokyo.paper.loottable.PaperLootableInventoryData;
import java.util.UUID;
import net.minecraft.world.level.Level;
import org.bukkit.World;

public interface PaperLootableInventory
extends PaperLootable,
LootableInventory {
    public PaperLootableInventoryData lootableDataForAPI();

    public Level getNMSWorld();

    default public World getBukkitWorld() {
        return this.getNMSWorld().getWorld();
    }

    default public boolean isRefillEnabled() {
        return this.getNMSWorld().paperConfig().lootables.autoReplenish;
    }

    default public boolean hasBeenFilled() {
        return this.getLastFilled() != -1L;
    }

    default public boolean hasPlayerLooted(UUID player) {
        return this.lootableDataForAPI().hasPlayerLooted(player);
    }

    default public boolean canPlayerLoot(UUID player) {
        return this.lootableDataForAPI().canPlayerLoot(player, this.getNMSWorld().paperConfig());
    }

    default public Long getLastLooted(UUID player) {
        return this.lootableDataForAPI().getLastLooted(player);
    }

    default public boolean setHasPlayerLooted(UUID player, boolean looted) {
        boolean hasLooted = this.hasPlayerLooted(player);
        if (hasLooted != looted) {
            this.lootableDataForAPI().setPlayerLootedState(player, looted);
        }
        return hasLooted;
    }

    default public boolean hasPendingRefill() {
        long nextRefill = this.lootableDataForAPI().getNextRefill();
        return nextRefill != -1L && nextRefill > this.lootableDataForAPI().getLastFill();
    }

    default public long getLastFilled() {
        return this.lootableDataForAPI().getLastFill();
    }

    default public long getNextRefill() {
        return this.lootableDataForAPI().getNextRefill();
    }

    default public long setNextRefill(long refillAt) {
        if (refillAt < -1L) {
            refillAt = -1L;
        }
        return this.lootableDataForAPI().setNextRefill(refillAt);
    }
}

