/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.entity.ai;

import com.destroystokyo.paper.entity.ai.Goal;
import com.destroystokyo.paper.entity.ai.GoalKey;
import com.destroystokyo.paper.entity.ai.MobGoalHelper;
import net.minecraft.world.entity.ai.goal.Goal;
import org.bukkit.entity.Mob;

public class PaperCustomGoal<T extends Mob>
extends net.minecraft.world.entity.ai.goal.Goal {
    private final Goal<T> handle;

    public PaperCustomGoal(Goal<T> handle) {
        this.handle = handle;
        this.setFlags(MobGoalHelper.paperToVanilla(handle.getTypes()));
        if (this.getFlags().size() == 0) {
            this.getFlags().add(Goal.Flag.UNKNOWN_BEHAVIOR);
        }
    }

    @Override
    public boolean canUse() {
        return this.handle.shouldActivate();
    }

    @Override
    public boolean canContinueToUse() {
        return this.handle.shouldStayActive();
    }

    @Override
    public void start() {
        this.handle.start();
    }

    @Override
    public void stop() {
        this.handle.stop();
    }

    @Override
    public void tick() {
        this.handle.tick();
    }

    public Goal<T> getHandle() {
        return this.handle;
    }

    public GoalKey<T> getKey() {
        return this.handle.getKey();
    }
}

