/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.timings;

import co.aikar.timings.NullTimingHandler;
import co.aikar.timings.Timing;
import co.aikar.timings.Timings;
import co.aikar.timings.TimingsManager;
import com.google.common.collect.MapMaker;
import io.papermc.paper.configuration.GlobalConfiguration;
import java.util.Map;
import net.minecraft.commands.functions.CommandFunction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.bukkit.craftbukkit.scheduler.CraftTask;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

@Deprecated(forRemoval=true)
public final class MinecraftTimings {
    public static final Timing serverOversleep = Timings.ofSafe((String)"Server Oversleep");
    public static final Timing playerListTimer = Timings.ofSafe((String)"Player List");
    public static final Timing commandFunctionsTimer = Timings.ofSafe((String)"Command Functions");
    public static final Timing connectionTimer = Timings.ofSafe((String)"Connection Handler");
    public static final Timing tickablesTimer = Timings.ofSafe((String)"Tickables");
    public static final Timing minecraftSchedulerTimer = Timings.ofSafe((String)"Minecraft Scheduler");
    public static final Timing bukkitSchedulerTimer = Timings.ofSafe((String)"Bukkit Scheduler");
    public static final Timing bukkitSchedulerPendingTimer = Timings.ofSafe((String)"Bukkit Scheduler - Pending");
    public static final Timing bukkitSchedulerFinishTimer = Timings.ofSafe((String)"Bukkit Scheduler - Finishing");
    public static final Timing chunkIOTickTimer = Timings.ofSafe((String)"ChunkIOTick");
    public static final Timing timeUpdateTimer = Timings.ofSafe((String)"Time Update");
    public static final Timing serverCommandTimer = Timings.ofSafe((String)"Server Command");
    public static final Timing savePlayers = Timings.ofSafe((String)"Save Players");
    public static final Timing tickEntityTimer = Timings.ofSafe((String)"## tickEntity");
    public static final Timing tickTileEntityTimer = Timings.ofSafe((String)"## tickTileEntity");
    public static final Timing packetProcessTimer = Timings.ofSafe((String)"## Packet Processing");
    public static final Timing scheduledBlocksTimer = Timings.ofSafe((String)"## Scheduled Blocks");
    public static final Timing structureGenerationTimer = Timings.ofSafe((String)"Structure Generation");
    public static final Timing processQueueTimer = Timings.ofSafe((String)"processQueue");
    public static final Timing processTasksTimer = Timings.ofSafe((String)"processTasks");
    public static final Timing playerCommandTimer = Timings.ofSafe((String)"playerCommand");
    public static final Timing entityActivationCheckTimer = Timings.ofSafe((String)"entityActivationCheck");
    public static final Timing antiXrayUpdateTimer = Timings.ofSafe((String)"anti-xray - update");
    public static final Timing antiXrayObfuscateTimer = Timings.ofSafe((String)"anti-xray - obfuscate");
    public static final Timing scoreboardScoreSearch = Timings.ofSafe((String)"Scoreboard score search");
    private static final Map<Class<?>, String> taskNameCache = new MapMaker().weakKeys().makeMap();

    private MinecraftTimings() {
    }

    public static Timing getInternalTaskName(String taskName) {
        return Timings.ofSafe((String)taskName);
    }

    public static Timing getPluginTaskTimings(BukkitTask bukkitTask, long period) {
        if (!bukkitTask.isSync()) {
            return NullTimingHandler.NULL;
        }
        CraftTask craftTask = (CraftTask)bukkitTask;
        Class<?> taskClass = craftTask.getTaskClass();
        Plugin plugin = bukkitTask.getOwner() != null ? bukkitTask.getOwner() : TimingsManager.getPluginByClassloader(taskClass);
        String taskname = taskNameCache.computeIfAbsent(taskClass, clazz -> {
            try {
                String clsName;
                String string = clsName = !clazz.isMemberClass() ? clazz.getName() : clazz.getCanonicalName();
                if (clsName != null && clsName.contains("$Lambda$")) {
                    clsName = clsName.replaceAll("(Lambda\\$.*?)/.*", "$1");
                }
                return clsName != null ? clsName : "UnknownTask";
            }
            catch (Throwable ex) {
                new Exception("Error occurred detecting class name", ex).printStackTrace();
                return "MangledClassFile";
            }
        });
        StringBuilder name = new StringBuilder(64);
        name.append("Task: ").append(taskname);
        if (period > 0L) {
            name.append(" (interval:").append(period).append(")");
        } else {
            name.append(" (Single)");
        }
        if (plugin == null) {
            return Timings.ofSafe(null, (String)name.toString());
        }
        return Timings.ofSafe((Plugin)plugin, (String)name.toString());
    }

    public static Timing getEntityTimings(String entityType, String type) {
        return Timings.ofSafe((String)"Minecraft", (String)("## tickEntity - " + entityType + " - " + type), (Timing)tickEntityTimer);
    }

    public static Timing getBehaviorTimings(String type) {
        return Timings.ofSafe((String)("## Behavior - " + type));
    }

    public static Timing getSensorTimings(String type, int rate) {
        return Timings.ofSafe((String)("## Sensor - " + type + " (Default rate: " + rate + ")"));
    }

    public static Timing getTileEntityTimings(BlockEntity entity) {
        String entityType = entity.getClass().getName();
        return Timings.ofSafe((String)"Minecraft", (String)("## tickTileEntity - " + entityType), (Timing)tickTileEntityTimer);
    }

    public static Timing getCancelTasksTimer() {
        return Timings.ofSafe((String)"Cancel Tasks");
    }

    public static Timing getCancelTasksTimer(Plugin plugin) {
        return Timings.ofSafe((Plugin)plugin, (String)"Cancel Tasks");
    }

    public static void stopServer() {
        TimingsManager.stopServer();
    }

    public static Timing getBlockTiming(Block block) {
        return Timings.ofSafe((String)("## Scheduled Block: " + block.toString()), (Timing)scheduledBlocksTimer);
    }

    public static Timing getPacketTiming(Packet packet) {
        return Timings.ofSafe((String)("## Packet - " + packet.getClass().getName()), (Timing)packetProcessTimer);
    }

    public static Timing getCommandFunctionTiming(CommandFunction<?> function) {
        return Timings.ofSafe((String)("Command Function - " + String.valueOf(function.id())));
    }

    public static void processConfig(GlobalConfiguration.Timings config) {
        TimingsManager.url = config.url;
        if (!TimingsManager.url.endsWith("/")) {
            TimingsManager.url = TimingsManager.url + "/";
        }
        TimingsManager.privacy = config.serverNamePrivacy;
        if (!config.hiddenConfigEntries.contains("proxies.velocity.secret")) {
            config.hiddenConfigEntries.add("proxies.velocity.secret");
        }
        TimingsManager.hiddenConfigs.addAll(config.hiddenConfigEntries);
        Timings.setVerboseTimingsEnabled((boolean)config.verbose);
        Timings.setTimingsEnabled((boolean)config.enabled);
        Timings.setHistoryInterval((int)(config.historyInterval * 20));
        Timings.setHistoryLength((int)(config.historyLength * 20));
    }
}

