/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.chunk_system.scheduling.task;

import ca.spottedleaf.concurrentutil.executor.standard.PrioritisedExecutor;
import ca.spottedleaf.concurrentutil.util.ConcurrentUtil;
import ca.spottedleaf.moonrise.patches.chunk_system.level.poi.PoiChunk;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkTaskScheduler;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.task.ChunkProgressionTask;
import java.lang.invoke.VarHandle;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkStatusTasks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChunkFullTask
extends ChunkProgressionTask
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChunkFullTask.class);
    private final NewChunkHolder chunkHolder;
    private final ChunkAccess fromChunk;
    private final PrioritisedExecutor.PrioritisedTask convertToFullTask;
    protected volatile boolean scheduled;
    protected static final VarHandle SCHEDULED_HANDLE = ConcurrentUtil.getVarHandle(ChunkFullTask.class, "scheduled", Boolean.TYPE);

    public ChunkFullTask(ChunkTaskScheduler scheduler, ServerLevel world, int chunkX, int chunkZ, NewChunkHolder chunkHolder, ChunkAccess fromChunk, PrioritisedExecutor.Priority priority) {
        super(scheduler, world, chunkX, chunkZ);
        this.chunkHolder = chunkHolder;
        this.fromChunk = fromChunk;
        this.convertToFullTask = scheduler.createChunkTask(chunkX, chunkZ, this, priority);
    }

    @Override
    public ChunkStatus getTargetStatus() {
        return ChunkStatus.FULL;
    }

    @Override
    public void run() {
        LevelChunk chunk;
        try {
            PoiChunk poiChunk = this.chunkHolder.getPoiChunk();
            if (poiChunk == null) {
                LOGGER.error("Expected poi chunk to be loaded with chunk for task " + this.toString());
            } else {
                poiChunk.load();
                this.world.getPoiManager().moonrise$checkConsistency(this.fromChunk);
            }
            ChunkAccess chunkAccess = this.fromChunk;
            if (chunkAccess instanceof ImposterProtoChunk) {
                ImposterProtoChunk wrappedFull = (ImposterProtoChunk)chunkAccess;
                chunk = wrappedFull.getWrapped();
            } else {
                ServerLevel world = this.world;
                ProtoChunk protoChunk = (ProtoChunk)this.fromChunk;
                chunk = new LevelChunk(this.world, protoChunk, unused -> ChunkStatusTasks.postLoadProtoChunk(world, protoChunk.getEntities(), protoChunk.getPos()));
                this.chunkHolder.replaceProtoChunk(new ImposterProtoChunk(chunk, false));
            }
            NewChunkHolder chunkHolder = this.chunkHolder;
            chunk.setFullStatus(chunkHolder::getChunkStatus);
            chunk.runPostLoad();
            this.world.moonrise$getChunkTaskScheduler().chunkHolderManager.getOrCreateEntityChunk(this.chunkX, this.chunkZ, false);
            chunk.setLoaded(true);
            chunk.registerAllBlockEntitiesAfterLevelLoad();
            chunk.registerTickContainerInLevel(this.world);
        }
        catch (Throwable throwable) {
            this.complete(null, throwable);
            return;
        }
        this.complete(chunk, null);
    }

    @Override
    public boolean isScheduled() {
        return this.scheduled;
    }

    @Override
    public void schedule() {
        if (SCHEDULED_HANDLE.getAndSet(this, true)) {
            throw new IllegalStateException("Cannot double call schedule()");
        }
        this.convertToFullTask.queue();
    }

    @Override
    public void cancel() {
        if (this.convertToFullTask.cancel()) {
            this.complete(null, null);
        }
    }

    @Override
    public PrioritisedExecutor.Priority getPriority() {
        return this.convertToFullTask.getPriority();
    }

    @Override
    public void lowerPriority(PrioritisedExecutor.Priority priority) {
        if (!PrioritisedExecutor.Priority.isValidPriority(priority)) {
            throw new IllegalArgumentException("Invalid priority " + String.valueOf((Object)priority));
        }
        this.convertToFullTask.lowerPriority(priority);
    }

    @Override
    public void setPriority(PrioritisedExecutor.Priority priority) {
        if (!PrioritisedExecutor.Priority.isValidPriority(priority)) {
            throw new IllegalArgumentException("Invalid priority " + String.valueOf((Object)priority));
        }
        this.convertToFullTask.setPriority(priority);
    }

    @Override
    public void raisePriority(PrioritisedExecutor.Priority priority) {
        if (!PrioritisedExecutor.Priority.isValidPriority(priority)) {
            throw new IllegalArgumentException("Invalid priority " + String.valueOf((Object)priority));
        }
        this.convertToFullTask.raisePriority(priority);
    }
}

