/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.chunk_system.io.datacontroller;

import ca.spottedleaf.moonrise.patches.chunk_system.io.RegionFileIOThread;
import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.storage.EntityStorage;
import net.minecraft.world.level.chunk.storage.RegionFileStorage;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;

public final class EntityDataController
extends RegionFileIOThread.ChunkDataController {
    private final EntityRegionFileStorage storage;

    public EntityDataController(EntityRegionFileStorage storage) {
        super(RegionFileIOThread.RegionFileType.ENTITY_DATA);
        this.storage = storage;
    }

    @Override
    public RegionFileStorage getCache() {
        return this.storage;
    }

    @Override
    public void writeData(int chunkX, int chunkZ, CompoundTag compound) throws IOException {
        this.storage.write(new ChunkPos(chunkX, chunkZ), compound);
    }

    @Override
    public CompoundTag readData(int chunkX, int chunkZ) throws IOException {
        return this.storage.read(new ChunkPos(chunkX, chunkZ));
    }

    public static final class EntityRegionFileStorage
    extends RegionFileStorage {
        public EntityRegionFileStorage(RegionStorageInfo regionStorageInfo, Path directory, boolean dsync) {
            super(regionStorageInfo, directory, dsync);
        }

        @Override
        public void write(ChunkPos pos, CompoundTag nbt) throws IOException {
            ChunkPos nbtPos;
            ChunkPos chunkPos = nbtPos = nbt == null ? null : EntityStorage.readChunkPos(nbt);
            if (nbtPos != null && !pos.equals(nbtPos)) {
                throw new IllegalArgumentException("Entity chunk coordinate and serialized data do not have matching coordinates, trying to serialize coordinate " + pos.toString() + " but compound says coordinate is " + String.valueOf(nbtPos) + " for world: " + String.valueOf(this));
            }
            super.write(pos, nbt);
        }
    }
}

