/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.chunk_system;

import ca.spottedleaf.concurrentutil.executor.standard.PrioritisedExecutor;
import ca.spottedleaf.moonrise.patches.chunk_system.player.RegionizedPlayerChunkLoader;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import org.slf4j.Logger;

public final class ChunkSystem {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void scheduleChunkTask(ServerLevel level, int chunkX, int chunkZ, Runnable run) {
        ChunkSystem.scheduleChunkTask(level, chunkX, chunkZ, run, PrioritisedExecutor.Priority.NORMAL);
    }

    public static void scheduleChunkTask(ServerLevel level, int chunkX, int chunkZ, Runnable run, PrioritisedExecutor.Priority priority) {
        level.moonrise$getChunkTaskScheduler().scheduleChunkTask(chunkX, chunkZ, run, priority);
    }

    public static void scheduleChunkLoad(ServerLevel level, int chunkX, int chunkZ, boolean gen, ChunkStatus toStatus, boolean addTicket, PrioritisedExecutor.Priority priority, Consumer<ChunkAccess> onComplete) {
        level.moonrise$getChunkTaskScheduler().scheduleChunkLoad(chunkX, chunkZ, gen, toStatus, addTicket, priority, onComplete);
    }

    public static void scheduleChunkLoad(ServerLevel level, int chunkX, int chunkZ, ChunkStatus toStatus, boolean addTicket, PrioritisedExecutor.Priority priority, Consumer<ChunkAccess> onComplete) {
        level.moonrise$getChunkTaskScheduler().scheduleChunkLoad(chunkX, chunkZ, toStatus, addTicket, priority, onComplete);
    }

    public static void scheduleTickingState(ServerLevel level, int chunkX, int chunkZ, FullChunkStatus toStatus, boolean addTicket, PrioritisedExecutor.Priority priority, Consumer<LevelChunk> onComplete) {
        level.moonrise$getChunkTaskScheduler().scheduleTickingState(chunkX, chunkZ, toStatus, addTicket, priority, onComplete);
    }

    public static List<ChunkHolder> getVisibleChunkHolders(ServerLevel level) {
        return level.moonrise$getChunkTaskScheduler().chunkHolderManager.getOldChunkHolders();
    }

    public static List<ChunkHolder> getUpdatingChunkHolders(ServerLevel level) {
        return level.moonrise$getChunkTaskScheduler().chunkHolderManager.getOldChunkHolders();
    }

    public static int getVisibleChunkHolderCount(ServerLevel level) {
        return level.moonrise$getChunkTaskScheduler().chunkHolderManager.size();
    }

    public static int getUpdatingChunkHolderCount(ServerLevel level) {
        return level.moonrise$getChunkTaskScheduler().chunkHolderManager.size();
    }

    public static boolean hasAnyChunkHolders(ServerLevel level) {
        return ChunkSystem.getUpdatingChunkHolderCount(level) != 0;
    }

    public static void onEntityPreAdd(ServerLevel level, Entity entity) {
        io.papermc.paper.chunk.system.ChunkSystem.onEntityPreAdd(level, entity);
    }

    public static void onChunkHolderCreate(ServerLevel level, ChunkHolder holder) {
        io.papermc.paper.chunk.system.ChunkSystem.onChunkHolderCreate(level, holder);
    }

    public static void onChunkHolderDelete(ServerLevel level, ChunkHolder holder) {
        io.papermc.paper.chunk.system.ChunkSystem.onChunkHolderDelete(level, holder);
    }

    public static void onChunkPreBorder(LevelChunk chunk, ChunkHolder holder) {
        ((ServerLevel)chunk.getLevel()).getChunkSource().moonrise$setFullChunk(chunk.getPos().x, chunk.getPos().z, chunk);
    }

    public static void onChunkBorder(LevelChunk chunk, ChunkHolder holder) {
        io.papermc.paper.chunk.system.ChunkSystem.onChunkBorder(chunk, holder);
        chunk.loadCallback();
    }

    public static void onChunkNotBorder(LevelChunk chunk, ChunkHolder holder) {
        io.papermc.paper.chunk.system.ChunkSystem.onChunkNotBorder(chunk, holder);
        chunk.unloadCallback();
    }

    public static void onChunkPostNotBorder(LevelChunk chunk, ChunkHolder holder) {
        ((ServerLevel)chunk.getLevel()).getChunkSource().moonrise$setFullChunk(chunk.getPos().x, chunk.getPos().z, null);
    }

    public static void onChunkTicking(LevelChunk chunk, ChunkHolder holder) {
        io.papermc.paper.chunk.system.ChunkSystem.onChunkTicking(chunk, holder);
        if (!chunk.moonrise$isPostProcessingDone()) {
            chunk.postProcessGeneration();
        }
        ((ServerLevel)chunk.getLevel()).startTickingChunk(chunk);
        ((ServerLevel)chunk.getLevel()).getChunkSource().chunkMap.tickingGenerated.incrementAndGet();
    }

    public static void onChunkNotTicking(LevelChunk chunk, ChunkHolder holder) {
        io.papermc.paper.chunk.system.ChunkSystem.onChunkNotTicking(chunk, holder);
    }

    public static void onChunkEntityTicking(LevelChunk chunk, ChunkHolder holder) {
        io.papermc.paper.chunk.system.ChunkSystem.onChunkEntityTicking(chunk, holder);
    }

    public static void onChunkNotEntityTicking(LevelChunk chunk, ChunkHolder holder) {
        io.papermc.paper.chunk.system.ChunkSystem.onChunkNotEntityTicking(chunk, holder);
    }

    public static ChunkHolder getUnloadingChunkHolder(ServerLevel level, int chunkX, int chunkZ) {
        return null;
    }

    public static int getSendViewDistance(ServerPlayer player) {
        return RegionizedPlayerChunkLoader.getAPISendViewDistance(player);
    }

    public static int getLoadViewDistance(ServerPlayer player) {
        return RegionizedPlayerChunkLoader.getLoadViewDistance(player);
    }

    public static int getTickViewDistance(ServerPlayer player) {
        return RegionizedPlayerChunkLoader.getAPITickViewDistance(player);
    }

    public static void addPlayerToDistanceMaps(ServerLevel world, ServerPlayer player) {
        world.moonrise$getPlayerChunkLoader().addPlayer(player);
    }

    public static void removePlayerFromDistanceMaps(ServerLevel world, ServerPlayer player) {
        world.moonrise$getPlayerChunkLoader().removePlayer(player);
    }

    public static void updateMaps(ServerLevel world, ServerPlayer player) {
        world.moonrise$getPlayerChunkLoader().updatePlayer(player);
    }

    private ChunkSystem() {
    }
}

