/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.common.list;

import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class ReferenceList<E>
implements Iterable<E> {
    private final Reference2IntOpenHashMap<E> referenceToIndex = new Reference2IntOpenHashMap(2, 0.8f);
    private static final Object[] EMPTY_LIST = new Object[0];
    private E[] references;
    private int count;

    public ReferenceList() {
        this(EMPTY_LIST, 0);
    }

    public ReferenceList(E[] array, int count) {
        this.referenceToIndex.defaultReturnValue(Integer.MIN_VALUE);
        this.references = array;
        this.count = count;
    }

    public int size() {
        return this.count;
    }

    public boolean contains(E obj) {
        return this.referenceToIndex.containsKey(obj);
    }

    public boolean remove(E obj) {
        int index = this.referenceToIndex.removeInt(obj);
        if (index == Integer.MIN_VALUE) {
            return false;
        }
        int endIndex = --this.count;
        E end = this.references[endIndex];
        if (index != endIndex) {
            this.referenceToIndex.put(end, index);
        }
        this.references[index] = end;
        this.references[endIndex] = null;
        return true;
    }

    public boolean add(E obj) {
        int count = this.count;
        int currIndex = this.referenceToIndex.putIfAbsent(obj, count);
        if (currIndex != Integer.MIN_VALUE) {
            return false;
        }
        E[] list = this.references;
        if (list.length == count) {
            list = this.references = Arrays.copyOf(list, (int)Math.max(4L, (long)count * 2L));
        }
        list[count] = obj;
        this.count = count + 1;
        return true;
    }

    public E getChecked(int index) {
        if (index < 0 || index >= this.count) {
            throw new IndexOutOfBoundsException("Index: " + index + " is out of bounds, size: " + this.count);
        }
        return this.references[index];
    }

    public E getUnchecked(int index) {
        return this.references[index];
    }

    public Object[] getRawData() {
        return this.references;
    }

    public E[] getRawDataUnchecked() {
        return this.references;
    }

    public void clear() {
        this.referenceToIndex.clear();
        Arrays.fill(this.references, 0, this.count, null);
        this.count = 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private E lastRet;
            private int current;

            @Override
            public boolean hasNext() {
                return this.current < ReferenceList.this.count;
            }

            @Override
            public E next() {
                if (this.current >= ReferenceList.this.count) {
                    throw new NoSuchElementException();
                }
                this.lastRet = ReferenceList.this.references[this.current++];
                return this.lastRet;
            }

            @Override
            public void remove() {
                Object lastRet = this.lastRet;
                if (lastRet == null) {
                    throw new IllegalStateException();
                }
                this.lastRet = null;
                ReferenceList.this.remove(lastRet);
                --this.current;
            }
        };
    }
}

