/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.converters.blockname.ConverterAbstractBlockRename;
import ca.spottedleaf.dataconverter.minecraft.converters.itemname.ConverterAbstractItemRename;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.types.MapType;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;

public final class V1484 {
    private static final int VERSION = 1484;

    public static void register() {
        HashMap renamed = new HashMap(ImmutableMap.of((Object)"minecraft:sea_grass", (Object)"minecraft:seagrass", (Object)"minecraft:tall_sea_grass", (Object)"minecraft:tall_seagrass"));
        ConverterAbstractItemRename.register(1484, renamed::get);
        ConverterAbstractBlockRename.register(1484, renamed::get);
        MCTypeRegistry.CHUNK.addStructureConverter(new DataConverter<MapType<String>, MapType<String>>(1484){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                Object rain;
                Object light;
                Object solid;
                MapType level = data.getMap("Level");
                if (level == null) {
                    return null;
                }
                MapType heightmaps = level.getMap("Heightmaps");
                if (heightmaps == null) {
                    return null;
                }
                Object liquid = heightmaps.getGeneric("LIQUID");
                if (liquid != null) {
                    heightmaps.remove("LIQUID");
                    heightmaps.setGeneric("WORLD_SURFACE_WG", liquid);
                }
                if ((solid = heightmaps.getGeneric("SOLID")) != null) {
                    heightmaps.remove("SOLID");
                    heightmaps.setGeneric("OCEAN_FLOOR_WG", solid);
                    heightmaps.setGeneric("OCEAN_FLOOR", solid);
                }
                if ((light = heightmaps.getGeneric("LIGHT")) != null) {
                    heightmaps.remove("LIGHT");
                    heightmaps.setGeneric("LIGHT_BLOCKING", light);
                }
                if ((rain = heightmaps.getGeneric("RAIN")) != null) {
                    heightmaps.remove("RAIN");
                    heightmaps.setGeneric("MOTION_BLOCKING", rain);
                    heightmaps.setGeneric("MOTION_BLOCKING_NO_LEAVES", rain);
                }
                return null;
            }
        });
    }

    private V1484() {
    }
}

