/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.types.MapType;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;

public final class V1344 {
    private static final int VERSION = 1344;
    private static final Int2ObjectOpenHashMap<String> BUTTON_ID_TO_NAME = new Int2ObjectOpenHashMap();

    public static void register() {
        MCTypeRegistry.OPTIONS.addStructureConverter(new DataConverter<MapType<String>, MapType<String>>(1344){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                for (String key : data.keys()) {
                    Object newEntry;
                    int code;
                    if (!key.startsWith("key_")) continue;
                    String value = data.getString(key);
                    try {
                        code = Integer.parseInt(value);
                    }
                    catch (NumberFormatException ex) {
                        continue;
                    }
                    if (code < 0) {
                        int mouseCode = code + 100;
                        switch (mouseCode) {
                            case 0: {
                                newEntry = "key.mouse.left";
                                break;
                            }
                            case 1: {
                                newEntry = "key.mouse.right";
                                break;
                            }
                            case 2: {
                                newEntry = "key.mouse.middle";
                                break;
                            }
                            default: {
                                newEntry = "key.mouse." + (mouseCode + 1);
                                break;
                            }
                        }
                    } else {
                        newEntry = (String)BUTTON_ID_TO_NAME.getOrDefault(code, (Object)"key.unknown");
                    }
                    data.setString(key, (String)newEntry);
                }
                return null;
            }
        });
    }

    private V1344() {
    }

    static {
        BUTTON_ID_TO_NAME.put(0, (Object)"key.unknown");
        BUTTON_ID_TO_NAME.put(11, (Object)"key.0");
        BUTTON_ID_TO_NAME.put(2, (Object)"key.1");
        BUTTON_ID_TO_NAME.put(3, (Object)"key.2");
        BUTTON_ID_TO_NAME.put(4, (Object)"key.3");
        BUTTON_ID_TO_NAME.put(5, (Object)"key.4");
        BUTTON_ID_TO_NAME.put(6, (Object)"key.5");
        BUTTON_ID_TO_NAME.put(7, (Object)"key.6");
        BUTTON_ID_TO_NAME.put(8, (Object)"key.7");
        BUTTON_ID_TO_NAME.put(9, (Object)"key.8");
        BUTTON_ID_TO_NAME.put(10, (Object)"key.9");
        BUTTON_ID_TO_NAME.put(30, (Object)"key.a");
        BUTTON_ID_TO_NAME.put(40, (Object)"key.apostrophe");
        BUTTON_ID_TO_NAME.put(48, (Object)"key.b");
        BUTTON_ID_TO_NAME.put(43, (Object)"key.backslash");
        BUTTON_ID_TO_NAME.put(14, (Object)"key.backspace");
        BUTTON_ID_TO_NAME.put(46, (Object)"key.c");
        BUTTON_ID_TO_NAME.put(58, (Object)"key.caps.lock");
        BUTTON_ID_TO_NAME.put(51, (Object)"key.comma");
        BUTTON_ID_TO_NAME.put(32, (Object)"key.d");
        BUTTON_ID_TO_NAME.put(211, (Object)"key.delete");
        BUTTON_ID_TO_NAME.put(208, (Object)"key.down");
        BUTTON_ID_TO_NAME.put(18, (Object)"key.e");
        BUTTON_ID_TO_NAME.put(207, (Object)"key.end");
        BUTTON_ID_TO_NAME.put(28, (Object)"key.enter");
        BUTTON_ID_TO_NAME.put(13, (Object)"key.equal");
        BUTTON_ID_TO_NAME.put(1, (Object)"key.escape");
        BUTTON_ID_TO_NAME.put(33, (Object)"key.f");
        BUTTON_ID_TO_NAME.put(59, (Object)"key.f1");
        BUTTON_ID_TO_NAME.put(68, (Object)"key.f10");
        BUTTON_ID_TO_NAME.put(87, (Object)"key.f11");
        BUTTON_ID_TO_NAME.put(88, (Object)"key.f12");
        BUTTON_ID_TO_NAME.put(100, (Object)"key.f13");
        BUTTON_ID_TO_NAME.put(101, (Object)"key.f14");
        BUTTON_ID_TO_NAME.put(102, (Object)"key.f15");
        BUTTON_ID_TO_NAME.put(103, (Object)"key.f16");
        BUTTON_ID_TO_NAME.put(104, (Object)"key.f17");
        BUTTON_ID_TO_NAME.put(105, (Object)"key.f18");
        BUTTON_ID_TO_NAME.put(113, (Object)"key.f19");
        BUTTON_ID_TO_NAME.put(60, (Object)"key.f2");
        BUTTON_ID_TO_NAME.put(61, (Object)"key.f3");
        BUTTON_ID_TO_NAME.put(62, (Object)"key.f4");
        BUTTON_ID_TO_NAME.put(63, (Object)"key.f5");
        BUTTON_ID_TO_NAME.put(64, (Object)"key.f6");
        BUTTON_ID_TO_NAME.put(65, (Object)"key.f7");
        BUTTON_ID_TO_NAME.put(66, (Object)"key.f8");
        BUTTON_ID_TO_NAME.put(67, (Object)"key.f9");
        BUTTON_ID_TO_NAME.put(34, (Object)"key.g");
        BUTTON_ID_TO_NAME.put(41, (Object)"key.grave.accent");
        BUTTON_ID_TO_NAME.put(35, (Object)"key.h");
        BUTTON_ID_TO_NAME.put(199, (Object)"key.home");
        BUTTON_ID_TO_NAME.put(23, (Object)"key.i");
        BUTTON_ID_TO_NAME.put(210, (Object)"key.insert");
        BUTTON_ID_TO_NAME.put(36, (Object)"key.j");
        BUTTON_ID_TO_NAME.put(37, (Object)"key.k");
        BUTTON_ID_TO_NAME.put(82, (Object)"key.keypad.0");
        BUTTON_ID_TO_NAME.put(79, (Object)"key.keypad.1");
        BUTTON_ID_TO_NAME.put(80, (Object)"key.keypad.2");
        BUTTON_ID_TO_NAME.put(81, (Object)"key.keypad.3");
        BUTTON_ID_TO_NAME.put(75, (Object)"key.keypad.4");
        BUTTON_ID_TO_NAME.put(76, (Object)"key.keypad.5");
        BUTTON_ID_TO_NAME.put(77, (Object)"key.keypad.6");
        BUTTON_ID_TO_NAME.put(71, (Object)"key.keypad.7");
        BUTTON_ID_TO_NAME.put(72, (Object)"key.keypad.8");
        BUTTON_ID_TO_NAME.put(73, (Object)"key.keypad.9");
        BUTTON_ID_TO_NAME.put(78, (Object)"key.keypad.add");
        BUTTON_ID_TO_NAME.put(83, (Object)"key.keypad.decimal");
        BUTTON_ID_TO_NAME.put(181, (Object)"key.keypad.divide");
        BUTTON_ID_TO_NAME.put(156, (Object)"key.keypad.enter");
        BUTTON_ID_TO_NAME.put(141, (Object)"key.keypad.equal");
        BUTTON_ID_TO_NAME.put(55, (Object)"key.keypad.multiply");
        BUTTON_ID_TO_NAME.put(74, (Object)"key.keypad.subtract");
        BUTTON_ID_TO_NAME.put(38, (Object)"key.l");
        BUTTON_ID_TO_NAME.put(203, (Object)"key.left");
        BUTTON_ID_TO_NAME.put(56, (Object)"key.left.alt");
        BUTTON_ID_TO_NAME.put(26, (Object)"key.left.bracket");
        BUTTON_ID_TO_NAME.put(29, (Object)"key.left.control");
        BUTTON_ID_TO_NAME.put(42, (Object)"key.left.shift");
        BUTTON_ID_TO_NAME.put(219, (Object)"key.left.win");
        BUTTON_ID_TO_NAME.put(50, (Object)"key.m");
        BUTTON_ID_TO_NAME.put(12, (Object)"key.minus");
        BUTTON_ID_TO_NAME.put(49, (Object)"key.n");
        BUTTON_ID_TO_NAME.put(69, (Object)"key.num.lock");
        BUTTON_ID_TO_NAME.put(24, (Object)"key.o");
        BUTTON_ID_TO_NAME.put(25, (Object)"key.p");
        BUTTON_ID_TO_NAME.put(209, (Object)"key.page.down");
        BUTTON_ID_TO_NAME.put(201, (Object)"key.page.up");
        BUTTON_ID_TO_NAME.put(197, (Object)"key.pause");
        BUTTON_ID_TO_NAME.put(52, (Object)"key.period");
        BUTTON_ID_TO_NAME.put(183, (Object)"key.print.screen");
        BUTTON_ID_TO_NAME.put(16, (Object)"key.q");
        BUTTON_ID_TO_NAME.put(19, (Object)"key.r");
        BUTTON_ID_TO_NAME.put(205, (Object)"key.right");
        BUTTON_ID_TO_NAME.put(184, (Object)"key.right.alt");
        BUTTON_ID_TO_NAME.put(27, (Object)"key.right.bracket");
        BUTTON_ID_TO_NAME.put(157, (Object)"key.right.control");
        BUTTON_ID_TO_NAME.put(54, (Object)"key.right.shift");
        BUTTON_ID_TO_NAME.put(220, (Object)"key.right.win");
        BUTTON_ID_TO_NAME.put(31, (Object)"key.s");
        BUTTON_ID_TO_NAME.put(70, (Object)"key.scroll.lock");
        BUTTON_ID_TO_NAME.put(39, (Object)"key.semicolon");
        BUTTON_ID_TO_NAME.put(53, (Object)"key.slash");
        BUTTON_ID_TO_NAME.put(57, (Object)"key.space");
        BUTTON_ID_TO_NAME.put(20, (Object)"key.t");
        BUTTON_ID_TO_NAME.put(15, (Object)"key.tab");
        BUTTON_ID_TO_NAME.put(22, (Object)"key.u");
        BUTTON_ID_TO_NAME.put(200, (Object)"key.up");
        BUTTON_ID_TO_NAME.put(47, (Object)"key.v");
        BUTTON_ID_TO_NAME.put(17, (Object)"key.w");
        BUTTON_ID_TO_NAME.put(45, (Object)"key.x");
        BUTTON_ID_TO_NAME.put(21, (Object)"key.y");
        BUTTON_ID_TO_NAME.put(44, (Object)"key.z");
    }
}

