/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.converters.poi;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import java.util.function.Function;

public final class ConverterAbstractPOIRename {
    private ConverterAbstractPOIRename() {
    }

    public static void register(int version, Function<String, String> renamer) {
        ConverterAbstractPOIRename.register(version, 0, renamer);
    }

    public static void register(int version, int subVersion, final Function<String, String> renamer) {
        MCTypeRegistry.POI_CHUNK.addStructureConverter(new DataConverter<MapType<String>, MapType<String>>(version, subVersion){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                MapType sections = data.getMap("Sections");
                if (sections == null) {
                    return null;
                }
                for (String key : sections.keys()) {
                    MapType section = sections.getMap(key);
                    ListType records = section.getList("Records", ObjectType.MAP);
                    if (records == null) continue;
                    int len = records.size();
                    for (int i = 0; i < len; ++i) {
                        String converted;
                        MapType record = records.getMap(i);
                        String type = record.getString("type");
                        if (type == null || (converted = (String)renamer.apply(type)) == null) continue;
                        record.setString("type", converted);
                    }
                }
                return null;
            }
        });
    }
}

