/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.scoreboard;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.papermc.paper.adventure.PaperAdventure;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R1.scoreboard.CraftCriteria;
import org.bukkit.craftbukkit.v1_21_R1.scoreboard.CraftObjective;
import org.bukkit.craftbukkit.v1_21_R1.scoreboard.CraftScore;
import org.bukkit.craftbukkit.v1_21_R1.scoreboard.CraftScoreboardTranslations;
import org.bukkit.craftbukkit.v1_21_R1.scoreboard.CraftTeam;
import org.bukkit.entity.Entity;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.RenderType;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Team;

public final class CraftScoreboard
implements org.bukkit.scoreboard.Scoreboard {
    final Scoreboard board;
    boolean registeredGlobally = false;

    CraftScoreboard(Scoreboard board) {
        this.board = board;
    }

    public CraftObjective registerNewObjective(String name, String criteria) {
        return this.registerNewObjective(name, criteria, name);
    }

    public CraftObjective registerNewObjective(String name, String criteria, Component displayName) {
        return this.registerNewObjective(name, (Criteria)CraftCriteria.getFromBukkit(criteria), displayName, RenderType.INTEGER);
    }

    public CraftObjective registerNewObjective(String name, String criteria, Component displayName, RenderType renderType) {
        return this.registerNewObjective(name, (Criteria)CraftCriteria.getFromBukkit(criteria), displayName, renderType);
    }

    public CraftObjective registerNewObjective(String name, Criteria criteria, Component displayName) throws IllegalArgumentException {
        return this.registerNewObjective(name, criteria, displayName, RenderType.INTEGER);
    }

    public CraftObjective registerNewObjective(String name, Criteria criteria, Component displayName, RenderType renderType) throws IllegalArgumentException {
        if (displayName == null) {
            displayName = Component.empty();
        }
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Objective name cannot be null");
        Preconditions.checkArgument((criteria != null ? 1 : 0) != 0, (Object)"Criteria cannot be null");
        Preconditions.checkArgument((renderType != null ? 1 : 0) != 0, (Object)"RenderType cannot be null");
        Preconditions.checkArgument((name.length() <= Short.MAX_VALUE ? 1 : 0) != 0, (String)"The name '%s' is longer than the limit of 32767 characters (%s)", (Object)name, (int)name.length());
        Preconditions.checkArgument((this.board.a(name) == null ? 1 : 0) != 0, (String)"An objective of name '%s' already exists", (Object)name);
        if (((CraftCriteria)criteria).criteria != IScoreboardCriteria.b && !this.registeredGlobally) {
            MinecraftServer.getServer().server.getScoreboardManager().registerScoreboardForVanilla(this);
            this.registeredGlobally = true;
        }
        ScoreboardObjective objective = this.board.a(name, ((CraftCriteria)criteria).criteria, PaperAdventure.asVanilla(displayName), CraftScoreboardTranslations.fromBukkitRender(renderType), true, null);
        return new CraftObjective(this, objective);
    }

    public CraftObjective registerNewObjective(String name, String criteria, String displayName) {
        return this.registerNewObjective(name, (Criteria)CraftCriteria.getFromBukkit(criteria), displayName, RenderType.INTEGER);
    }

    public CraftObjective registerNewObjective(String name, String criteria, String displayName, RenderType renderType) {
        return this.registerNewObjective(name, (Criteria)CraftCriteria.getFromBukkit(criteria), displayName, renderType);
    }

    public CraftObjective registerNewObjective(String name, Criteria criteria, String displayName) {
        return this.registerNewObjective(name, criteria, displayName, RenderType.INTEGER);
    }

    public CraftObjective registerNewObjective(String name, Criteria criteria, String displayName, RenderType renderType) {
        return this.registerNewObjective(name, criteria, (Component)LegacyComponentSerializer.legacySection().deserialize(displayName), renderType);
    }

    public Objective getObjective(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Objective name cannot be null");
        ScoreboardObjective nms = this.board.a(name);
        return nms == null ? null : new CraftObjective(this, nms);
    }

    public ImmutableSet<Objective> getObjectivesByCriteria(String criteria) {
        Preconditions.checkArgument((criteria != null ? 1 : 0) != 0, (Object)"Criteria name cannot be null");
        ImmutableSet.Builder objectives = ImmutableSet.builder();
        for (ScoreboardObjective netObjective : this.board.c()) {
            CraftObjective objective = new CraftObjective(this, netObjective);
            if (!objective.getCriteria().equals(criteria)) continue;
            objectives.add((Object)objective);
        }
        return objectives.build();
    }

    public ImmutableSet<Objective> getObjectivesByCriteria(Criteria criteria) {
        Preconditions.checkArgument((criteria != null ? 1 : 0) != 0, (Object)"Criteria cannot be null");
        ImmutableSet.Builder objectives = ImmutableSet.builder();
        for (ScoreboardObjective netObjective : this.board.c()) {
            CraftObjective objective = new CraftObjective(this, netObjective);
            if (!objective.getTrackedCriteria().equals((Object)criteria)) continue;
            objectives.add((Object)objective);
        }
        return objectives.build();
    }

    public ImmutableSet<Objective> getObjectives() {
        return ImmutableSet.copyOf((Iterable)Iterables.transform(this.board.c(), input -> new CraftObjective(this, (ScoreboardObjective)input)));
    }

    public Objective getObjective(DisplaySlot slot) {
        Preconditions.checkArgument((slot != null ? 1 : 0) != 0, (Object)"Display slot cannot be null");
        ScoreboardObjective objective = this.board.a(CraftScoreboardTranslations.fromBukkitSlot(slot));
        if (objective == null) {
            return null;
        }
        return new CraftObjective(this, objective);
    }

    public ImmutableSet<Score> getScores(OfflinePlayer player) {
        return this.getScores(CraftScoreboard.getScoreHolder(player));
    }

    public ImmutableSet<Score> getScores(String entry) {
        return this.getScores(CraftScoreboard.getScoreHolder(entry));
    }

    private ImmutableSet<Score> getScores(ScoreHolder entry) {
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        ImmutableSet.Builder scores = ImmutableSet.builder();
        for (ScoreboardObjective objective : this.board.c()) {
            scores.add((Object)new CraftScore(new CraftObjective(this, objective), entry));
        }
        return scores.build();
    }

    public void resetScores(OfflinePlayer player) {
        this.resetScores(CraftScoreboard.getScoreHolder(player));
    }

    public void resetScores(String entry) {
        this.resetScores(CraftScoreboard.getScoreHolder(entry));
    }

    private void resetScores(ScoreHolder entry) {
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        for (ScoreboardObjective objective : this.board.c()) {
            this.board.e(entry, objective);
        }
    }

    public Team getPlayerTeam(OfflinePlayer player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"OfflinePlayer cannot be null");
        ScoreboardTeam team = this.board.e(player.getName());
        return team == null ? null : new CraftTeam(this, team);
    }

    public Team getEntryTeam(String entry) {
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        ScoreboardTeam team = this.board.e(entry);
        return team == null ? null : new CraftTeam(this, team);
    }

    public Team getTeam(String teamName) {
        Preconditions.checkArgument((teamName != null ? 1 : 0) != 0, (Object)"Team name cannot be null");
        ScoreboardTeam team = this.board.b(teamName);
        return team == null ? null : new CraftTeam(this, team);
    }

    public ImmutableSet<Team> getTeams() {
        return ImmutableSet.copyOf((Iterable)Iterables.transform(this.board.g(), input -> new CraftTeam(this, (ScoreboardTeam)input)));
    }

    public Team registerNewTeam(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Team name cannot be null");
        Preconditions.checkArgument((name.length() <= Short.MAX_VALUE ? 1 : 0) != 0, (String)"Team name '%s' is longer than the limit of 32767 characters (%s)", (Object)name, (int)name.length());
        Preconditions.checkArgument((this.board.b(name) == null ? 1 : 0) != 0, (String)"Team name '%s' is already in use", (Object)name);
        return new CraftTeam(this, this.board.c(name));
    }

    public ImmutableSet<OfflinePlayer> getPlayers() {
        ImmutableSet.Builder players = ImmutableSet.builder();
        for (ScoreHolder playerName : this.board.e()) {
            players.add((Object)Bukkit.getOfflinePlayer((String)playerName.cB()));
        }
        return players.build();
    }

    public ImmutableSet<String> getEntries() {
        ImmutableSet.Builder entries = ImmutableSet.builder();
        for (ScoreHolder entry : this.board.e()) {
            entries.add((Object)entry.cB());
        }
        return entries.build();
    }

    public void clearSlot(DisplaySlot slot) {
        Preconditions.checkArgument((slot != null ? 1 : 0) != 0, (Object)"Slot cannot be null");
        this.board.a(CraftScoreboardTranslations.fromBukkitSlot(slot), null);
    }

    public ImmutableSet<Score> getScoresFor(Entity entity) throws IllegalArgumentException {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        return this.getScores(((CraftEntity)entity).getHandle());
    }

    public void resetScoresFor(Entity entity) throws IllegalArgumentException {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        this.resetScores(((CraftEntity)entity).getHandle());
    }

    public Team getEntityTeam(Entity entity) throws IllegalArgumentException {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        return this.getEntryTeam(((CraftEntity)entity).getHandle().cB());
    }

    public Scoreboard getHandle() {
        return this.board;
    }

    static ScoreHolder getScoreHolder(String entry) {
        return () -> entry;
    }

    static ScoreHolder getScoreHolder(OfflinePlayer player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"OfflinePlayer cannot be null");
        if (player instanceof CraftPlayer) {
            CraftPlayer craft = (CraftPlayer)player;
            return craft.getHandle();
        }
        return CraftScoreboard.getScoreHolder(player.getName());
    }
}

