/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.inventory.util;

import io.papermc.paper.adventure.PaperAdventure;
import net.kyori.adventure.text.Component;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.IInventory;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;
import net.minecraft.world.level.block.entity.TileEntityBlastFurnace;
import net.minecraft.world.level.block.entity.TileEntityBrewingStand;
import net.minecraft.world.level.block.entity.TileEntityContainer;
import net.minecraft.world.level.block.entity.TileEntityDispenser;
import net.minecraft.world.level.block.entity.TileEntityDropper;
import net.minecraft.world.level.block.entity.TileEntityFurnace;
import net.minecraft.world.level.block.entity.TileEntityFurnaceFurnace;
import net.minecraft.world.level.block.entity.TileEntityHopper;
import net.minecraft.world.level.block.entity.TileEntityLectern;
import net.minecraft.world.level.block.entity.TileEntityLootable;
import net.minecraft.world.level.block.entity.TileEntitySmoker;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryBrewer;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryCustom;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryFurnace;
import org.bukkit.craftbukkit.v1_21_R1.inventory.util.CraftInventoryCreator;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftChatMessage;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public abstract class CraftTileInventoryConverter
implements CraftInventoryCreator.InventoryConverter {
    public abstract IInventory getTileEntity();

    @Override
    public Inventory createInventory(InventoryHolder holder, InventoryType type) {
        return this.getInventory(holder, type, this.getTileEntity());
    }

    @Override
    public Inventory createInventory(InventoryHolder owner, InventoryType type, Component title) {
        IInventory te = this.getTileEntity();
        if (te instanceof TileEntityLootable) {
            ((TileEntityLootable)te).e = PaperAdventure.asVanilla(title);
        }
        return this.getInventory(owner, type, te);
    }

    @Override
    public Inventory createInventory(InventoryHolder holder, InventoryType type, String title) {
        IInventory te = this.getTileEntity();
        if (te instanceof TileEntityLootable) {
            ((TileEntityLootable)te).e = CraftChatMessage.fromStringOrNull(title);
        }
        return this.getInventory(holder, type, te);
    }

    @Deprecated
    public Inventory getInventory(IInventory tileEntity) {
        return this.getInventory(null, null, tileEntity);
    }

    public Inventory getInventory(InventoryHolder owner, InventoryType type, IInventory tileEntity) {
        if (owner != null) {
            return new CraftInventoryCustom(owner, type, tileEntity);
        }
        return new CraftInventory(tileEntity);
    }

    public static class Crafter
    extends CraftTileInventoryConverter {
        @Override
        public IInventory getTileEntity() {
            return new CrafterBlockEntity(BlockPosition.c, Blocks.tq.o());
        }
    }

    public static class Smoker
    extends AbstractFurnaceInventoryConverter {
        @Override
        public IInventory getTileEntity() {
            return new TileEntitySmoker(BlockPosition.c, Blocks.nV.o());
        }
    }

    public static class Lectern
    extends CraftTileInventoryConverter {
        @Override
        public IInventory getTileEntity() {
            return new TileEntityLectern((BlockPosition)BlockPosition.c, (IBlockData)Blocks.oa.o()).e;
        }
    }

    public static class BlastFurnace
    extends AbstractFurnaceInventoryConverter {
        @Override
        public IInventory getTileEntity() {
            return new TileEntityBlastFurnace(BlockPosition.c, Blocks.nW.o());
        }
    }

    public static class Hopper
    extends CraftTileInventoryConverter {
        @Override
        public IInventory getTileEntity() {
            return new TileEntityHopper(BlockPosition.c, Blocks.hc.o());
        }
    }

    public static class Dropper
    extends CraftTileInventoryConverter {
        @Override
        public IInventory getTileEntity() {
            return new TileEntityDropper(BlockPosition.c, Blocks.hi.o());
        }
    }

    public static class Dispenser
    extends CraftTileInventoryConverter {
        @Override
        public IInventory getTileEntity() {
            return new TileEntityDispenser(BlockPosition.c, Blocks.aU.o());
        }
    }

    public static class BrewingStand
    extends CraftTileInventoryConverter {
        @Override
        public IInventory getTileEntity() {
            return new TileEntityBrewingStand(BlockPosition.c, Blocks.fs.o());
        }

        @Override
        public Inventory createInventory(InventoryHolder owner, InventoryType type, Component title) {
            IInventory tileEntity = this.getTileEntity();
            if (tileEntity instanceof TileEntityBrewingStand) {
                ((TileEntityContainer)((TileEntityBrewingStand)tileEntity)).e = PaperAdventure.asVanilla(title);
            }
            return this.getInventory(owner, type, tileEntity);
        }

        @Override
        public Inventory createInventory(InventoryHolder holder, InventoryType type, String title) {
            IInventory tileEntity = this.getTileEntity();
            if (tileEntity instanceof TileEntityBrewingStand) {
                ((TileEntityContainer)((TileEntityBrewingStand)tileEntity)).e = CraftChatMessage.fromStringOrNull(title);
            }
            return this.getInventory(holder, type, tileEntity);
        }

        @Override
        public Inventory getInventory(IInventory tileEntity) {
            return this.getInventory(null, null, tileEntity);
        }

        @Override
        public Inventory getInventory(InventoryHolder owner, InventoryType type, IInventory tileEntity) {
            if (owner != null) {
                return new CraftInventoryCustom(owner, type, tileEntity);
            }
            return new CraftInventoryBrewer(tileEntity);
        }
    }

    public static abstract class AbstractFurnaceInventoryConverter
    extends CraftTileInventoryConverter {
        @Override
        public Inventory createInventory(InventoryHolder owner, InventoryType type, Component title) {
            IInventory tileEntity = this.getTileEntity();
            ((TileEntityContainer)((TileEntityFurnace)tileEntity)).e = PaperAdventure.asVanilla(title);
            return this.getInventory(owner, type, tileEntity);
        }

        @Override
        public Inventory createInventory(InventoryHolder owner, InventoryType type, String title) {
            IInventory tileEntity = this.getTileEntity();
            ((TileEntityContainer)((TileEntityFurnace)tileEntity)).e = CraftChatMessage.fromStringOrNull(title);
            return this.getInventory(owner, type, tileEntity);
        }

        @Override
        public Inventory getInventory(IInventory tileEntity) {
            return this.getInventory(null, null, tileEntity);
        }

        @Override
        public Inventory getInventory(InventoryHolder owner, InventoryType type, IInventory tileEntity) {
            if (owner != null) {
                return new CraftInventoryCustom(owner, type, tileEntity);
            }
            return new CraftInventoryFurnace((TileEntityFurnace)tileEntity);
        }
    }

    public static class Furnace
    extends AbstractFurnaceInventoryConverter {
        @Override
        public IInventory getTileEntity() {
            TileEntityFurnaceFurnace furnace = new TileEntityFurnaceFurnace(BlockPosition.c, Blocks.cD.o());
            return furnace;
        }
    }
}

