/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.inventory;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.v1_21_R1.inventory.SerializableMeta;
import org.bukkit.inventory.meta.OminousBottleMeta;

@DelegateDeserialization(value=SerializableMeta.class)
public class CraftMetaOminousBottle
extends CraftMetaItem
implements OminousBottleMeta {
    static final CraftMetaItem.ItemMetaKeyType<Integer> OMINOUS_BOTTLE_AMPLIFIER = new CraftMetaItem.ItemMetaKeyType<Integer>(DataComponents.Q, "ominous-bottle-amplifier");
    private Integer ominousBottleAmplifier;

    CraftMetaOminousBottle(CraftMetaItem meta) {
        super(meta);
        if (!(meta instanceof CraftMetaOminousBottle)) {
            return;
        }
        CraftMetaOminousBottle bottleMeta = (CraftMetaOminousBottle)meta;
        this.ominousBottleAmplifier = bottleMeta.ominousBottleAmplifier;
    }

    CraftMetaOminousBottle(DataComponentPatch tag, Set<DataComponentType<?>> extraHandledDcts) {
        super(tag, extraHandledDcts);
        CraftMetaOminousBottle.getOrEmpty(tag, OMINOUS_BOTTLE_AMPLIFIER).ifPresent(amplifier -> {
            this.ominousBottleAmplifier = amplifier;
        });
    }

    CraftMetaOminousBottle(Map<String, Object> map) {
        super(map);
        Integer ominousBottleAmplifier = SerializableMeta.getObject(Integer.class, map, CraftMetaOminousBottle.OMINOUS_BOTTLE_AMPLIFIER.BUKKIT, true);
        if (ominousBottleAmplifier != null) {
            this.setAmplifier(ominousBottleAmplifier);
        }
    }

    @Override
    void applyToItem(CraftMetaItem.Applicator tag) {
        super.applyToItem(tag);
        if (this.hasAmplifier()) {
            tag.put(OMINOUS_BOTTLE_AMPLIFIER, this.ominousBottleAmplifier);
        }
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.isBottleEmpty();
    }

    boolean isBottleEmpty() {
        return !this.hasAmplifier();
    }

    @Override
    public CraftMetaOminousBottle clone() {
        CraftMetaOminousBottle clone = (CraftMetaOminousBottle)super.clone();
        return clone;
    }

    public boolean hasAmplifier() {
        return this.ominousBottleAmplifier != null;
    }

    public int getAmplifier() {
        Preconditions.checkState((boolean)this.hasAmplifier(), (Object)"'ominous_bottle_amplifier' data component is absent. Check hasAmplifier first!");
        return this.ominousBottleAmplifier;
    }

    public void setAmplifier(int amplifier) {
        Preconditions.checkArgument((0 <= amplifier && amplifier <= 4 ? 1 : 0) != 0, (Object)"Amplifier must be in range [0, 4]");
        this.ominousBottleAmplifier = amplifier;
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (this.hasAmplifier()) {
            hash = 61 * hash + this.ominousBottleAmplifier.hashCode();
        }
        return original != hash ? CraftMetaOminousBottle.class.hashCode() ^ hash : hash;
    }

    @Override
    boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaOminousBottle) {
            CraftMetaOminousBottle that = (CraftMetaOminousBottle)meta;
            return this.hasAmplifier() ? that.hasAmplifier() && this.ominousBottleAmplifier.equals(that.ominousBottleAmplifier) : !that.hasAmplifier();
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaOminousBottle || this.isBottleEmpty());
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        if (this.hasAmplifier()) {
            builder.put((Object)CraftMetaOminousBottle.OMINOUS_BOTTLE_AMPLIFIER.BUKKIT, (Object)this.ominousBottleAmplifier);
        }
        return builder;
    }
}

