/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.generator;

import com.google.common.base.Preconditions;
import java.lang.ref.WeakReference;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ITileEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.IChunkAccess;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBiome;
import org.bukkit.craftbukkit.v1_21_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftMagicNumbers;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.material.MaterialData;

public final class CraftChunkData
implements ChunkGenerator.ChunkData {
    private final int maxHeight;
    private final int minHeight;
    private final WeakReference<IChunkAccess> weakChunk;

    public CraftChunkData(World world, IChunkAccess chunkAccess) {
        this(world.getMaxHeight(), world.getMinHeight(), chunkAccess);
    }

    CraftChunkData(int maxHeight, int minHeight, IChunkAccess chunkAccess) {
        this.maxHeight = maxHeight;
        this.minHeight = minHeight;
        this.weakChunk = new WeakReference<IChunkAccess>(chunkAccess);
    }

    public IChunkAccess getHandle() {
        IChunkAccess access = (IChunkAccess)this.weakChunk.get();
        Preconditions.checkState((access != null ? 1 : 0) != 0, (Object)"IChunkAccess no longer present, are you using it in a different tick?");
        return access;
    }

    public void breakLink() {
        this.weakChunk.clear();
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public Biome getBiome(int x2, int y2, int z2) {
        return CraftBiome.minecraftHolderToBukkit(this.getHandle().getNoiseBiome(x2 >> 2, y2 >> 2, z2 >> 2));
    }

    public void setBlock(int x2, int y2, int z2, Material material) {
        this.setBlock(x2, y2, z2, material.createBlockData());
    }

    public void setBlock(int x2, int y2, int z2, MaterialData material) {
        this.setBlock(x2, y2, z2, CraftMagicNumbers.getBlock(material));
    }

    public void setBlock(int x2, int y2, int z2, BlockData blockData) {
        this.setBlock(x2, y2, z2, ((CraftBlockData)blockData).getState());
    }

    public void setRegion(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, Material material) {
        this.setRegion(xMin, yMin, zMin, xMax, yMax, zMax, material.createBlockData());
    }

    public void setRegion(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, MaterialData material) {
        this.setRegion(xMin, yMin, zMin, xMax, yMax, zMax, CraftMagicNumbers.getBlock(material));
    }

    public void setRegion(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, BlockData blockData) {
        this.setRegion(xMin, yMin, zMin, xMax, yMax, zMax, ((CraftBlockData)blockData).getState());
    }

    public Material getType(int x2, int y2, int z2) {
        return this.getTypeId(x2, y2, z2).getBukkitMaterial();
    }

    public MaterialData getTypeAndData(int x2, int y2, int z2) {
        return CraftMagicNumbers.getMaterial(this.getTypeId(x2, y2, z2));
    }

    public BlockData getBlockData(int x2, int y2, int z2) {
        return CraftBlockData.fromData(this.getTypeId(x2, y2, z2));
    }

    public void setRegion(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, IBlockData type) {
        if (xMin > 15 || yMin >= this.maxHeight || zMin > 15) {
            return;
        }
        if (xMin < 0) {
            xMin = 0;
        }
        if (yMin < this.minHeight) {
            yMin = this.minHeight;
        }
        if (zMin < 0) {
            zMin = 0;
        }
        if (xMax > 16) {
            xMax = 16;
        }
        if (yMax > this.maxHeight) {
            yMax = this.maxHeight;
        }
        if (zMax > 16) {
            zMax = 16;
        }
        if (xMin >= xMax || yMin >= yMax || zMin >= zMax) {
            return;
        }
        for (int y2 = yMin; y2 < yMax; ++y2) {
            for (int x2 = xMin; x2 < xMax; ++x2) {
                for (int z2 = zMin; z2 < zMax; ++z2) {
                    this.setBlock(x2, y2, z2, type);
                }
            }
        }
    }

    public IBlockData getTypeId(int x2, int y2, int z2) {
        if (x2 != (x2 & 0xF) || y2 < this.minHeight || y2 >= this.maxHeight || z2 != (z2 & 0xF)) {
            return Blocks.a.o();
        }
        IChunkAccess access = this.getHandle();
        return access.a_(new BlockPosition(access.f().d() + x2, y2, access.f().e() + z2));
    }

    public byte getData(int x2, int y2, int z2) {
        return CraftMagicNumbers.toLegacyData(this.getTypeId(x2, y2, z2));
    }

    private void setBlock(int x2, int y2, int z2, IBlockData type) {
        if (x2 != (x2 & 0xF) || y2 < this.minHeight || y2 >= this.maxHeight || z2 != (z2 & 0xF)) {
            return;
        }
        IChunkAccess access = this.getHandle();
        BlockPosition blockPosition = new BlockPosition(access.f().d() + x2, y2, access.f().e() + z2);
        IBlockData oldBlockData = access.a(blockPosition, type, false);
        if (type.t()) {
            TileEntity tileEntity = ((ITileEntity)((Object)type.b())).a(blockPosition, type);
            if (tileEntity == null) {
                access.d(blockPosition);
            } else {
                access.a(tileEntity);
            }
        } else if (oldBlockData != null && oldBlockData.t()) {
            access.d(blockPosition);
        }
    }
}

