/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.entity;

import com.destroystokyo.paper.entity.PaperPathfinder;
import com.destroystokyo.paper.entity.Pathfinder;
import com.google.common.base.Preconditions;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.entity.EntityInsentient;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.craftbukkit.v1_21_R1.CraftLootTable;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.CraftSound;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftLivingEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.loot.LootTable;
import org.jetbrains.annotations.NotNull;

public abstract class CraftMob
extends CraftLivingEntity
implements Mob {
    private final PaperPathfinder paperPathfinder;

    public CraftMob(CraftServer server, EntityInsentient entity) {
        super(server, entity);
        this.paperPathfinder = new PaperPathfinder(entity);
    }

    public Pathfinder getPathfinder() {
        return this.paperPathfinder;
    }

    public void setTarget(LivingEntity target) {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot set target during world generation");
        EntityInsentient entity = this.getHandle();
        if (target == null) {
            entity.setTarget(null, null, false);
        } else if (target instanceof CraftLivingEntity) {
            entity.setTarget(((CraftLivingEntity)target).getHandle(), null, false);
        }
    }

    public CraftLivingEntity getTarget() {
        if (this.getHandle().p() == null) {
            return null;
        }
        return (CraftLivingEntity)this.getHandle().p().getBukkitEntity();
    }

    public void setAware(boolean aware) {
        this.getHandle().aware = aware;
    }

    public boolean isAware() {
        return this.getHandle().aware;
    }

    public Sound getAmbientSound() {
        SoundEffect sound = this.getHandle().getAmbientSound0();
        return sound != null ? CraftSound.minecraftToBukkit(sound) : null;
    }

    @Override
    public EntityInsentient getHandle() {
        return (EntityInsentient)this.entity;
    }

    @Override
    public void setHandle(net.minecraft.world.entity.Entity entity) {
        super.setHandle(entity);
        this.paperPathfinder.setHandle(this.getHandle());
    }

    @Override
    public String toString() {
        return "CraftMob";
    }

    public void setLootTable(LootTable table) {
        this.getHandle().cm = CraftLootTable.bukkitToMinecraft(table);
    }

    public LootTable getLootTable() {
        return CraftLootTable.minecraftToBukkit(this.getHandle().eA());
    }

    public void setSeed(long seed) {
        this.getHandle().cn = seed;
    }

    public long getSeed() {
        return this.getHandle().cn;
    }

    public boolean isInDaylight() {
        return this.getHandle().ge();
    }

    public void lookAt(@NotNull Location location) {
        Preconditions.checkNotNull((Object)location, (Object)"location cannot be null");
        Preconditions.checkArgument((boolean)location.getWorld().equals((Object)this.getWorld()), (Object)"location in a different world");
        this.getHandle().I().a(location.getX(), location.getY(), location.getZ());
    }

    public void lookAt(@NotNull Location location, float headRotationSpeed, float maxHeadPitch) {
        Preconditions.checkNotNull((Object)location, (Object)"location cannot be null");
        Preconditions.checkArgument((boolean)location.getWorld().equals((Object)this.getWorld()), (Object)"location in a different world");
        this.getHandle().I().a(location.getX(), location.getY(), location.getZ(), headRotationSpeed, maxHeadPitch);
    }

    public void lookAt(@NotNull Entity entity) {
        Preconditions.checkNotNull((Object)entity, (Object)"entity cannot be null");
        Preconditions.checkArgument((boolean)entity.getWorld().equals((Object)this.getWorld()), (Object)"entity in a different world");
        this.getHandle().I().a(((CraftEntity)entity).getHandle());
    }

    public void lookAt(@NotNull Entity entity, float headRotationSpeed, float maxHeadPitch) {
        Preconditions.checkNotNull((Object)entity, (Object)"entity cannot be null");
        Preconditions.checkArgument((boolean)entity.getWorld().equals((Object)this.getWorld()), (Object)"entity in a different world");
        this.getHandle().I().a(((CraftEntity)entity).getHandle(), headRotationSpeed, maxHeadPitch);
    }

    public void lookAt(double x2, double y2, double z2) {
        this.getHandle().I().a(x2, y2, z2);
    }

    public void lookAt(double x2, double y2, double z2, float headRotationSpeed, float maxHeadPitch) {
        this.getHandle().I().a(x2, y2, z2, headRotationSpeed, maxHeadPitch);
    }

    public int getHeadRotationSpeed() {
        return this.getHandle().fM();
    }

    public int getMaxHeadPitch() {
        return this.getHandle().ac();
    }

    public boolean isLeftHanded() {
        return this.getHandle().ga();
    }

    public void setLeftHanded(boolean leftHanded) {
        this.getHandle().v(leftHanded);
    }

    public boolean isAggressive() {
        return this.getHandle().gb();
    }

    public void setAggressive(boolean aggressive) {
        this.getHandle().w(aggressive);
    }

    public int getPossibleExperienceReward() {
        return this.getHandle().a((WorldServer)this.getHandle().dO(), (net.minecraft.world.entity.Entity)null);
    }
}

