/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.entity;

import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftVehicle;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftMagicNumbers;
import org.bukkit.entity.Minecart;
import org.bukkit.material.MaterialData;
import org.bukkit.util.Vector;

public abstract class CraftMinecart
extends CraftVehicle
implements Minecart {
    public CraftMinecart(CraftServer server, EntityMinecartAbstract entity) {
        super(server, entity);
    }

    public void setDamage(double damage) {
        this.getHandle().b((float)damage);
    }

    public double getDamage() {
        return this.getHandle().N();
    }

    public double getMaxSpeed() {
        return this.getHandle().maxSpeed;
    }

    public void setMaxSpeed(double speed) {
        if (speed >= 0.0) {
            this.getHandle().maxSpeed = speed;
        }
    }

    public boolean isSlowWhenEmpty() {
        return this.getHandle().slowWhenEmpty;
    }

    public void setSlowWhenEmpty(boolean slow) {
        this.getHandle().slowWhenEmpty = slow;
    }

    public Vector getFlyingVelocityMod() {
        return this.getHandle().getFlyingVelocityMod();
    }

    public void setFlyingVelocityMod(Vector flying) {
        this.getHandle().setFlyingVelocityMod(flying);
    }

    public Vector getDerailedVelocityMod() {
        return this.getHandle().getDerailedVelocityMod();
    }

    public void setDerailedVelocityMod(Vector derailed) {
        this.getHandle().setDerailedVelocityMod(derailed);
    }

    public Material getMinecartMaterial() {
        Item minecartItem = switch (this.getHandle().v()) {
            default -> throw new MatchException(null, null);
            case EntityMinecartAbstract.EnumMinecartType.b -> Items.nN;
            case EntityMinecartAbstract.EnumMinecartType.c -> Items.nO;
            case EntityMinecartAbstract.EnumMinecartType.d -> Items.nP;
            case EntityMinecartAbstract.EnumMinecartType.f -> Items.nQ;
            case EntityMinecartAbstract.EnumMinecartType.g -> Items.uM;
            case EntityMinecartAbstract.EnumMinecartType.a, EntityMinecartAbstract.EnumMinecartType.e -> Items.nM;
        };
        return CraftMagicNumbers.getMaterial(minecartItem);
    }

    @Override
    public EntityMinecartAbstract getHandle() {
        return (EntityMinecartAbstract)this.entity;
    }

    public void setDisplayBlock(MaterialData material) {
        if (material != null) {
            IBlockData block = CraftMagicNumbers.getBlock(material);
            this.getHandle().c(block);
        } else {
            this.getHandle().c(Blocks.a.o());
            this.getHandle().a(false);
        }
    }

    public void setDisplayBlockData(BlockData blockData) {
        if (blockData != null) {
            IBlockData block = ((CraftBlockData)blockData).getState();
            this.getHandle().c(block);
        } else {
            this.getHandle().c(Blocks.a.o());
            this.getHandle().a(false);
        }
    }

    public MaterialData getDisplayBlock() {
        IBlockData blockData = this.getHandle().w();
        return CraftMagicNumbers.getMaterial(blockData);
    }

    public BlockData getDisplayBlockData() {
        IBlockData blockData = this.getHandle().w();
        return CraftBlockData.fromData(blockData);
    }

    public void setDisplayBlockOffset(int offset) {
        this.getHandle().c(offset);
    }

    public int getDisplayBlockOffset() {
        return this.getHandle().y();
    }
}

