/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayInCloseWindow;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.TileInventory;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityFireworks;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerEnchantTable;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.item.ItemCooldown;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.trading.IMerchant;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftSign;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftAbstractHorse;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftAbstractVillager;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftVillager;
import org.bukkit.craftbukkit.v1_21_R1.entity.memory.CraftMemoryMapper;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftContainer;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryAbstractHorse;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryDoubleChest;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryLectern;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryPlayer;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemType;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftMerchantCustom;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftNamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Firework;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Villager;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MainHand;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.permissions.PermissibleBase;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.permissions.ServerOperator;
import org.bukkit.plugin.Plugin;
import org.spigotmc.AsyncCatcher;

public class CraftHumanEntity
extends CraftLivingEntity
implements HumanEntity {
    private CraftInventoryPlayer inventory;
    private final CraftInventory enderChest;
    protected final PermissibleBase perm = new PermissibleBase((ServerOperator)this);
    private boolean op;
    private GameMode mode;

    public CraftHumanEntity(CraftServer server, EntityHuman entity) {
        super(server, entity);
        this.mode = server.getDefaultGameMode();
        this.inventory = new CraftInventoryPlayer(entity.fY());
        this.enderChest = new CraftInventory(entity.gl());
    }

    public PlayerInventory getInventory() {
        return this.inventory;
    }

    @Override
    public EntityEquipment getEquipment() {
        return this.inventory;
    }

    public Inventory getEnderChest() {
        return this.enderChest;
    }

    public MainHand getMainHand() {
        return this.getHandle().fq() == EnumMainHand.a ? MainHand.LEFT : MainHand.RIGHT;
    }

    public ItemStack getItemInHand() {
        return this.getInventory().getItemInHand();
    }

    public void setItemInHand(ItemStack item) {
        this.getInventory().setItemInHand(item);
    }

    public ItemStack getItemOnCursor() {
        return CraftItemStack.asCraftMirror(this.getHandle().cd.g());
    }

    public void setItemOnCursor(ItemStack item) {
        net.minecraft.world.item.ItemStack stack = CraftItemStack.asNMSCopy(item);
        this.getHandle().cd.b(stack);
        if (this instanceof CraftPlayer) {
            this.getHandle().cd.broadcastCarriedItem();
        }
    }

    @Override
    public void setHurtDirection(float hurtDirection) {
        this.getHandle().cw = hurtDirection;
    }

    public boolean isDeeplySleeping() {
        return this.getHandle().gb();
    }

    public int getSleepTicks() {
        return this.getHandle().cz;
    }

    public Location getPotentialBedLocation() {
        EntityPlayer handle = (EntityPlayer)this.getHandle();
        BlockPosition bed = handle.S();
        if (bed == null) {
            return null;
        }
        WorldServer worldServer = handle.d.a(handle.U());
        if (worldServer == null) {
            return null;
        }
        return new Location((World)worldServer.getWorld(), (double)bed.u(), (double)bed.v(), (double)bed.w());
    }

    public FishHook getFishHook() {
        if (this.getHandle().cv == null) {
            return null;
        }
        return (FishHook)this.getHandle().cv.getBukkitEntity();
    }

    public boolean sleep(Location location, boolean force) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"Location needs to be in a world");
        Preconditions.checkArgument((boolean)location.getWorld().equals((Object)this.getWorld()), (Object)"Cannot sleep across worlds");
        BlockPosition blockposition = CraftLocation.toBlockPosition(location);
        IBlockData iblockdata = this.getHandle().dO().a_(blockposition);
        if (!(iblockdata.b() instanceof BlockBed)) {
            return false;
        }
        if (this.getHandle().startSleepInBed(blockposition, force).left().isPresent()) {
            return false;
        }
        iblockdata = (IBlockData)iblockdata.a(BlockBed.c, true);
        this.getHandle().dO().a(blockposition, iblockdata, 4);
        return true;
    }

    public void wakeup(boolean setSpawnLocation) {
        Preconditions.checkState((boolean)this.isSleeping(), (Object)"Cannot wakeup if not sleeping");
        this.getHandle().a(true, setSpawnLocation);
    }

    public Location getBedLocation() {
        Preconditions.checkState((boolean)this.isSleeping(), (Object)"Not sleeping");
        BlockPosition bed = this.getHandle().fF().get();
        return CraftLocation.toBukkit(bed, this.getWorld());
    }

    @Override
    public String getName() {
        return this.getHandle().cB();
    }

    @Override
    public boolean isOp() {
        return this.op;
    }

    @Override
    public boolean isPermissionSet(String name) {
        return this.perm.isPermissionSet(name);
    }

    @Override
    public boolean isPermissionSet(Permission perm) {
        return this.perm.isPermissionSet(perm);
    }

    @Override
    public boolean hasPermission(String name) {
        return this.perm.hasPermission(name);
    }

    @Override
    public boolean hasPermission(Permission perm) {
        return this.perm.hasPermission(perm);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value) {
        return this.perm.addAttachment(plugin, name, value);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin) {
        return this.perm.addAttachment(plugin);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value, int ticks) {
        return this.perm.addAttachment(plugin, name, value, ticks);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, int ticks) {
        return this.perm.addAttachment(plugin, ticks);
    }

    @Override
    public void removeAttachment(PermissionAttachment attachment) {
        this.perm.removeAttachment(attachment);
    }

    @Override
    public void recalculatePermissions() {
        this.perm.recalculatePermissions();
    }

    @Override
    public void setOp(boolean value) {
        this.op = value;
        this.perm.recalculatePermissions();
    }

    @Override
    public Set<PermissionAttachmentInfo> getEffectivePermissions() {
        return this.perm.getEffectivePermissions();
    }

    public GameMode getGameMode() {
        return this.mode;
    }

    public void setGameMode(GameMode mode) {
        Preconditions.checkArgument((mode != null ? 1 : 0) != 0, (Object)"GameMode cannot be null");
        this.mode = mode;
    }

    @Override
    public EntityHuman getHandle() {
        return (EntityHuman)this.entity;
    }

    public void setHandle(EntityHuman entity) {
        super.setHandle(entity);
        this.inventory = new CraftInventoryPlayer(entity.fY());
    }

    @Override
    public String toString() {
        return "CraftHumanEntity{id=" + this.getEntityId() + "name=" + this.getName() + "}";
    }

    public InventoryView getOpenInventory() {
        return this.getHandle().cd.getBukkitView();
    }

    public InventoryView openInventory(Inventory inventory) {
        InventoryHolder inventoryHolder;
        TileEntity te;
        CraftInventory craft;
        if (!(this.getHandle() instanceof EntityPlayer)) {
            return null;
        }
        EntityPlayer player = (EntityPlayer)this.getHandle();
        Container formerContainer = this.getHandle().cd;
        ITileInventory tileInventory = null;
        if (inventory instanceof CraftInventoryDoubleChest) {
            tileInventory = ((CraftInventoryDoubleChest)inventory).tile;
        } else if (inventory instanceof CraftInventoryLectern) {
            tileInventory = ((CraftInventoryLectern)inventory).tile;
        } else if (inventory instanceof CraftInventory && (craft = (CraftInventory)inventory).getInventory() instanceof ITileInventory) {
            tileInventory = (ITileInventory)((Object)craft.getInventory());
        }
        if (tileInventory instanceof ITileInventory && tileInventory instanceof TileEntity && !(te = (TileEntity)((Object)tileInventory)).m()) {
            te.a(this.getHandle().dO());
        }
        if (tileInventory instanceof ITileInventory) {
            this.getHandle().a(tileInventory);
        } else if (inventory instanceof CraftInventoryAbstractHorse && (inventoryHolder = (craft = (CraftInventoryAbstractHorse)inventory).getInventory().getOwner()) instanceof CraftAbstractHorse) {
            CraftAbstractHorse horse = (CraftAbstractHorse)inventoryHolder;
            this.getHandle().a(horse.getHandle(), craft.getInventory());
        } else {
            Containers container = CraftContainer.getNotchInventoryType(inventory);
            CraftHumanEntity.openCustomInventory(inventory, player, container);
        }
        if (this.getHandle().cd == formerContainer) {
            return null;
        }
        this.getHandle().cd.checkReachable = false;
        return this.getHandle().cd.getBukkitView();
    }

    private static void openCustomInventory(Inventory inventory, EntityPlayer player, Containers<?> windowType) {
        if (player.c == null) {
            return;
        }
        Preconditions.checkArgument((windowType != null ? 1 : 0) != 0, (Object)"Unknown windowType");
        Container container = new CraftContainer(inventory, (EntityHuman)player, player.nextContainerCounter());
        Pair<Component, Container> result = CraftEventFactory.callInventoryOpenEventWithTitle(player, container);
        container = (Container)result.getSecond();
        if (container == null) {
            return;
        }
        Component adventure$title = container.getBukkitView().title();
        if (adventure$title == null) {
            adventure$title = LegacyComponentSerializer.legacySection().deserialize(container.getBukkitView().getTitle());
        }
        if (result.getFirst() != null) {
            adventure$title = (Component)result.getFirst();
        }
        if (!player.fc()) {
            player.c.b(new PacketPlayOutOpenWindow(container.j, windowType, PaperAdventure.asVanilla(adventure$title)));
        }
        player.cd = container;
        player.a(container);
    }

    public InventoryView openWorkbench(Location location, boolean force) {
        Block block;
        if (location == null) {
            location = this.getLocation();
        }
        if (!force && (block = location.getBlock()).getType() != Material.CRAFTING_TABLE) {
            return null;
        }
        this.getHandle().a(Blocks.cA.o().b(this.getHandle().dO(), CraftLocation.toBlockPosition(location)));
        if (force) {
            this.getHandle().cd.checkReachable = false;
        }
        return this.getHandle().cd.getBukkitView();
    }

    public InventoryView openEnchanting(Location location, boolean force) {
        Block block;
        if (location == null) {
            location = this.getLocation();
        }
        if (!force && (block = location.getBlock()).getType() != Material.ENCHANTING_TABLE) {
            return null;
        }
        BlockPosition pos = CraftLocation.toBlockPosition(location);
        ITileInventory menuProvider = Blocks.fr.o().b(this.getHandle().dO(), pos);
        if (menuProvider == null) {
            if (!force) {
                return null;
            }
            menuProvider = new TileInventory((syncId, inventory, player) -> new ContainerEnchantTable(syncId, inventory, ContainerAccess.a(this.getHandle().dO(), pos)), IChatBaseComponent.c("container.enchant"));
        }
        this.getHandle().a(menuProvider);
        if (force) {
            this.getHandle().cd.checkReachable = false;
        }
        return this.getHandle().cd.getBukkitView();
    }

    public void openInventory(InventoryView inventory) {
        if (!(this.getHandle() instanceof EntityPlayer)) {
            return;
        }
        if (((EntityPlayer)this.getHandle()).c == null) {
            return;
        }
        if (this.getHandle().cd != this.getHandle().cc) {
            ((EntityPlayer)this.getHandle()).c.handleContainerClose(new PacketPlayInCloseWindow(this.getHandle().cd.j), InventoryCloseEvent.Reason.OPEN_NEW);
        }
        EntityPlayer player = (EntityPlayer)this.getHandle();
        Container container = inventory instanceof CraftInventoryView ? ((CraftInventoryView)inventory).getHandle() : new CraftContainer(inventory, this.getHandle(), player.nextContainerCounter());
        Pair<Component, Container> result = CraftEventFactory.callInventoryOpenEventWithTitle(player, container);
        if ((container = (Container)result.getSecond()) == null) {
            return;
        }
        Containers windowType = CraftContainer.getNotchInventoryType(inventory.getTopInventory());
        Component adventure$title = inventory.title();
        if (adventure$title == null) {
            adventure$title = LegacyComponentSerializer.legacySection().deserialize(inventory.getTitle());
        }
        if (result.getFirst() != null) {
            adventure$title = (Component)result.getFirst();
        }
        if (!player.fc()) {
            player.c.b(new PacketPlayOutOpenWindow(container.j, windowType, PaperAdventure.asVanilla(adventure$title)));
        }
        player.cd = container;
        player.a(container);
    }

    public InventoryView openMerchant(Villager villager, boolean force) {
        Preconditions.checkNotNull((Object)villager, (Object)"villager cannot be null");
        return this.openMerchant((Merchant)villager, force);
    }

    public InventoryView openMerchant(Merchant merchant, boolean force) {
        IChatBaseComponent name;
        IMerchant mcMerchant;
        Preconditions.checkNotNull((Object)merchant, (Object)"merchant cannot be null");
        if (!force && merchant.isTrading()) {
            return null;
        }
        if (merchant.isTrading()) {
            merchant.getTrader().closeInventory();
        }
        int level = 1;
        if (merchant instanceof CraftAbstractVillager) {
            mcMerchant = ((CraftAbstractVillager)merchant).getHandle();
            name = ((CraftAbstractVillager)merchant).getHandle().S_();
            if (merchant instanceof CraftVillager) {
                level = ((CraftVillager)merchant).getHandle().gv().c();
            }
        } else if (merchant instanceof CraftMerchantCustom) {
            mcMerchant = ((CraftMerchantCustom)merchant).getMerchant();
            name = ((CraftMerchantCustom)merchant).getMerchant().getScoreboardDisplayName();
        } else {
            throw new IllegalArgumentException("Can't open merchant " + merchant.toString());
        }
        mcMerchant.a(this.getHandle());
        mcMerchant.a(this.getHandle(), name, level);
        return this.getHandle().cd.getBukkitView();
    }

    public InventoryView openAnvil(Location location, boolean force) {
        return this.openInventory(location, force, Material.ANVIL);
    }

    public InventoryView openCartographyTable(Location location, boolean force) {
        return this.openInventory(location, force, Material.CARTOGRAPHY_TABLE);
    }

    public InventoryView openGrindstone(Location location, boolean force) {
        return this.openInventory(location, force, Material.GRINDSTONE);
    }

    public InventoryView openLoom(Location location, boolean force) {
        return this.openInventory(location, force, Material.LOOM);
    }

    public InventoryView openSmithingTable(Location location, boolean force) {
        return this.openInventory(location, force, Material.SMITHING_TABLE);
    }

    public InventoryView openStonecutter(Location location, boolean force) {
        return this.openInventory(location, force, Material.STONECUTTER);
    }

    private InventoryView openInventory(Location location, boolean force, Material material) {
        Object block;
        AsyncCatcher.catchOp("open" + String.valueOf(material));
        if (location == null) {
            location = this.getLocation();
        }
        if (!force && (block = location.getBlock()).getType() != material) {
            return null;
        }
        if (material == Material.ANVIL) {
            block = Blocks.gS;
        } else if (material == Material.CARTOGRAPHY_TABLE) {
            block = Blocks.nX;
        } else if (material == Material.GRINDSTONE) {
            block = Blocks.nZ;
        } else if (material == Material.LOOM) {
            block = Blocks.nT;
        } else if (material == Material.SMITHING_TABLE) {
            block = Blocks.ob;
        } else if (material == Material.STONECUTTER) {
            block = Blocks.oc;
        } else {
            throw new IllegalArgumentException("Unsupported inventory type: " + String.valueOf(material));
        }
        this.getHandle().a(block.b(null, this.getHandle().dO(), new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ())));
        this.getHandle().cd.checkReachable = !force;
        return this.getHandle().cd.getBukkitView();
    }

    public void closeInventory() {
        this.getHandle().closeContainer(InventoryCloseEvent.Reason.PLUGIN);
    }

    public void closeInventory(InventoryCloseEvent.Reason reason) {
        this.getHandle().closeContainer(reason);
    }

    public boolean isBlocking() {
        return this.getHandle().fy();
    }

    public boolean isHandRaised() {
        return this.getHandle().fr();
    }

    public boolean setWindowProperty(InventoryView.Property prop, int value) {
        return false;
    }

    public int getEnchantmentSeed() {
        return this.getHandle().ct;
    }

    public void setEnchantmentSeed(int i2) {
        this.getHandle().ct = i2;
    }

    public int getExpToLevel() {
        return this.getHandle().gh();
    }

    public float getAttackCooldown() {
        return this.getHandle().F(0.5f);
    }

    public boolean hasCooldown(Material material) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        Preconditions.checkArgument((boolean)material.isItem(), (String)"Material %s is not an item", (Object)material);
        return this.getHandle().gt().a(CraftItemType.bukkitToMinecraft(material));
    }

    public int getCooldown(Material material) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        Preconditions.checkArgument((boolean)material.isItem(), (String)"Material %s is not an item", (Object)material);
        ItemCooldown.Info cooldown = this.getHandle().gt().a.get(CraftItemType.bukkitToMinecraft(material));
        return cooldown == null ? 0 : Math.max(0, cooldown.b - this.getHandle().gt().b);
    }

    public void setCooldown(Material material, int ticks) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        Preconditions.checkArgument((boolean)material.isItem(), (String)"Material %s is not an item", (Object)material);
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"Cannot have negative cooldown");
        this.getHandle().gt().a(CraftItemType.bukkitToMinecraft(material), ticks);
    }

    public Entity releaseLeftShoulderEntity() {
        net.minecraft.world.entity.Entity entity;
        if (!this.getHandle().gp().g() && (entity = this.getHandle().releaseLeftShoulderEntity()) != null) {
            return entity.getBukkitEntity();
        }
        return null;
    }

    public Entity releaseRightShoulderEntity() {
        net.minecraft.world.entity.Entity entity;
        if (!this.getHandle().gq().g() && (entity = this.getHandle().releaseRightShoulderEntity()) != null) {
            return entity.getBukkitEntity();
        }
        return null;
    }

    public boolean discoverRecipe(NamespacedKey recipe) {
        return this.discoverRecipes(Arrays.asList(recipe)) != 0;
    }

    public int discoverRecipes(Collection<NamespacedKey> recipes) {
        return this.getHandle().a(this.bukkitKeysToMinecraftRecipes(recipes));
    }

    public boolean undiscoverRecipe(NamespacedKey recipe) {
        return this.undiscoverRecipes(Arrays.asList(recipe)) != 0;
    }

    public int undiscoverRecipes(Collection<NamespacedKey> recipes) {
        return this.getHandle().b(this.bukkitKeysToMinecraftRecipes(recipes));
    }

    public boolean hasDiscoveredRecipe(NamespacedKey recipe) {
        return false;
    }

    public Set<NamespacedKey> getDiscoveredRecipes() {
        return ImmutableSet.of();
    }

    private Collection<RecipeHolder<?>> bukkitKeysToMinecraftRecipes(Collection<NamespacedKey> recipeKeys) {
        ArrayList recipes = new ArrayList();
        CraftingManager manager = this.getHandle().dO().o().aJ();
        for (NamespacedKey recipeKey : recipeKeys) {
            Optional<RecipeHolder<?>> recipe = manager.a(CraftNamespacedKey.toMinecraft(recipeKey));
            if (!recipe.isPresent()) continue;
            recipes.add(recipe.get());
        }
        return recipes;
    }

    public Entity getShoulderEntityLeft() {
        if (!this.getHandle().gp().g()) {
            Optional<net.minecraft.world.entity.Entity> shoulder = EntityTypes.a(this.getHandle().gp(), this.getHandle().dO());
            return !shoulder.isPresent() ? null : shoulder.get().getBukkitEntity();
        }
        return null;
    }

    public void setShoulderEntityLeft(Entity entity) {
        this.getHandle().i(entity == null ? new NBTTagCompound() : ((CraftEntity)entity).save());
        if (entity != null) {
            entity.remove();
        }
    }

    public Entity getShoulderEntityRight() {
        if (!this.getHandle().gq().g()) {
            Optional<net.minecraft.world.entity.Entity> shoulder = EntityTypes.a(this.getHandle().gq(), this.getHandle().dO());
            return !shoulder.isPresent() ? null : shoulder.get().getBukkitEntity();
        }
        return null;
    }

    public void setShoulderEntityRight(Entity entity) {
        this.getHandle().j(entity == null ? new NBTTagCompound() : ((CraftEntity)entity).save());
        if (entity != null) {
            entity.remove();
        }
    }

    public void openSign(Sign sign, Side side) {
        CraftSign.openSign(sign, (CraftPlayer)this, side);
    }

    public boolean dropItem(boolean dropAll) {
        EntityHuman entityHuman = this.getHandle();
        if (!(entityHuman instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer player = (EntityPlayer)entityHuman;
        boolean success = player.a(dropAll);
        if (!success) {
            return false;
        }
        net.minecraft.world.entity.player.PlayerInventory inv = player.fY();
        OptionalInt optionalSlot = player.cd.b(inv, inv.k);
        optionalSlot.ifPresent(slot -> player.du.a(player.cd, slot, inv.f()));
        return true;
    }

    public float getExhaustion() {
        return this.getHandle().gi().c;
    }

    public void setExhaustion(float value) {
        this.getHandle().gi().c = value;
    }

    public float getSaturation() {
        return this.getHandle().gi().b;
    }

    public void setSaturation(float value) {
        this.getHandle().gi().b = value;
    }

    public int getFoodLevel() {
        return this.getHandle().gi().a;
    }

    public void setFoodLevel(int value) {
        this.getHandle().gi().a = value;
    }

    public int getSaturatedRegenRate() {
        return this.getHandle().gi().saturatedRegenRate;
    }

    public void setSaturatedRegenRate(int i2) {
        this.getHandle().gi().saturatedRegenRate = i2;
    }

    public int getUnsaturatedRegenRate() {
        return this.getHandle().gi().unsaturatedRegenRate;
    }

    public void setUnsaturatedRegenRate(int i2) {
        this.getHandle().gi().unsaturatedRegenRate = i2;
    }

    public int getStarvationRate() {
        return this.getHandle().gi().starvationRate;
    }

    public void setStarvationRate(int i2) {
        this.getHandle().gi().starvationRate = i2;
    }

    public Location getLastDeathLocation() {
        return this.getHandle().gx().map(CraftMemoryMapper::fromNms).orElse(null);
    }

    public void setLastDeathLocation(Location location) {
        if (location == null) {
            this.getHandle().a(Optional.empty());
        } else {
            this.getHandle().a(Optional.of(CraftMemoryMapper.toNms(location)));
        }
    }

    public Firework fireworkBoost(ItemStack fireworkItemStack) {
        Preconditions.checkArgument((fireworkItemStack != null ? 1 : 0) != 0, (Object)"fireworkItemStack must not be null");
        Preconditions.checkArgument((fireworkItemStack.getType() == Material.FIREWORK_ROCKET ? 1 : 0) != 0, (String)"fireworkItemStack must be of type %s", (Object)Material.FIREWORK_ROCKET);
        EntityFireworks fireworks = new EntityFireworks(this.getHandle().dO(), CraftItemStack.asNMSCopy(fireworkItemStack), this.getHandle());
        boolean success = this.getHandle().dO().addFreshEntity(fireworks, CreatureSpawnEvent.SpawnReason.CUSTOM);
        return success ? (Firework)fireworks.getBukkitEntity() : null;
    }

    @Override
    public Entity copy() {
        throw new UnsupportedOperationException("Cannot copy human entities");
    }

    @Override
    public Entity copy(Location location) {
        throw new UnsupportedOperationException("Cannot copy human entities");
    }
}

