/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.entity;

import com.google.common.base.Preconditions;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.animal.frog.Frog;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_21_R1.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftAnimals;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftNamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Frog;

public class CraftFrog
extends CraftAnimals
implements org.bukkit.entity.Frog {
    public CraftFrog(CraftServer server, Frog entity) {
        super(server, entity);
    }

    @Override
    public Frog getHandle() {
        return (Frog)this.entity;
    }

    @Override
    public String toString() {
        return "CraftFrog";
    }

    public Entity getTongueTarget() {
        return this.getHandle().t().map(net.minecraft.world.entity.Entity::getBukkitEntity).orElse(null);
    }

    public void setTongueTarget(Entity target) {
        if (target == null) {
            this.getHandle().s();
        } else {
            this.getHandle().c(((CraftEntity)target).getHandle());
        }
    }

    public Frog.Variant getVariant() {
        return CraftVariant.minecraftHolderToBukkit(this.getHandle().x());
    }

    public void setVariant(Frog.Variant variant) {
        Preconditions.checkArgument((variant != null ? 1 : 0) != 0, (Object)"variant");
        this.getHandle().i(CraftVariant.bukkitToMinecraftHolder(variant));
    }

    public static class CraftVariant {
        public static Frog.Variant minecraftToBukkit(FrogVariant minecraft) {
            Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
            IRegistry registry = CraftRegistry.getMinecraftRegistry(Registries.F);
            Frog.Variant bukkit = (Frog.Variant)Registry.FROG_VARIANT.get(CraftNamespacedKey.fromMinecraft(registry.d(minecraft).orElseThrow().a()));
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            return bukkit;
        }

        public static Frog.Variant minecraftHolderToBukkit(Holder<FrogVariant> minecraft) {
            return CraftVariant.minecraftToBukkit(minecraft.a());
        }

        public static FrogVariant bukkitToMinecraft(Frog.Variant bukkit) {
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            return (FrogVariant)CraftRegistry.getMinecraftRegistry(Registries.F).b(CraftNamespacedKey.toMinecraft(bukkit.getKey())).orElseThrow();
        }

        public static Holder<FrogVariant> bukkitToMinecraftHolder(Frog.Variant bukkit) {
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            IRegistry registry = CraftRegistry.getMinecraftRegistry(Registries.F);
            Holder<FrogVariant> holder = registry.e(CraftVariant.bukkitToMinecraft(bukkit));
            if (holder instanceof Holder.c) {
                Holder.c holder2 = (Holder.c)holder;
                return holder2;
            }
            throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkit) + ", this can happen if a plugin creates its own frog variant with out properly registering it.");
        }
    }
}

