/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.entity;

import com.google.common.base.Preconditions;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.EntityCat;
import net.minecraft.world.item.EnumColor;
import org.bukkit.DyeColor;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_21_R1.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftTameableAnimal;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftNamespacedKey;
import org.bukkit.entity.Cat;

public class CraftCat
extends CraftTameableAnimal
implements Cat {
    public CraftCat(CraftServer server, EntityCat entity) {
        super(server, entity);
    }

    @Override
    public EntityCat getHandle() {
        return (EntityCat)super.getHandle();
    }

    @Override
    public String toString() {
        return "CraftCat";
    }

    public Cat.Type getCatType() {
        return CraftType.minecraftHolderToBukkit(this.getHandle().gv());
    }

    public void setCatType(Cat.Type type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Cannot have null Type");
        this.getHandle().i(CraftType.bukkitToMinecraftHolder(type));
    }

    public DyeColor getCollarColor() {
        return DyeColor.getByWoolData((byte)((byte)this.getHandle().gx().a()));
    }

    public void setCollarColor(DyeColor color) {
        this.getHandle().a(EnumColor.a(color.getWoolData()));
    }

    public void setLyingDown(boolean lyingDown) {
        this.getHandle().A(lyingDown);
    }

    public boolean isLyingDown() {
        return this.getHandle().gw();
    }

    public void setHeadUp(boolean headUp) {
        this.getHandle().B(headUp);
    }

    public boolean isHeadUp() {
        return this.getHandle().gB();
    }

    public static class CraftType {
        public static Cat.Type minecraftToBukkit(CatVariant minecraft) {
            Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
            IRegistry registry = CraftRegistry.getMinecraftRegistry(Registries.l);
            return (Cat.Type)Registry.CAT_VARIANT.get(CraftNamespacedKey.fromMinecraft(registry.b(minecraft)));
        }

        public static Cat.Type minecraftHolderToBukkit(Holder<CatVariant> minecraft) {
            return CraftType.minecraftToBukkit(minecraft.a());
        }

        public static CatVariant bukkitToMinecraft(Cat.Type bukkit) {
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            IRegistry registry = CraftRegistry.getMinecraftRegistry(Registries.l);
            return (CatVariant)registry.a(CraftNamespacedKey.toMinecraft(bukkit.getKey()));
        }

        public static Holder<CatVariant> bukkitToMinecraftHolder(Cat.Type bukkit) {
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            IRegistry registry = CraftRegistry.getMinecraftRegistry(Registries.l);
            Holder<CatVariant> holder = registry.e(CraftType.bukkitToMinecraft(bukkit));
            if (holder instanceof Holder.c) {
                Holder.c holder2 = (Holder.c)holder;
                return holder2;
            }
            throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkit) + ", this can happen if a plugin creates its own cat variant with out properly registering it.");
        }
    }
}

