/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.command;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.tree.CommandNode;
import io.papermc.paper.commands.FeedbackForwardingSender;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Location;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.ProxiedCommandSender;
import org.bukkit.command.RemoteConsoleCommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.command.CraftBlockCommandSender;
import org.bukkit.craftbukkit.v1_21_R1.command.CraftRemoteConsoleCommandSender;
import org.bukkit.craftbukkit.v1_21_R1.command.ProxiedNativeCommandSender;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftMinecartCommand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.minecart.CommandMinecart;

public class VanillaCommandWrapper
extends BukkitCommand {
    public final CommandNode<CommandListenerWrapper> vanillaCommand;

    public VanillaCommandWrapper(String name, String description, String usageMessage, List<String> aliases, CommandNode<CommandListenerWrapper> vanillaCommand) {
        super(name, description, usageMessage, aliases);
        this.vanillaCommand = vanillaCommand;
    }

    CommandDispatcher commands() {
        return MinecraftServer.getServer().aH();
    }

    public VanillaCommandWrapper(CommandDispatcher dispatcher, CommandNode<CommandListenerWrapper> vanillaCommand) {
        super(vanillaCommand.getName(), "A Mojang provided command.", vanillaCommand.getUsageText(), Collections.EMPTY_LIST);
        this.vanillaCommand = vanillaCommand;
        this.setPermission(VanillaCommandWrapper.getPermission(vanillaCommand));
    }

    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        CommandListenerWrapper icommandlistener = VanillaCommandWrapper.getListener(sender);
        this.commands().performPrefixedCommand(icommandlistener, this.toDispatcher(args, this.getName()), this.toDispatcher(args, commandLabel));
        return true;
    }

    public List<String> tabComplete(CommandSender sender, String alias, String[] args, Location location) throws IllegalArgumentException {
        Preconditions.checkArgument((sender != null ? 1 : 0) != 0, (Object)"Sender cannot be null");
        Preconditions.checkArgument((args != null ? 1 : 0) != 0, (Object)"Arguments cannot be null");
        Preconditions.checkArgument((alias != null ? 1 : 0) != 0, (Object)"Alias cannot be null");
        CommandListenerWrapper icommandlistener = VanillaCommandWrapper.getListener(sender);
        ParseResults<CommandListenerWrapper> parsed = this.commands().a().parse(this.toDispatcher(args, this.getName()), icommandlistener);
        ArrayList<String> results = new ArrayList<String>();
        this.commands().a().getCompletionSuggestions(parsed).thenAccept(suggestions -> suggestions.getList().forEach(s2 -> results.add(s2.getText())));
        return results;
    }

    public static CommandListenerWrapper getListener(CommandSender sender) {
        if (sender instanceof Entity) {
            if (sender instanceof CommandMinecart) {
                return ((CraftMinecartCommand)sender).getHandle().B().i();
            }
            return ((CraftEntity)sender).getHandle().dg();
        }
        if (sender instanceof BlockCommandSender) {
            return ((CraftBlockCommandSender)sender).getWrapper();
        }
        if (sender instanceof RemoteConsoleCommandSender) {
            return ((CraftRemoteConsoleCommandSender)sender).getListener().g();
        }
        if (sender instanceof ConsoleCommandSender) {
            return ((CraftServer)sender.getServer()).getServer().aI();
        }
        if (sender instanceof ProxiedCommandSender) {
            return ((ProxiedNativeCommandSender)sender).getHandle();
        }
        if (sender instanceof FeedbackForwardingSender) {
            FeedbackForwardingSender feedback = (FeedbackForwardingSender)sender;
            return feedback.asVanilla();
        }
        throw new IllegalArgumentException("Cannot make " + String.valueOf(sender) + " a vanilla command listener");
    }

    public static String getPermission(CommandNode<CommandListenerWrapper> vanillaCommand) {
        while (vanillaCommand.getRedirect() != null) {
            vanillaCommand = vanillaCommand.getRedirect();
        }
        String commandName = vanillaCommand.getName();
        return "minecraft.command." + VanillaCommandWrapper.stripDefaultNamespace(commandName);
    }

    private static String stripDefaultNamespace(String maybeNamespaced) {
        String prefix = "minecraft:";
        if (maybeNamespaced.startsWith("minecraft:")) {
            return maybeNamespaced.substring("minecraft:".length());
        }
        return maybeNamespaced;
    }

    private String toDispatcher(String[] args, String name) {
        return name + (String)(args.length > 0 ? " " + Joiner.on((char)' ').join((Object[])args) : "");
    }

    public boolean canBeOverriden() {
        return true;
    }

    public boolean isRegistered() {
        return true;
    }
}

