/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.block;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.InclusiveRange;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EquipmentTable;
import net.minecraft.world.level.MobSpawnerData;
import net.minecraft.world.level.block.entity.TileEntityMobSpawner;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.spawner.SpawnRule;
import org.bukkit.block.spawner.SpawnerEntry;
import org.bukkit.craftbukkit.v1_21_R1.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R1.CraftLootTable;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntitySnapshot;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntityType;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.entity.EntitySnapshot;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class CraftCreatureSpawner
extends CraftBlockEntityState<TileEntityMobSpawner>
implements CreatureSpawner {
    public CraftCreatureSpawner(World world, TileEntityMobSpawner tileEntity) {
        super(world, tileEntity);
    }

    protected CraftCreatureSpawner(CraftCreatureSpawner state, Location location) {
        super(state, location);
    }

    public EntityType getSpawnedType() {
        MobSpawnerData spawnData = ((TileEntityMobSpawner)this.getSnapshot()).c().f;
        if (spawnData == null) {
            return null;
        }
        Optional<EntityTypes<?>> type = EntityTypes.a(spawnData.a());
        return type.map(CraftEntityType::minecraftToBukkit).orElse(null);
    }

    public void setSpawnedType(EntityType entityType) {
        if (entityType == null) {
            ((TileEntityMobSpawner)this.getSnapshot()).c().e = SimpleWeightedRandomList.b();
            ((TileEntityMobSpawner)this.getSnapshot()).c().f = new MobSpawnerData();
            return;
        }
        Preconditions.checkArgument((entityType != EntityType.UNKNOWN ? 1 : 0) != 0, (String)"Can't spawn EntityType %s from mob spawners!", (Object)entityType);
        RandomSource rand = this.isPlaced() ? this.getWorldHandle().E_() : RandomSource.a();
        ((TileEntityMobSpawner)this.getSnapshot()).a(CraftEntityType.bukkitToMinecraft(entityType), rand);
    }

    public EntitySnapshot getSpawnedEntity() {
        MobSpawnerData spawnData = ((TileEntityMobSpawner)this.getSnapshot()).c().f;
        if (spawnData == null) {
            return null;
        }
        return CraftEntitySnapshot.create(spawnData.a());
    }

    public void setSpawnedEntity(EntitySnapshot snapshot) {
        NBTTagCompound compoundTag = ((CraftEntitySnapshot)snapshot).getData();
        ((TileEntityMobSpawner)this.getSnapshot()).c().e = SimpleWeightedRandomList.b();
        ((TileEntityMobSpawner)this.getSnapshot()).c().f = new MobSpawnerData(compoundTag, Optional.empty(), Optional.empty());
    }

    public void addPotentialSpawn(EntitySnapshot snapshot, int weight, SpawnRule spawnRule) {
        NBTTagCompound compoundTag = ((CraftEntitySnapshot)snapshot).getData();
        SimpleWeightedRandomList.a<MobSpawnerData> builder = SimpleWeightedRandomList.a();
        ((TileEntityMobSpawner)this.getSnapshot()).c().e.e().forEach(entry -> builder.a((MobSpawnerData)entry.b(), entry.a().a()));
        builder.a(new MobSpawnerData(compoundTag, Optional.ofNullable(this.toMinecraftRule(spawnRule)), Optional.empty()), weight);
        ((TileEntityMobSpawner)this.getSnapshot()).c().e = builder.a();
    }

    public void addPotentialSpawn(SpawnerEntry spawnerEntry) {
        this.addPotentialSpawn(spawnerEntry.getSnapshot(), spawnerEntry.getSpawnWeight(), spawnerEntry.getSpawnRule());
    }

    public void setPotentialSpawns(Collection<SpawnerEntry> entries) {
        SimpleWeightedRandomList.a<MobSpawnerData> builder = SimpleWeightedRandomList.a();
        for (SpawnerEntry spawnerEntry : entries) {
            NBTTagCompound compoundTag = ((CraftEntitySnapshot)spawnerEntry.getSnapshot()).getData();
            builder.a(new MobSpawnerData(compoundTag, Optional.ofNullable(this.toMinecraftRule(spawnerEntry.getSpawnRule())), CraftCreatureSpawner.getEquipment(spawnerEntry.getEquipment())), spawnerEntry.getSpawnWeight());
        }
        ((TileEntityMobSpawner)this.getSnapshot()).c().e = builder.a();
    }

    public List<SpawnerEntry> getPotentialSpawns() {
        ArrayList<SpawnerEntry> entries = new ArrayList<SpawnerEntry>();
        for (WeightedEntry.b entry : ((TileEntityMobSpawner)this.getSnapshot()).c().e.e()) {
            CraftEntitySnapshot snapshot = CraftEntitySnapshot.create(((MobSpawnerData)entry.b()).a());
            if (snapshot == null) continue;
            SpawnRule rule = ((MobSpawnerData)entry.b()).e().map(this::fromMinecraftRule).orElse(null);
            entries.add(new SpawnerEntry((EntitySnapshot)snapshot, entry.a().a(), rule, CraftCreatureSpawner.getEquipment(((MobSpawnerData)entry.b()).f())));
        }
        return entries;
    }

    private MobSpawnerData.a toMinecraftRule(SpawnRule rule) {
        if (rule == null) {
            return null;
        }
        return new MobSpawnerData.a(new InclusiveRange<Integer>(rule.getMinBlockLight(), rule.getMaxBlockLight()), new InclusiveRange<Integer>(rule.getMinSkyLight(), rule.getMaxSkyLight()));
    }

    private SpawnRule fromMinecraftRule(MobSpawnerData.a rule) {
        InclusiveRange<Integer> blockLight = rule.a();
        InclusiveRange<Integer> skyLight = rule.b();
        return new SpawnRule(blockLight.b().intValue(), blockLight.b().intValue(), skyLight.a().intValue(), skyLight.b().intValue());
    }

    public String getCreatureTypeName() {
        MobSpawnerData spawnData = ((TileEntityMobSpawner)this.getSnapshot()).c().f;
        if (spawnData == null) {
            return null;
        }
        Optional<EntityTypes<?>> type = EntityTypes.a(spawnData.a());
        return type.map(CraftEntityType::minecraftToBukkit).map(CraftEntityType::bukkitToString).orElse(null);
    }

    public void setCreatureTypeByName(String creatureType) {
        EntityType type = CraftEntityType.stringToBukkit(creatureType);
        if (type == null) {
            this.setSpawnedType(null);
            return;
        }
        this.setSpawnedType(type);
    }

    public int getDelay() {
        return ((TileEntityMobSpawner)this.getSnapshot()).c().d;
    }

    public void setDelay(int delay) {
        ((TileEntityMobSpawner)this.getSnapshot()).c().d = delay;
    }

    public int getMinSpawnDelay() {
        return ((TileEntityMobSpawner)this.getSnapshot()).c().i;
    }

    public void setMinSpawnDelay(int spawnDelay) {
        Preconditions.checkArgument((spawnDelay <= this.getMaxSpawnDelay() ? 1 : 0) != 0, (Object)"Minimum Spawn Delay must be less than or equal to Maximum Spawn Delay");
        ((TileEntityMobSpawner)this.getSnapshot()).c().i = spawnDelay;
    }

    public int getMaxSpawnDelay() {
        return ((TileEntityMobSpawner)this.getSnapshot()).c().j;
    }

    public void setMaxSpawnDelay(int spawnDelay) {
        Preconditions.checkArgument((spawnDelay > 0 ? 1 : 0) != 0, (Object)"Maximum Spawn Delay must be greater than 0.");
        Preconditions.checkArgument((spawnDelay >= this.getMinSpawnDelay() ? 1 : 0) != 0, (Object)"Maximum Spawn Delay must be greater than or equal to Minimum Spawn Delay");
        ((TileEntityMobSpawner)this.getSnapshot()).c().j = spawnDelay;
    }

    public int getMaxNearbyEntities() {
        return ((TileEntityMobSpawner)this.getSnapshot()).c().m;
    }

    public void setMaxNearbyEntities(int maxNearbyEntities) {
        ((TileEntityMobSpawner)this.getSnapshot()).c().m = maxNearbyEntities;
    }

    public int getSpawnCount() {
        return ((TileEntityMobSpawner)this.getSnapshot()).c().k;
    }

    public void setSpawnCount(int count) {
        ((TileEntityMobSpawner)this.getSnapshot()).c().k = count;
    }

    public int getRequiredPlayerRange() {
        return ((TileEntityMobSpawner)this.getSnapshot()).c().n;
    }

    public void setRequiredPlayerRange(int requiredPlayerRange) {
        ((TileEntityMobSpawner)this.getSnapshot()).c().n = requiredPlayerRange;
    }

    public int getSpawnRange() {
        return ((TileEntityMobSpawner)this.getSnapshot()).c().o;
    }

    public void setSpawnRange(int spawnRange) {
        ((TileEntityMobSpawner)this.getSnapshot()).c().o = spawnRange;
    }

    @Override
    public CraftCreatureSpawner copy() {
        return new CraftCreatureSpawner(this, null);
    }

    @Override
    public CraftCreatureSpawner copy(Location location) {
        return new CraftCreatureSpawner(this, location);
    }

    private static Optional<EquipmentTable> getEquipment(SpawnerEntry.Equipment bukkit) {
        if (bukkit == null) {
            return Optional.empty();
        }
        return Optional.of(new EquipmentTable(CraftLootTable.bukkitToMinecraft(bukkit.getEquipmentLootTable()), bukkit.getDropChances().entrySet().stream().collect(Collectors.toMap(entry -> CraftEquipmentSlot.getNMS((EquipmentSlot)entry.getKey()), Map.Entry::getValue))));
    }

    private static SpawnerEntry.Equipment getEquipment(Optional<EquipmentTable> optional) {
        return optional.map(nms -> new SpawnerEntry.Equipment(CraftLootTable.minecraftToBukkit(nms.a()), new HashMap<EquipmentSlot, Float>(nms.b().entrySet().stream().collect(Collectors.toMap(entry -> CraftEquipmentSlot.getSlot((EnumItemSlot)entry.getKey()), Map.Entry::getValue))))).orElse(null);
    }

    public boolean isActivated() {
        this.requirePlaced();
        return ((TileEntityMobSpawner)this.getSnapshot()).c().c(this.world.getHandle(), this.getPosition());
    }

    public void resetTimer() {
        this.requirePlaced();
        ((TileEntityMobSpawner)this.getSnapshot()).c().d(this.world.getHandle(), this.getPosition());
    }

    public void setSpawnedItem(ItemStack itemStack) {
        Preconditions.checkArgument((itemStack != null && !itemStack.getType().isAir() ? 1 : 0) != 0, (Object)"spawners cannot spawn air");
        net.minecraft.world.item.ItemStack item = CraftItemStack.asNMSCopy(itemStack);
        NBTTagCompound entity = new NBTTagCompound();
        entity.a("id", BuiltInRegistries.f.b(EntityTypes.ag).toString());
        entity.a("Item", item.a(this.world.getHandle().H_()));
        ((TileEntityMobSpawner)this.getSnapshot()).c().a((net.minecraft.world.level.World)(this.isPlaced() ? this.world.getHandle() : null), this.getPosition(), new MobSpawnerData(entity, Optional.empty(), Optional.ofNullable(((TileEntityMobSpawner)this.getSnapshot()).c().f).flatMap(MobSpawnerData::f)));
    }
}

