/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.art.internal;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import net.neoforged.art.api.ClassProvider;
import net.neoforged.art.api.Renamer;
import net.neoforged.art.api.Transformer;
import net.neoforged.art.internal.AsyncHelper;
import net.neoforged.art.internal.SortedClassProvider;
import net.neoforged.cliutils.JarUtils;
import net.neoforged.cliutils.progress.ProgressReporter;

public class RenamerImpl
implements Renamer {
    private static final ProgressReporter PROGRESS = ProgressReporter.getDefault();
    static final int MAX_ASM_VERSION = 589824;
    private static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    private final List<File> libraries;
    private final List<Transformer> transformers;
    private final SortedClassProvider sortedClassProvider;
    private final List<ClassProvider> classProviders;
    private final int threads;
    private final Consumer<String> logger;
    private final Consumer<String> debug;
    private boolean setup = false;
    private ClassProvider libraryClasses;

    RenamerImpl(List<File> libraries, List<Transformer> transformers, SortedClassProvider sortedClassProvider, List<ClassProvider> classProviders, int threads, Consumer<String> logger, Consumer<String> debug) {
        this.libraries = libraries;
        this.transformers = transformers;
        this.sortedClassProvider = sortedClassProvider;
        this.classProviders = Collections.unmodifiableList(classProviders);
        this.threads = threads;
        this.logger = logger;
        this.debug = debug;
    }

    private void setup() {
        if (this.setup) {
            return;
        }
        this.setup = true;
        ClassProvider.Builder libraryClassesBuilder = ClassProvider.builder().shouldCacheAll(true);
        this.logger.accept("Adding Libraries to Inheritance");
        this.libraries.forEach(f2 -> libraryClassesBuilder.addLibrary(f2.toPath()));
        this.libraryClasses = libraryClassesBuilder.build();
    }

    public void run(File input, File output) {
        this.run(input, output, false);
    }

    public void run(File input, File output, boolean remappingSelf) {
        if (!this.setup) {
            this.setup();
        }
        if (Boolean.getBoolean("net.neoforged.progressmanager.enabled")) {
            try {
                PROGRESS.setMaxProgress(JarUtils.getFileCountInZip((File)input));
            }
            catch (IOException e3) {
                this.logger.accept("Failed to read zip file count: " + String.valueOf(e3));
            }
        }
        input = Objects.requireNonNull(input).getAbsoluteFile();
        output = Objects.requireNonNull(output).getAbsoluteFile();
        if (!input.exists()) {
            throw new IllegalArgumentException("Input file not found: " + input.getAbsolutePath());
        }
        this.logger.accept("Reading Input: " + input.getAbsolutePath());
        PROGRESS.setStep("Reading input jar");
        ArrayList<Object> oldEntries = new ArrayList<Object>();
        try (ZipFile in = new ZipFile(input);){
            int amount = 0;
            Enumeration<? extends ZipEntry> entries = in.entries();
            while (entries.hasMoreElements()) {
                byte[] data;
                ZipEntry e4 = entries.nextElement();
                if (e4.isDirectory()) continue;
                String name = e4.getName();
                try (InputStream entryInput = in.getInputStream(e4);){
                    data = entryInput.readAllBytes();
                }
                if (name.endsWith(".class") && !name.contains("META-INF/")) {
                    oldEntries.add(Transformer.ClassEntry.create((String)name, (long)e4.getTime(), (byte[])data));
                } else if (name.equals(MANIFEST_NAME)) {
                    oldEntries.add(Transformer.ManifestEntry.create((long)e4.getTime(), (byte[])data));
                } else if (name.equals("javadoctor.json")) {
                    oldEntries.add(Transformer.JavadoctorEntry.create((long)e4.getTime(), (byte[])data));
                } else {
                    oldEntries.add(Transformer.ResourceEntry.create((String)name, (long)e4.getTime(), (byte[])data));
                }
                if (++amount % 10 != 0) continue;
                PROGRESS.setProgress(amount);
            }
        }
        catch (IOException e5) {
            throw new RuntimeException("Could not parse input: " + input.getAbsolutePath(), e5);
        }
        this.sortedClassProvider.clearCache();
        ArrayList<ClassProvider> classProviders = new ArrayList<ClassProvider>(this.classProviders);
        classProviders.add(0, this.libraryClasses);
        this.sortedClassProvider.classProviders = classProviders;
        AsyncHelper async = new AsyncHelper(this.threads);
        try {
            PROGRESS.setProgress(0);
            PROGRESS.setIndeterminate(true);
            PROGRESS.setStep("Processing entries");
            List ourClasses = oldEntries.stream().filter(e2 -> e2 instanceof Transformer.ClassEntry && !e2.getName().startsWith("META-INF/")).map(Transformer.ClassEntry.class::cast).collect(Collectors.toList());
            this.logger.accept("Adding input to inheritance map");
            ClassProvider.Builder inputClassesBuilder = ClassProvider.builder();
            async.consumeAll(ourClasses, Transformer.ClassEntry::getClassName, c2 -> inputClassesBuilder.addClass(c2.getName().substring(0, c2.getName().length() - 6), c2.getData()));
            classProviders.add(0, inputClassesBuilder.build());
            this.logger.accept("Processing entries");
            ArrayList<Transformer.Entry> newEntries = async.invokeAll(oldEntries, Transformer.Entry::getName, this::processEntry);
            this.logger.accept("Adding extras");
            ArrayList<Transformer.Entry> finalNewEntries = newEntries;
            this.transformers.forEach(t2 -> finalNewEntries.addAll(t2.getExtras()));
            HashSet<String> seen = new HashSet<String>();
            if (remappingSelf) {
                ArrayList<Transformer.Entry> n3 = new ArrayList<Transformer.Entry>();
                for (Transformer.Entry e6 : newEntries) {
                    if (!seen.add(e6.getName())) continue;
                    n3.add(e6);
                }
                newEntries = n3;
            } else {
                String dupes = newEntries.stream().map(Transformer.Entry::getName).filter(n2 -> !seen.add((String)n2)).sorted().collect(Collectors.joining(", "));
                if (!dupes.isEmpty()) {
                    throw new IllegalStateException("Duplicate entries detected: " + dupes);
                }
            }
            this.logger.accept("Sorting");
            Collections.sort(newEntries, this::compare);
            if (!output.getParentFile().exists()) {
                output.getParentFile().mkdirs();
            }
            seen.clear();
            PROGRESS.setMaxProgress(newEntries.size());
            PROGRESS.setStep("Writing output");
            this.logger.accept("Writing Output: " + output.getAbsolutePath());
            try (BufferedOutputStream fos = new BufferedOutputStream(Files.newOutputStream(output.toPath(), new OpenOption[0]));
                 ZipOutputStream zos = new ZipOutputStream(fos);){
                int amount = 0;
                for (Transformer.Entry e7 : newEntries) {
                    String name = e7.getName();
                    int idx = name.lastIndexOf(47);
                    if (idx != -1) {
                        this.addDirectory(zos, seen, name.substring(0, idx));
                    }
                    this.logger.accept("  " + name);
                    ZipEntry entry = new ZipEntry(name);
                    entry.setTime(e7.getTime());
                    zos.putNextEntry(entry);
                    zos.write(e7.getData());
                    zos.closeEntry();
                    if (++amount % 10 != 0) continue;
                    PROGRESS.setProgress(amount);
                }
                PROGRESS.setProgress(amount);
            }
        }
        catch (IOException e8) {
            throw new RuntimeException("Could not write to file " + output.getAbsolutePath(), e8);
        }
        finally {
            async.shutdown();
        }
    }

    private byte[] readAllBytes(InputStream in, long size) throws IOException {
        int read;
        ByteArrayOutputStream tmp = new ByteArrayOutputStream(size >= 0L ? (int)size : 0);
        byte[] buffer = new byte[8192];
        while ((read = in.read(buffer)) != -1) {
            tmp.write(buffer, 0, read);
        }
        return tmp.toByteArray();
    }

    private void addDirectory(ZipOutputStream zos, Set<String> seen, String path) throws IOException {
        if (!seen.add(path)) {
            return;
        }
        int idx = path.lastIndexOf(47);
        if (idx != -1) {
            this.addDirectory(zos, seen, path.substring(0, idx));
        }
        this.logger.accept("  " + path + "/");
        ZipEntry dir = new ZipEntry(path + "/");
        dir.setTime(946684800L);
        zos.putNextEntry(dir);
        zos.closeEntry();
    }

    private Transformer.Entry processEntry(Transformer.Entry start) {
        Transformer.Entry entry = start;
        for (Transformer transformer : this.transformers) {
            if ((entry = entry.process(transformer)) != null) continue;
            return null;
        }
        return entry;
    }

    private int compare(Transformer.Entry o1, Transformer.Entry o2) {
        if (MANIFEST_NAME.equals(o1.getName())) {
            return MANIFEST_NAME.equals(o2.getName()) ? 0 : -1;
        }
        if (MANIFEST_NAME.equals(o2.getName())) {
            return MANIFEST_NAME.equals(o1.getName()) ? 0 : 1;
        }
        return o1.getName().compareTo(o2.getName());
    }

    public void close() throws IOException {
        this.sortedClassProvider.close();
    }
}

