/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.chunk.ILightAccess;
import net.minecraft.world.level.chunk.NibbleArray;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.level.lighting.LightEngineStorageArray;

public abstract class LightEngineStorage<M extends LightEngineStorageArray<M>> {
    private final EnumSkyBlock i;
    protected final ILightAccess a;
    protected final Long2ByteMap b = new Long2ByteOpenHashMap();
    private final LongSet j = new LongOpenHashSet();
    protected volatile M c;
    protected final M d;
    protected final LongSet e = new LongOpenHashSet();
    protected final LongSet f = new LongOpenHashSet();
    protected final Long2ObjectMap<NibbleArray> g = Long2ObjectMaps.synchronize((Long2ObjectMap)new Long2ObjectOpenHashMap());
    private final LongSet k = new LongOpenHashSet();
    private final LongSet l = new LongOpenHashSet();
    protected volatile boolean h;

    protected LightEngineStorage(EnumSkyBlock lightType, ILightAccess chunkProvider, M lightData) {
        this.i = lightType;
        this.a = chunkProvider;
        this.d = lightData;
        this.c = ((LightEngineStorageArray)lightData).b();
        ((LightEngineStorageArray)this.c).d();
        this.b.defaultReturnValue((byte)0);
    }

    protected boolean b(long sectionPos) {
        return this.a(sectionPos, true) != null;
    }

    @Nullable
    protected NibbleArray a(long sectionPos, boolean cached) {
        return this.a(cached ? this.d : this.c, sectionPos);
    }

    @Nullable
    protected NibbleArray a(M storage, long sectionPos) {
        return ((LightEngineStorageArray)storage).c(sectionPos);
    }

    @Nullable
    protected NibbleArray c(long sectionPos) {
        NibbleArray dataLayer = ((LightEngineStorageArray)this.d).c(sectionPos);
        if (dataLayer == null) {
            return null;
        }
        if (this.e.add(sectionPos)) {
            dataLayer = dataLayer.b();
            ((LightEngineStorageArray)this.d).a(sectionPos, dataLayer);
            ((LightEngineStorageArray)this.d).c();
        }
        return dataLayer;
    }

    @Nullable
    public NibbleArray d(long sectionPos) {
        NibbleArray dataLayer = (NibbleArray)this.g.get(sectionPos);
        if (dataLayer != null) {
            return dataLayer;
        }
        return this.a(sectionPos, false);
    }

    protected abstract int a(long var1);

    protected int e(long blockPos) {
        long l2 = SectionPosition.e(blockPos);
        NibbleArray dataLayer = this.a(l2, true);
        return dataLayer.a(SectionPosition.b(BlockPosition.a(blockPos)), SectionPosition.b(BlockPosition.b(blockPos)), SectionPosition.b(BlockPosition.c(blockPos)));
    }

    protected void a(long blockPos, int value) {
        NibbleArray dataLayer2;
        long l2 = SectionPosition.e(blockPos);
        if (this.e.add(l2)) {
            NibbleArray dataLayer = ((LightEngineStorageArray)this.d).a(l2);
        } else {
            dataLayer2 = this.a(l2, true);
        }
        dataLayer2.a(SectionPosition.b(BlockPosition.a(blockPos)), SectionPosition.b(BlockPosition.b(blockPos)), SectionPosition.b(BlockPosition.c(blockPos)), value);
        SectionPosition.a(blockPos, arg_0 -> ((LongSet)this.f).add(arg_0));
    }

    protected void f(long id) {
        int i2 = SectionPosition.b(id);
        int j2 = SectionPosition.c(id);
        int k2 = SectionPosition.d(id);
        for (int l2 = -1; l2 <= 1; ++l2) {
            for (int m2 = -1; m2 <= 1; ++m2) {
                for (int n2 = -1; n2 <= 1; ++n2) {
                    this.f.add(SectionPosition.b(i2 + m2, j2 + n2, k2 + l2));
                }
            }
        }
    }

    protected NibbleArray g(long sectionPos) {
        NibbleArray dataLayer = (NibbleArray)this.g.get(sectionPos);
        if (dataLayer != null) {
            return dataLayer;
        }
        return new NibbleArray();
    }

    protected boolean a() {
        return this.h;
    }

    protected void a(LightEngine<M, ?> lightProvider) {
        if (!this.h) {
            return;
        }
        this.h = false;
        LongIterator longIterator = this.l.iterator();
        while (longIterator.hasNext()) {
            long l2 = (Long)longIterator.next();
            NibbleArray dataLayer = (NibbleArray)this.g.remove(l2);
            NibbleArray dataLayer2 = ((LightEngineStorageArray)this.d).d(l2);
            if (!this.k.contains(SectionPosition.f(l2))) continue;
            if (dataLayer != null) {
                this.g.put(l2, (Object)dataLayer);
                continue;
            }
            if (dataLayer2 == null) continue;
            this.g.put(l2, (Object)dataLayer2);
        }
        ((LightEngineStorageArray)this.d).c();
        longIterator = this.l.iterator();
        while (longIterator.hasNext()) {
            long m2 = (Long)longIterator.next();
            this.i(m2);
            this.e.add(m2);
        }
        this.l.clear();
        ObjectIterator objectIterator = Long2ObjectMaps.fastIterator(this.g);
        while (objectIterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)objectIterator.next();
            long n2 = entry.getLongKey();
            if (!this.b(n2)) continue;
            NibbleArray dataLayer3 = (NibbleArray)entry.getValue();
            if (((LightEngineStorageArray)this.d).c(n2) != dataLayer3) {
                ((LightEngineStorageArray)this.d).a(n2, dataLayer3);
                this.e.add(n2);
            }
            objectIterator.remove();
        }
        ((LightEngineStorageArray)this.d).c();
    }

    protected void h(long sectionPos) {
    }

    protected void i(long sectionPos) {
    }

    protected void b(long columnPos, boolean enabled) {
        if (enabled) {
            this.j.add(columnPos);
        } else {
            this.j.remove(columnPos);
        }
    }

    protected boolean j(long sectionPos) {
        long l2 = SectionPosition.f(sectionPos);
        return this.j.contains(l2);
    }

    public void c(long sectionPos, boolean retain) {
        if (retain) {
            this.k.add(sectionPos);
        } else {
            this.k.remove(sectionPos);
        }
    }

    protected void a(long sectionPos, @Nullable NibbleArray array) {
        if (array != null) {
            this.g.put(sectionPos, (Object)array);
            this.h = true;
        } else {
            this.g.remove(sectionPos);
        }
    }

    protected void d(long sectionPos, boolean notReady) {
        byte c2;
        byte b2 = this.b.get(sectionPos);
        if (b2 == (c2 = net.minecraft.world.level.lighting.LightEngineStorage$a.a(b2, !notReady))) {
            return;
        }
        this.a(sectionPos, c2);
        int i2 = notReady ? -1 : 1;
        for (int j2 = -1; j2 <= 1; ++j2) {
            for (int k2 = -1; k2 <= 1; ++k2) {
                for (int l2 = -1; l2 <= 1; ++l2) {
                    if (j2 == 0 && k2 == 0 && l2 == 0) continue;
                    long m2 = SectionPosition.a(sectionPos, j2, k2, l2);
                    byte d2 = this.b.get(m2);
                    this.a(m2, net.minecraft.world.level.lighting.LightEngineStorage$a.a(d2, net.minecraft.world.level.lighting.LightEngineStorage$a.b(d2) + i2));
                }
            }
        }
    }

    protected void a(long sectionPos, byte flags) {
        if (flags != 0) {
            if (this.b.put(sectionPos, flags) == 0) {
                this.l(sectionPos);
            }
        } else if (this.b.remove(sectionPos) != 0) {
            this.m(sectionPos);
        }
    }

    private void l(long sectionPos) {
        if (!this.l.remove(sectionPos)) {
            ((LightEngineStorageArray)this.d).a(sectionPos, this.g(sectionPos));
            this.e.add(sectionPos);
            this.h(sectionPos);
            this.f(sectionPos);
            this.h = true;
        }
    }

    private void m(long sectionPos) {
        this.l.add(sectionPos);
        this.h = true;
    }

    protected void b() {
        if (!this.e.isEmpty()) {
            Object dataLayerStorageMap = ((LightEngineStorageArray)this.d).b();
            ((LightEngineStorageArray)dataLayerStorageMap).d();
            this.c = dataLayerStorageMap;
            this.e.clear();
        }
        if (!this.f.isEmpty()) {
            LongIterator longIterator = this.f.iterator();
            while (longIterator.hasNext()) {
                long l2 = longIterator.nextLong();
                this.a.a(this.i, SectionPosition.a(l2));
            }
            this.f.clear();
        }
    }

    public b k(long sectionPos) {
        return net.minecraft.world.level.lighting.LightEngineStorage$a.c(this.b.get(sectionPos));
    }

    protected static class a {
        public static final byte a = 0;
        private static final int b = 0;
        private static final int c = 26;
        private static final byte d = 32;
        private static final byte e = 31;

        protected a() {
        }

        public static byte a(byte packed, boolean ready) {
            return (byte)(ready ? packed | 0x20 : packed & 0xFFFFFFDF);
        }

        public static byte a(byte packed, int neighborCount) {
            if (neighborCount < 0 || neighborCount > 26) {
                throw new IllegalArgumentException("Neighbor count was not within range [0; 26]");
            }
            return (byte)(packed & 0xFFFFFFE0 | neighborCount & 0x1F);
        }

        public static boolean a(byte packed) {
            return (packed & 0x20) != 0;
        }

        public static int b(byte packed) {
            return packed & 0x1F;
        }

        public static b c(byte packed) {
            if (packed == 0) {
                return net.minecraft.world.level.lighting.LightEngineStorage$b.a;
            }
            if (net.minecraft.world.level.lighting.LightEngineStorage$a.a(packed)) {
                return net.minecraft.world.level.lighting.LightEngineStorage$b.c;
            }
            return net.minecraft.world.level.lighting.LightEngineStorage$b.b;
        }
    }

    public static final class b
    extends Enum<b> {
        public static final /* enum */ b a = new b("2");
        public static final /* enum */ b b = new b("1");
        public static final /* enum */ b c = new b("0");
        private final String d;
        private static final /* synthetic */ b[] e;

        public static b[] values() {
            return (b[])e.clone();
        }

        public static b valueOf(String string) {
            return Enum.valueOf(b.class, string);
        }

        private b(String sigil) {
            this.d = sigil;
        }

        public String a() {
            return this.d;
        }

        private static /* synthetic */ b[] b() {
            return new b[]{a, b, c};
        }

        static {
            e = net.minecraft.world.level.lighting.LightEngineStorage$b.b();
        }
    }
}

