/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.templatesystem;

import ca.spottedleaf.dataconverter.minecraft.MCDataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.FileUtils;
import net.minecraft.ResourceKeyInvalidException;
import net.minecraft.SharedConstants;
import net.minecraft.core.HolderGetter;
import net.minecraft.gametest.framework.GameTestHarnessStructures;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.util.FastBufferedInputStream;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.SavedFile;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class StructureTemplateManager {
    private static final Logger b = LogUtils.getLogger();
    public static final String a = "structure";
    private static final String c = "structures";
    private static final String d = ".nbt";
    private static final String e = ".snbt";
    public final Map<MinecraftKey, Optional<DefinedStructure>> f = Maps.newConcurrentMap();
    private final DataFixer g;
    private IResourceManager h;
    private final Path i;
    private final List<b> j;
    private final HolderGetter<Block> k;
    private static final FileToIdConverter l = new FileToIdConverter("structure", ".nbt");

    public StructureTemplateManager(IResourceManager resourceManager, Convertable.ConversionSession session, DataFixer dataFixer, HolderGetter<Block> blockLookup) {
        this.h = resourceManager;
        this.g = dataFixer;
        this.i = session.a(SavedFile.i).normalize();
        this.k = blockLookup;
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new b(this::h, this::d));
        if (SharedConstants.aV) {
            builder.add((Object)new b(this::g, this::c));
        }
        builder.add((Object)new b(this::f, this::b));
        this.j = builder.build();
    }

    public DefinedStructure a(MinecraftKey id) {
        Optional<DefinedStructure> optional = this.b(id);
        if (optional.isPresent()) {
            return optional.get();
        }
        DefinedStructure structureTemplate = new DefinedStructure();
        this.f.put(id, Optional.of(structureTemplate));
        return structureTemplate;
    }

    public Optional<DefinedStructure> b(MinecraftKey id) {
        return this.f.computeIfAbsent(id, this::e);
    }

    public Stream<MinecraftKey> a() {
        return this.j.stream().flatMap(provider -> provider.b().get()).distinct();
    }

    private Optional<DefinedStructure> e(MinecraftKey id) {
        for (b source : this.j) {
            try {
                Optional<DefinedStructure> optional = source.a().apply(id);
                if (!optional.isPresent()) continue;
                return optional;
            }
            catch (Exception exception) {
            }
        }
        return Optional.empty();
    }

    public void a(IResourceManager resourceManager) {
        this.h = resourceManager;
        this.f.clear();
    }

    public Optional<DefinedStructure> f(MinecraftKey id) {
        MinecraftKey resourceLocation = l.a(id);
        return this.a(() -> this.h.open(resourceLocation), (Throwable throwable) -> b.error("Couldn't load structure {}", (Object)id, throwable));
    }

    private Stream<MinecraftKey> b() {
        return l.a(this.h).keySet().stream().map(l::b);
    }

    private Optional<DefinedStructure> g(MinecraftKey id) {
        return this.a(id, Paths.get(GameTestHarnessStructures.c, new String[0]));
    }

    private Stream<MinecraftKey> c() {
        Path path = Paths.get(GameTestHarnessStructures.c, new String[0]);
        if (!Files.isDirectory(path, new LinkOption[0])) {
            return Stream.empty();
        }
        ArrayList list = new ArrayList();
        this.a(path, "minecraft", e, list::add);
        return list.stream();
    }

    public Optional<DefinedStructure> h(MinecraftKey id) {
        if (!Files.isDirectory(this.i, new LinkOption[0])) {
            return Optional.empty();
        }
        Path path = this.a(id, d);
        return this.a(() -> new FileInputStream(path.toFile()), (Throwable throwable) -> b.error("Couldn't load structure from {}", (Object)path, throwable));
    }

    private Stream<MinecraftKey> d() {
        if (!Files.isDirectory(this.i, new LinkOption[0])) {
            return Stream.empty();
        }
        try {
            ArrayList list = new ArrayList();
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(this.i, pathx -> Files.isDirectory(pathx, new LinkOption[0]));){
                for (Path path : directoryStream) {
                    String string = path.getFileName().toString();
                    Path path2 = path.resolve(c);
                    this.a(path2, string, d, list::add);
                }
            }
            return list.stream();
        }
        catch (IOException var9) {
            return Stream.empty();
        }
    }

    private void a(Path directory, String namespace, String fileExtension, Consumer<MinecraftKey> idConsumer) {
        int i2 = fileExtension.length();
        Function<String, String> function = filename -> filename.substring(0, filename.length() - i2);
        try (Stream<Path> stream = Files.find(directory, Integer.MAX_VALUE, (path, attributes) -> attributes.isRegularFile() && path.toString().endsWith(fileExtension), new FileVisitOption[0]);){
            stream.forEach(path -> {
                try {
                    idConsumer.accept(MinecraftKey.a(namespace, (String)function.apply(this.a(directory, (Path)path))));
                }
                catch (ResourceKeyInvalidException var7x) {
                    b.error("Invalid location while listing folder {} contents", (Object)directory, (Object)var7x);
                }
            });
        }
        catch (IOException var12) {
            b.error("Failed to list folder {} contents", (Object)directory, (Object)var12);
        }
    }

    private String a(Path root, Path path) {
        return root.relativize(path).toString().replace(File.separator, "/");
    }

    private Optional<DefinedStructure> a(MinecraftKey id, Path path) {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            return Optional.empty();
        }
        Path path2 = FileUtils.b(path, id.a(), e);
        try {
            Optional<DefinedStructure> var6;
            try (BufferedReader bufferedReader = Files.newBufferedReader(path2);){
                String string = IOUtils.toString((Reader)bufferedReader);
                var6 = Optional.of(this.a(GameProfileSerializer.a(string)));
            }
            return var6;
        }
        catch (NoSuchFileException var9) {
            return Optional.empty();
        }
        catch (CommandSyntaxException | IOException var10) {
            b.error("Couldn't load structure from {}", (Object)path2, (Object)var10);
            return Optional.empty();
        }
    }

    private Optional<DefinedStructure> a(a opener, Consumer<Throwable> exceptionConsumer) {
        try {
            Optional<DefinedStructure> var5;
            try (InputStream inputStream = opener.open();
                 FastBufferedInputStream inputStream2 = new FastBufferedInputStream(inputStream);){
                var5 = Optional.of(this.a(inputStream2));
            }
            return var5;
        }
        catch (FileNotFoundException var11) {
            return Optional.empty();
        }
        catch (Throwable var12) {
            exceptionConsumer.accept(var12);
            return Optional.empty();
        }
    }

    public DefinedStructure a(InputStream templateIInputStream) throws IOException {
        NBTTagCompound compoundTag = NBTCompressedStreamTools.a(templateIInputStream, NBTReadLimiter.a());
        return this.a(compoundTag);
    }

    public DefinedStructure a(NBTTagCompound nbt) {
        DefinedStructure structureTemplate = new DefinedStructure();
        int i2 = GameProfileSerializer.b(nbt, 500);
        structureTemplate.a(this.k, MCDataConverter.convertTag(MCTypeRegistry.STRUCTURE, nbt, i2, SharedConstants.b().d().c()));
        return structureTemplate;
    }

    public boolean c(MinecraftKey id) {
        Optional<DefinedStructure> optional = this.f.get(id);
        if (optional.isEmpty()) {
            return false;
        }
        DefinedStructure structureTemplate = optional.get();
        Path path = this.a(id, d);
        Path path2 = path.getParent();
        if (path2 == null) {
            return false;
        }
        try {
            Files.createDirectories(Files.exists(path2, new LinkOption[0]) ? path2.toRealPath(new LinkOption[0]) : path2, new FileAttribute[0]);
        }
        catch (IOException var13) {
            b.error("Failed to create parent directory: {}", (Object)path2);
            return false;
        }
        NBTTagCompound compoundTag = structureTemplate.a(new NBTTagCompound());
        try {
            try (FileOutputStream outputStream = new FileOutputStream(path.toFile());){
                NBTCompressedStreamTools.a(compoundTag, outputStream);
            }
            return true;
        }
        catch (Throwable var12) {
            return false;
        }
    }

    public Path a(MinecraftKey id, String extension) {
        if (id.a().contains("//")) {
            throw new ResourceKeyInvalidException("Invalid resource path: " + String.valueOf(id));
        }
        try {
            Path path = this.i.resolve(id.b());
            Path path2 = path.resolve(c);
            Path path3 = FileUtils.b(path2, id.a(), extension);
            if (path3.startsWith(this.i) && FileUtils.a(path3) && FileUtils.b(path3)) {
                return path3;
            }
            throw new ResourceKeyInvalidException("Invalid resource path: " + String.valueOf(path3));
        }
        catch (InvalidPathException var6) {
            throw new ResourceKeyInvalidException("Invalid resource path: " + String.valueOf(id), var6);
        }
    }

    public void d(MinecraftKey id) {
        this.f.remove(id);
    }

    record b(Function<MinecraftKey, Optional<DefinedStructure>> a, Supplier<Stream<MinecraftKey>> b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "loader;lister", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "loader;lister", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "loader;lister", "a", "b"}, this, o2);
        }
    }

    @FunctionalInterface
    static interface a {
        public InputStream open() throws IOException;
    }
}

