/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructureJigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasBinding;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;

public final class JigsawStructure
extends Structure {
    public static final DimensionPadding d = DimensionPadding.b;
    public static final LiquidSettings e = LiquidSettings.b;
    public static final int f = 128;
    public static final int g = 0;
    public static final int h = 20;
    public static final MapCodec<JigsawStructure> i = RecordCodecBuilder.mapCodec(instance -> instance.group(JigsawStructure.a(instance), (App)WorldGenFeatureDefinedStructurePoolTemplate.b.fieldOf("start_pool").forGetter(structure -> structure.j), (App)MinecraftKey.a.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.k), (App)Codec.intRange((int)0, (int)20).fieldOf("size").forGetter(structure -> structure.l), (App)HeightProvider.c.fieldOf("start_height").forGetter(structure -> structure.m), (App)Codec.BOOL.fieldOf("use_expansion_hack").forGetter(structure -> structure.n), (App)HeightMap.Type.g.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.o), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.p), (App)Codec.list(PoolAliasBinding.b).optionalFieldOf("pool_aliases", List.of()).forGetter(structure -> structure.q), (App)DimensionPadding.a.optionalFieldOf("dimension_padding", (Object)d).forGetter(structure -> structure.r), (App)LiquidSettings.c.optionalFieldOf("liquid_settings", (Object)e).forGetter(jigsawStructure -> jigsawStructure.s)).apply((Applicative)instance, JigsawStructure::new)).validate(JigsawStructure::a);
    private final Holder<WorldGenFeatureDefinedStructurePoolTemplate> j;
    private final Optional<MinecraftKey> k;
    private final int l;
    private final HeightProvider m;
    private final boolean n;
    private final Optional<HeightMap.Type> o;
    private final int p;
    private final List<PoolAliasBinding> q;
    private final DimensionPadding r;
    private final LiquidSettings s;

    private static DataResult<JigsawStructure> a(JigsawStructure structure) {
        int i2;
        switch (structure.d()) {
            default: {
                throw new MatchException(null, null);
            }
            case a: {
                int n2 = 0;
                break;
            }
            case b: 
            case c: 
            case d: 
            case e: {
                int n2 = i2 = 12;
            }
        }
        if (structure.p + i2 > 128) {
            return DataResult.error(() -> "Structure size including terrain adaptation must not exceed 128");
        }
        return DataResult.success((Object)structure);
    }

    public JigsawStructure(Structure.c config, Holder<WorldGenFeatureDefinedStructurePoolTemplate> startPool, Optional<MinecraftKey> startJigsawName, int size, HeightProvider startHeight, boolean useExpansionHack, Optional<HeightMap.Type> projectStartToHeightmap, int maxDistanceFromCenter, List<PoolAliasBinding> poolAliasBindings, DimensionPadding dimensionPadding, LiquidSettings liquidSettings) {
        super(config);
        this.j = startPool;
        this.k = startJigsawName;
        this.l = size;
        this.m = startHeight;
        this.n = useExpansionHack;
        this.o = projectStartToHeightmap;
        this.p = maxDistanceFromCenter;
        this.q = poolAliasBindings;
        this.r = dimensionPadding;
        this.s = liquidSettings;
    }

    public JigsawStructure(Structure.c config, Holder<WorldGenFeatureDefinedStructurePoolTemplate> startPool, int size, HeightProvider startHeight, boolean useExpansionHack, HeightMap.Type projectStartToHeightmap) {
        this(config, startPool, Optional.empty(), size, startHeight, useExpansionHack, Optional.of(projectStartToHeightmap), 80, List.of(), d, e);
    }

    public JigsawStructure(Structure.c config, Holder<WorldGenFeatureDefinedStructurePoolTemplate> startPool, int size, HeightProvider startHeight, boolean useExpansionHack) {
        this(config, startPool, Optional.empty(), size, startHeight, useExpansionHack, Optional.empty(), 80, List.of(), d, e);
    }

    @Override
    @Override
    public Optional<Structure.b> a(Structure.a context) {
        ChunkCoordIntPair chunkPos = context.h();
        int i2 = this.m.a(context.f(), new WorldGenerationContext(context.b(), context.i()));
        BlockPosition blockPos = new BlockPosition(chunkPos.d(), i2, chunkPos.e());
        return WorldGenFeatureDefinedStructureJigsawPlacement.a(context, this.j, this.k, this.l, blockPos, this.n, this.o, this.p, PoolAliasLookup.create(this.q, blockPos, context.g()), this.r, this.s);
    }

    @Override
    @Override
    public StructureType<?> e() {
        return StructureType.f;
    }
}

