/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import ca.spottedleaf.dataconverter.minecraft.MCDataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.moonrise.common.map.SynchronisedLong2BooleanMap;
import ca.spottedleaf.moonrise.common.map.SynchronisedLong2ObjectMap;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.visitors.CollectFields;
import net.minecraft.nbt.visitors.FieldSelector;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.chunk.storage.IChunkLoader;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.structures.BuriedTreasureStructure;
import net.minecraft.world.level.levelgen.structure.structures.MineshaftStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.slf4j.Logger;

public class StructureCheck {
    private static final Logger a = LogUtils.getLogger();
    private static final int b = -1;
    private final ChunkScanAccess c;
    private final IRegistryCustom d;
    private final StructureTemplateManager e;
    private final ResourceKey<WorldDimension> f;
    private final ChunkGenerator g;
    private final RandomState h;
    private final LevelHeightAccessor i;
    private final WorldChunkManager j;
    private final long k;
    private final DataFixer l;
    private static final int CHUNK_TOTAL_LIMIT = 2020050;
    private static final int PER_FEATURE_CHECK_LIMIT = 2020050;
    private final SynchronisedLong2ObjectMap<Object2IntMap<Structure>> loadedChunksSafe = new SynchronisedLong2ObjectMap(2020050);
    private final ConcurrentHashMap<Structure, SynchronisedLong2BooleanMap> featureChecksSafe = new ConcurrentHashMap();

    public StructureCheck(ChunkScanAccess chunkIoWorker, IRegistryCustom registryManager, StructureTemplateManager structureTemplateManager, ResourceKey<WorldDimension> worldKey, ChunkGenerator chunkGenerator, RandomState noiseConfig, LevelHeightAccessor world, WorldChunkManager biomeSource, long seed, DataFixer dataFixer) {
        this.c = chunkIoWorker;
        this.d = registryManager;
        this.e = structureTemplateManager;
        this.f = worldKey;
        this.g = chunkGenerator;
        this.h = noiseConfig;
        this.i = world;
        this.j = biomeSource;
        this.k = seed;
        this.l = dataFixer;
    }

    @Nullable
    private Integer getSaltOverride(Structure type) {
        LevelHeightAccessor levelHeightAccessor = this.i;
        if (levelHeightAccessor instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)levelHeightAccessor;
            if (type instanceof MineshaftStructure) {
                return serverLevel.spigotConfig.mineshaftSeed;
            }
            if (type instanceof BuriedTreasureStructure) {
                return serverLevel.spigotConfig.buriedTreasureSeed;
            }
        }
        return null;
    }

    public StructureCheckResult a(ChunkCoordIntPair pos, Structure type, StructurePlacement placement, boolean skipReferencedStructures) {
        long l2 = pos.a();
        Object2IntMap<Structure> object2IntMap = this.loadedChunksSafe.get(l2);
        if (object2IntMap != null) {
            return this.a(object2IntMap, type, skipReferencedStructures);
        }
        StructureCheckResult structureCheckResult = this.a(pos, type, skipReferencedStructures, l2);
        if (structureCheckResult != null) {
            return structureCheckResult;
        }
        if (!placement.applyAdditionalChunkRestrictions(pos.e, pos.f, this.k, this.getSaltOverride(type))) {
            return StructureCheckResult.b;
        }
        boolean bl = this.featureChecksSafe.computeIfAbsent(type, structure2 -> new SynchronisedLong2BooleanMap(2020050)).getOrCompute(l2, chunkPos -> this.b(pos, type));
        return !bl ? StructureCheckResult.b : StructureCheckResult.c;
    }

    private boolean b(ChunkCoordIntPair pos, Structure structure) {
        return structure.b(new Structure.a(this.d, this.g, this.j, this.h, this.e, this.k, pos, this.i, structure.a()::a)).isPresent();
    }

    @Nullable
    private StructureCheckResult a(ChunkCoordIntPair pos, Structure structure, boolean skipReferencedStructures, long posLong) {
        NBTTagCompound compoundTag2;
        CollectFields collectFields = new CollectFields(new FieldSelector(NBTTagInt.a, "DataVersion"), new FieldSelector("Level", "Structures", NBTTagCompound.b, "Starts"), new FieldSelector("structures", NBTTagCompound.b, "starts"));
        try {
            this.c.a(pos, collectFields).join();
        }
        catch (Exception var13) {
            a.warn("Failed to read chunk {}", (Object)pos, (Object)var13);
            return StructureCheckResult.c;
        }
        NBTBase nBTBase = collectFields.d();
        if (!(nBTBase instanceof NBTTagCompound)) {
            return null;
        }
        NBTTagCompound compoundTag = (NBTTagCompound)nBTBase;
        int i2 = IChunkLoader.a(compoundTag);
        if (i2 <= 1493) {
            return StructureCheckResult.c;
        }
        IChunkLoader.a(compoundTag, this.f, this.g.c());
        try {
            compoundTag2 = MCDataConverter.convertTag(MCTypeRegistry.CHUNK, compoundTag, i2, SharedConstants.b().d().c());
        }
        catch (Exception var12) {
            a.warn("Failed to partially datafix chunk {}", (Object)pos, (Object)var12);
            return StructureCheckResult.c;
        }
        Object2IntMap<Structure> object2IntMap = this.a(compoundTag2);
        if (object2IntMap == null) {
            return null;
        }
        this.a(posLong, object2IntMap);
        return this.a(object2IntMap, structure, skipReferencedStructures);
    }

    @Nullable
    private Object2IntMap<Structure> a(NBTTagCompound nbt) {
        if (!nbt.b("structures", 10)) {
            return null;
        }
        NBTTagCompound compoundTag = nbt.p("structures");
        if (!compoundTag.b("starts", 10)) {
            return null;
        }
        NBTTagCompound compoundTag2 = compoundTag.p("starts");
        if (compoundTag2.g()) {
            return Object2IntMaps.emptyMap();
        }
        Object2IntOpenHashMap object2IntMap = new Object2IntOpenHashMap();
        IRegistry<Structure> registry = this.d.d(Registries.aR);
        for (String string : compoundTag2.e()) {
            String string2;
            NBTTagCompound compoundTag3;
            Structure structure;
            MinecraftKey resourceLocation = MinecraftKey.c(string);
            if (resourceLocation == null || (structure = registry.a(resourceLocation)) == null || (compoundTag3 = compoundTag2.p(string)).g() || "INVALID".equals(string2 = compoundTag3.l("id"))) continue;
            int i2 = compoundTag3.h("references");
            object2IntMap.put((Object)structure, i2);
        }
        return object2IntMap;
    }

    private static Object2IntMap<Structure> a(Object2IntMap<Structure> map) {
        return map.isEmpty() ? Object2IntMaps.emptyMap() : map;
    }

    private StructureCheckResult a(Object2IntMap<Structure> referencesByStructure, Structure structure, boolean skipReferencedStructures) {
        int i2 = referencesByStructure.getOrDefault((Object)structure, -1);
        return i2 == -1 || skipReferencedStructures && i2 != 0 ? StructureCheckResult.b : StructureCheckResult.a;
    }

    public void a(ChunkCoordIntPair pos, Map<Structure, StructureStart> structureStarts) {
        long l2 = pos.a();
        Object2IntOpenHashMap object2IntMap = new Object2IntOpenHashMap();
        structureStarts.forEach((arg_0, arg_1) -> StructureCheck.a((Object2IntMap)object2IntMap, arg_0, arg_1));
        this.a(l2, (Object2IntMap<Structure>)object2IntMap);
    }

    private void a(long pos, Object2IntMap<Structure> referencesByStructure) {
        this.loadedChunksSafe.put(pos, StructureCheck.a(referencesByStructure));
        for (SynchronisedLong2BooleanMap value : this.featureChecksSafe.values()) {
            value.remove(pos);
        }
    }

    public void a(ChunkCoordIntPair pos, Structure structure) {
        this.loadedChunksSafe.compute(pos.a(), (posx, referencesByStructure) -> {
            if (referencesByStructure == null) {
                referencesByStructure = new Object2IntOpenHashMap();
            } else {
                Object2IntOpenHashMap object2IntOpenHashMap;
                if (referencesByStructure instanceof Object2IntOpenHashMap) {
                    Object2IntOpenHashMap fastClone = (Object2IntOpenHashMap)referencesByStructure;
                    object2IntOpenHashMap = fastClone.clone();
                } else {
                    object2IntOpenHashMap = new Object2IntOpenHashMap(referencesByStructure);
                }
                referencesByStructure = object2IntOpenHashMap;
            }
            referencesByStructure.computeInt((Object)structure, (feature, references) -> references == null ? 1 : references + 1);
            return referencesByStructure;
        });
    }

    private static /* synthetic */ void a(Object2IntMap object2IntMap, Structure start, StructureStart structureStart) {
        if (structureStart.b()) {
            object2IntMap.put((Object)start, structureStart.f());
        }
    }
}

