/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Suppliers;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.QuartPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.BlockColumn;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.BiomeSettingsGeneration;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.Beardifier;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseRouterData;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverWrapper;
import org.apache.commons.lang3.mutable.MutableObject;

public final class ChunkGeneratorAbstract
extends ChunkGenerator {
    public static final MapCodec<ChunkGeneratorAbstract> c = RecordCodecBuilder.mapCodec(instance -> instance.group((App)WorldChunkManager.a.fieldOf("biome_source").forGetter(chunkgeneratorabstract -> chunkgeneratorabstract.b), (App)GeneratorSettingBase.b.fieldOf("settings").forGetter(chunkgeneratorabstract -> chunkgeneratorabstract.e)).apply((Applicative)instance, instance.stable(ChunkGeneratorAbstract::new)));
    private static final IBlockData d = Blocks.a.o();
    public final Holder<GeneratorSettingBase> e;
    private final Supplier<Aquifer.a> f;

    public ChunkGeneratorAbstract(WorldChunkManager biomeSource, Holder<GeneratorSettingBase> settings) {
        super(biomeSource);
        this.e = settings;
        this.f = Suppliers.memoize(() -> ChunkGeneratorAbstract.a((GeneratorSettingBase)settings.a()));
    }

    private static Aquifer.a a(GeneratorSettingBase settings) {
        Aquifer.b aquifer_b = new Aquifer.b(-54, Blocks.H.o());
        int i2 = settings.l();
        Aquifer.b aquifer_b1 = new Aquifer.b(i2, settings.h());
        Aquifer.b aquifer_b2 = new Aquifer.b(DimensionManager.e * 2, Blocks.a.o());
        return (j2, k2, l2) -> k2 < Math.min(-54, i2) ? aquifer_b : aquifer_b1;
    }

    @Override
    public CompletableFuture<IChunkAccess> a(RandomState noiseConfig, Blender blender, StructureManager structureAccessor, IChunkAccess chunk) {
        return CompletableFuture.supplyAsync(SystemUtils.a("init_biomes", () -> {
            this.b(blender, noiseConfig, structureAccessor, chunk);
            return chunk;
        }), Runnable::run);
    }

    private void b(Blender blender, RandomState noiseConfig, StructureManager structureAccessor, IChunkAccess chunk) {
        NoiseChunk noisechunk = chunk.a((IChunkAccess ichunkaccess1) -> this.a((IChunkAccess)ichunkaccess1, structureAccessor, blender, noiseConfig));
        BiomeResolver biomeresolver = BelowZeroRetrogen.a(blender.a(this.b), chunk);
        chunk.a(biomeresolver, noisechunk.a(noiseConfig.a(), this.e.a().k()));
    }

    private NoiseChunk a(IChunkAccess chunk, StructureManager world, Blender blender, RandomState noiseConfig) {
        return NoiseChunk.a(chunk, noiseConfig, Beardifier.a(world, chunk.f()), this.e.a(), this.f.get(), blender);
    }

    @Override
    protected MapCodec<? extends ChunkGenerator> b() {
        return c;
    }

    public Holder<GeneratorSettingBase> h() {
        return this.e;
    }

    public boolean a(ResourceKey<GeneratorSettingBase> settings) {
        return this.e.a(settings);
    }

    @Override
    public int a(int x2, int z2, HeightMap.Type heightmap, LevelHeightAccessor world, RandomState noiseConfig) {
        return this.a(world, noiseConfig, x2, z2, (MutableObject<BlockColumn>)((MutableObject)null), heightmap.e()).orElse(world.I_());
    }

    @Override
    public BlockColumn a(int x2, int z2, LevelHeightAccessor world, RandomState noiseConfig) {
        MutableObject mutableobject = new MutableObject();
        this.a(world, noiseConfig, x2, z2, (MutableObject<BlockColumn>)mutableobject, null);
        return (BlockColumn)mutableobject.getValue();
    }

    @Override
    public void a(List<String> text, RandomState noiseConfig, BlockPosition pos) {
        DecimalFormat decimalformat = new DecimalFormat("0.000");
        NoiseRouter noiserouter = noiseConfig.a();
        DensityFunction.e densityfunction_e = new DensityFunction.e(pos.u(), pos.v(), pos.w());
        double d0 = noiserouter.j().a(densityfunction_e);
        String s2 = decimalformat.format(noiserouter.e().a(densityfunction_e));
        text.add("NoiseRouter T: " + s2 + " V: " + decimalformat.format(noiserouter.f().a(densityfunction_e)) + " C: " + decimalformat.format(noiserouter.g().a(densityfunction_e)) + " E: " + decimalformat.format(noiserouter.h().a(densityfunction_e)) + " D: " + decimalformat.format(noiserouter.i().a(densityfunction_e)) + " W: " + decimalformat.format(d0) + " PV: " + decimalformat.format(NoiseRouterData.a((float)d0)) + " AS: " + decimalformat.format(noiserouter.k().a(densityfunction_e)) + " N: " + decimalformat.format(noiserouter.l().a(densityfunction_e)));
    }

    private OptionalInt a(LevelHeightAccessor world, RandomState noiseConfig, int x2, int z2, @Nullable MutableObject<BlockColumn> columnSample, @Nullable Predicate<IBlockData> stopPredicate) {
        IBlockData[] aiblockdata;
        NoiseSettings noisesettings = this.e.a().f().a(world);
        int k2 = noisesettings.a();
        int l2 = noisesettings.c();
        int i1 = MathHelper.a(l2, k2);
        int j1 = MathHelper.a(noisesettings.d(), k2);
        if (j1 <= 0) {
            return OptionalInt.empty();
        }
        if (columnSample == null) {
            aiblockdata = null;
        } else {
            aiblockdata = new IBlockData[noisesettings.d()];
            columnSample.setValue((Object)new BlockColumn(l2, aiblockdata));
        }
        int k1 = noisesettings.b();
        int l1 = Math.floorDiv(x2, k1);
        int i2 = Math.floorDiv(z2, k1);
        int j2 = Math.floorMod(x2, k1);
        int k22 = Math.floorMod(z2, k1);
        int l22 = l1 * k1;
        int i3 = i2 * k1;
        double d0 = (double)j2 / (double)k1;
        double d1 = (double)k22 / (double)k1;
        NoiseChunk noisechunk = new NoiseChunk(1, noiseConfig, l22, i3, noisesettings, DensityFunctions.b.a, this.e.a(), this.f.get(), Blender.a());
        noisechunk.f();
        noisechunk.b(0);
        for (int j3 = j1 - 1; j3 >= 0; --j3) {
            noisechunk.b(j3, 0);
            for (int k3 = k2 - 1; k3 >= 0; --k3) {
                IBlockData iblockdata1;
                int l3 = (i1 + j3) * k2 + k3;
                double d2 = (double)k3 / (double)k2;
                noisechunk.a(l3, d2);
                noisechunk.b(x2, d0);
                noisechunk.c(z2, d1);
                IBlockData iblockdata = noisechunk.e();
                IBlockData iBlockData = iblockdata1 = iblockdata == null ? this.e.a().g() : iblockdata;
                if (aiblockdata != null) {
                    int i4 = j3 * k2 + k3;
                    aiblockdata[i4] = iblockdata1;
                }
                if (stopPredicate == null || !stopPredicate.test(iblockdata1)) continue;
                noisechunk.g();
                return OptionalInt.of(l3 + 1);
            }
        }
        noisechunk.g();
        return OptionalInt.empty();
    }

    @Override
    public void a(RegionLimitedWorldAccess region, StructureManager structures, RandomState noiseConfig, IChunkAccess chunk) {
        if (!SharedConstants.a(chunk.f())) {
            WorldGenerationContext worldgenerationcontext = new WorldGenerationContext(this, region, region.getMinecraftWorld());
            this.a(chunk, worldgenerationcontext, noiseConfig, structures, region.F_(), region.H_().d(Registries.aF), Blender.a(region));
        }
    }

    @VisibleForTesting
    public void a(IChunkAccess chunk, WorldGenerationContext heightContext, RandomState noiseConfig, StructureManager structureAccessor, BiomeManager biomeAccess, IRegistry<BiomeBase> biomeRegistry, Blender blender) {
        NoiseChunk noisechunk = chunk.a((IChunkAccess ichunkaccess1) -> this.a((IChunkAccess)ichunkaccess1, structureAccessor, blender, noiseConfig));
        GeneratorSettingBase generatorsettingbase = this.e.a();
        noiseConfig.c().a(noiseConfig, biomeAccess, biomeRegistry, generatorsettingbase.n(), heightContext, chunk, noisechunk, generatorsettingbase.j());
    }

    @Override
    public void a(RegionLimitedWorldAccess chunkRegion, long seed, RandomState noiseConfig, BiomeManager biomeAccess, StructureManager structureAccessor, IChunkAccess chunk, WorldGenStage.Features carverStep) {
        BiomeManager biomemanager1 = biomeAccess.a((int j2, int k2, int l2) -> this.b.getNoiseBiome(j2, k2, l2, noiseConfig.b()));
        SeededRandom seededrandom = new SeededRandom(new LegacyRandomSource(RandomSupport.a()));
        boolean flag = true;
        ChunkCoordIntPair chunkcoordintpair = chunk.f();
        NoiseChunk noisechunk = chunk.a((IChunkAccess ichunkaccess1) -> this.a((IChunkAccess)ichunkaccess1, structureAccessor, Blender.a(chunkRegion), noiseConfig));
        Aquifer aquifer = noisechunk.i();
        CarvingContext carvingcontext = new CarvingContext(this, chunkRegion.H_(), chunk.z(), noisechunk, noiseConfig, this.e.a().j(), chunkRegion.getMinecraftWorld());
        CarvingMask carvingmask = ((ProtoChunk)chunk).b(carverStep);
        for (int j3 = -8; j3 <= 8; ++j3) {
            for (int k3 = -8; k3 <= 8; ++k3) {
                ChunkCoordIntPair chunkcoordintpair1 = new ChunkCoordIntPair(chunkcoordintpair.e + j3, chunkcoordintpair.f + k3);
                IChunkAccess ichunkaccess12 = chunkRegion.a(chunkcoordintpair1.e, chunkcoordintpair1.f);
                BiomeSettingsGeneration biomesettingsgeneration = ichunkaccess12.a(() -> this.a(this.b.getNoiseBiome(QuartPos.a(chunkcoordintpair1.d()), 0, QuartPos.a(chunkcoordintpair1.e()), noiseConfig.b())));
                Iterable<Holder<WorldGenCarverWrapper<?>>> iterable = biomesettingsgeneration.a(carverStep);
                int l3 = 0;
                for (Holder<WorldGenCarverWrapper<?>> holder : iterable) {
                    WorldGenCarverWrapper<?> worldgencarverwrapper = holder.a();
                    seededrandom.c(seed + (long)l3, chunkcoordintpair1.e, chunkcoordintpair1.f);
                    if (worldgencarverwrapper.a(seededrandom)) {
                        Objects.requireNonNull(biomemanager1);
                        worldgencarverwrapper.a(carvingcontext, chunk, biomemanager1::a, seededrandom, aquifer, chunkcoordintpair1, carvingmask);
                    }
                    ++l3;
                }
            }
        }
    }

    @Override
    public CompletableFuture<IChunkAccess> a(Blender blender, RandomState noiseConfig, StructureManager structureAccessor, IChunkAccess chunk) {
        NoiseSettings noisesettings = this.e.a().f().a(chunk.z());
        int i2 = noisesettings.c();
        int j2 = MathHelper.a(i2, noisesettings.a());
        int k2 = MathHelper.a(noisesettings.d(), noisesettings.a());
        return k2 <= 0 ? CompletableFuture.completedFuture(chunk) : CompletableFuture.supplyAsync(SystemUtils.a("wgen_fill_noise", () -> {
            IChunkAccess ichunkaccess1;
            int l2 = chunk.e(k2 * noisesettings.a() - 1 + i2);
            int i1 = chunk.e(i2);
            HashSet set = Sets.newHashSet();
            for (int j1 = l2; j1 >= i1; --j1) {
                ChunkSection chunksection = chunk.b(j1);
                chunksection.a();
                set.add(chunksection);
            }
            boolean flag = false;
            try {
                flag = true;
                ichunkaccess1 = this.a(blender, structureAccessor, noiseConfig, chunk, j2, k2);
                flag = false;
            }
            finally {
                if (flag) {
                    for (ChunkSection chunksection1 : set) {
                        chunksection1.b();
                    }
                }
            }
            for (ChunkSection chunksection2 : set) {
                chunksection2.b();
            }
            return ichunkaccess1;
        }), Runnable::run);
    }

    private IChunkAccess a(Blender blender, StructureManager structureAccessor, RandomState noiseConfig, IChunkAccess chunk, int minimumCellY, int cellHeight) {
        NoiseChunk noisechunk = chunk.a((IChunkAccess ichunkaccess1) -> this.a((IChunkAccess)ichunkaccess1, structureAccessor, blender, noiseConfig));
        HeightMap heightmap = chunk.a(HeightMap.Type.c);
        HeightMap heightmap1 = chunk.a(HeightMap.Type.a);
        ChunkCoordIntPair chunkcoordintpair = chunk.f();
        int k2 = chunkcoordintpair.d();
        int l2 = chunkcoordintpair.e();
        Aquifer aquifer = noisechunk.i();
        noisechunk.f();
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        int i1 = noisechunk.j();
        int j1 = noisechunk.k();
        int k1 = 16 / i1;
        int l1 = 16 / i1;
        for (int i2 = 0; i2 < k1; ++i2) {
            noisechunk.b(i2);
            for (int j2 = 0; j2 < l1; ++j2) {
                int k22 = chunk.an() - 1;
                ChunkSection chunksection = chunk.b(k22);
                for (int l22 = cellHeight - 1; l22 >= 0; --l22) {
                    noisechunk.b(l22, j2);
                    for (int i3 = j1 - 1; i3 >= 0; --i3) {
                        int j3 = (minimumCellY + l22) * j1 + i3;
                        int k3 = j3 & 0xF;
                        int l3 = chunk.e(j3);
                        if (k22 != l3) {
                            k22 = l3;
                            chunksection = chunk.b(l3);
                        }
                        double d0 = (double)i3 / (double)j1;
                        noisechunk.a(j3, d0);
                        for (int i4 = 0; i4 < i1; ++i4) {
                            int j4 = k2 + i2 * i1 + i4;
                            int k4 = j4 & 0xF;
                            double d1 = (double)i4 / (double)i1;
                            noisechunk.b(j4, d1);
                            for (int l4 = 0; l4 < i1; ++l4) {
                                int i5 = l2 + j2 * i1 + l4;
                                int j5 = i5 & 0xF;
                                double d2 = (double)l4 / (double)i1;
                                noisechunk.c(i5, d2);
                                IBlockData iblockdata = noisechunk.e();
                                if (iblockdata == null) {
                                    iblockdata = this.e.a().g();
                                }
                                if ((iblockdata = this.a(noisechunk, j4, j3, i5, iblockdata)) == d || SharedConstants.a(chunk.f())) continue;
                                chunksection.a(k4, k3, j5, iblockdata, false);
                                heightmap.a(k4, j3, j5, iblockdata);
                                heightmap1.a(k4, j3, j5, iblockdata);
                                if (!aquifer.a() || iblockdata.u().c()) continue;
                                blockposition_mutableblockposition.d(j4, j3, i5);
                                chunk.e(blockposition_mutableblockposition);
                            }
                        }
                    }
                }
            }
            noisechunk.h();
        }
        noisechunk.g();
        return chunk;
    }

    private IBlockData a(NoiseChunk chunkNoiseSampler, int x2, int y2, int z2, IBlockData state) {
        return state;
    }

    @Override
    public int e() {
        return this.e.a().f().d();
    }

    @Override
    public int f() {
        return this.e.a().l();
    }

    @Override
    public int g() {
        return this.e.a().f().c();
    }

    @Override
    public void a(RegionLimitedWorldAccess region) {
        if (!this.e.a().a()) {
            ChunkCoordIntPair chunkcoordintpair = region.a();
            Holder<BiomeBase> holder = region.t(chunkcoordintpair.l().h(region.am() - 1));
            SeededRandom seededrandom = new SeededRandom(new LegacyRandomSource(RandomSupport.a()));
            seededrandom.a(region.C(), chunkcoordintpair.d(), chunkcoordintpair.e());
            SpawnerCreature.a(region, holder, chunkcoordintpair, seededrandom);
        }
    }
}

