/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import ca.spottedleaf.moonrise.patches.chunk_system.level.storage.ChunkSystemSectionStorage;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.storage.ChunkIOErrorReporter;
import net.minecraft.world.level.chunk.storage.RegionFileCache;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;
import org.slf4j.Logger;

public abstract class RegionFileSection<R>
implements AutoCloseable,
ChunkSystemSectionStorage {
    private static final Logger a = LogUtils.getLogger();
    private static final String b = "Sections";
    private final Long2ObjectMap<Optional<R>> e = new Long2ObjectOpenHashMap();
    private final LongLinkedOpenHashSet f = new LongLinkedOpenHashSet();
    private final Function<Runnable, Codec<R>> g;
    private final Function<Runnable, R> h;
    private final IRegistryCustom i;
    private final ChunkIOErrorReporter j;
    protected final LevelHeightAccessor c;
    private final RegionFileCache regionStorage;

    @Override
    public final RegionFileCache moonrise$getRegionStorage() {
        return this.regionStorage;
    }

    public RegionFileSection(SimpleRegionStorage storageAccess, Function<Runnable, Codec<R>> codecFactory, Function<Runnable, R> factory, IRegistryCustom registryManager, ChunkIOErrorReporter errorHandler, LevelHeightAccessor world) {
        this.g = codecFactory;
        this.h = factory;
        this.i = registryManager;
        this.j = errorHandler;
        this.c = world;
        this.regionStorage = storageAccess.a.d;
    }

    protected void a(BooleanSupplier shouldKeepTicking) {
        while (this.a() && shouldKeepTicking.getAsBoolean()) {
            ChunkCoordIntPair chunkPos = SectionPosition.a(this.f.firstLong()).r();
            this.d(chunkPos);
        }
    }

    public boolean a() {
        return !this.f.isEmpty();
    }

    @Nullable
    protected Optional<R> c(long pos) {
        return (Optional)this.e.get(pos);
    }

    protected Optional<R> d(long pos) {
        if (this.e(pos)) {
            return Optional.empty();
        }
        Optional<R> optional = this.c(pos);
        if (optional != null) {
            return optional;
        }
        this.b(SectionPosition.a(pos).r());
        optional = this.c(pos);
        if (optional == null) {
            throw SystemUtils.b(new IllegalStateException());
        }
        return optional;
    }

    protected boolean e(long pos) {
        int i2 = SectionPosition.c(SectionPosition.c(pos));
        return this.c.d(i2);
    }

    protected R f(long pos) {
        if (this.e(pos)) {
            throw SystemUtils.b(new IllegalArgumentException("sectionPos out of bounds"));
        }
        Optional<R> optional = this.d(pos);
        if (optional.isPresent()) {
            return optional.get();
        }
        R object = this.h.apply(() -> this.a(pos));
        this.e.put(pos, Optional.of(object));
        return object;
    }

    private void b(ChunkCoordIntPair pos) {
        Optional<NBTTagCompound> optional = this.c(pos).join();
        RegistryOps<NBTBase> registryOps = this.i.a(DynamicOpsNBT.a);
        this.a(pos, registryOps, optional.orElse(null));
    }

    private CompletableFuture<Optional<NBTTagCompound>> c(ChunkCoordIntPair pos) {
        try {
            return CompletableFuture.completedFuture(Optional.ofNullable(this.moonrise$read(pos.e, pos.f)));
        }
        catch (Throwable thr) {
            return CompletableFuture.failedFuture(thr);
        }
    }

    private void a(ChunkCoordIntPair pos, RegistryOps<NBTBase> ops, @Nullable NBTTagCompound nbt) {
        throw new IllegalStateException("Only chunk system can load in state, offending class:" + this.getClass().getName());
    }

    private void d(ChunkCoordIntPair pos) {
        RegistryOps<NBTBase> registryOps = this.i.a(DynamicOpsNBT.a);
        Dynamic<NBTBase> dynamic = this.a(pos, registryOps);
        NBTBase tag = dynamic.getValue();
        if (tag instanceof NBTTagCompound) {
            try {
                this.moonrise$write(pos.e, pos.f, (NBTTagCompound)tag);
            }
            catch (IOException ex) {
                a.error("Error writing poi chunk data to disk for chunk " + String.valueOf(pos), (Throwable)ex);
            }
        } else {
            a.error("Expected compound tag, got {}", (Object)tag);
        }
    }

    private <T> Dynamic<T> a(ChunkCoordIntPair chunkPos, DynamicOps<T> ops) {
        HashMap map = Maps.newHashMap();
        for (int i2 = this.c.ao(); i2 < this.c.ap(); ++i2) {
            long l2 = RegionFileSection.a(chunkPos, i2);
            this.f.remove(l2);
            Optional optional = (Optional)this.e.get(l2);
            if (optional == null || optional.isEmpty()) continue;
            DataResult dataResult = this.g.apply(() -> this.a(l2)).encodeStart(ops, optional.get());
            String string = Integer.toString(i2);
            dataResult.resultOrPartial(arg_0 -> ((Logger)a).error(arg_0)).ifPresent(object -> map.put(ops.createString(string), object));
        }
        return new Dynamic<Object>(ops, ops.createMap((Map)ImmutableMap.of((Object)ops.createString(b), (Object)ops.createMap((Map)map), (Object)ops.createString("DataVersion"), (Object)ops.createInt(SharedConstants.b().d().c()))));
    }

    private static long a(ChunkCoordIntPair chunkPos, int y2) {
        return SectionPosition.b(chunkPos.e, y2, chunkPos.f);
    }

    protected void b(long pos) {
    }

    public void a(long pos) {
        Optional optional = (Optional)this.e.get(pos);
        if (optional != null && !optional.isEmpty()) {
            this.f.add(pos);
        } else {
            a.warn("No data for position: {}", (Object)SectionPosition.a(pos));
        }
    }

    private static int a(Dynamic<?> dynamic) {
        return dynamic.get("DataVersion").asInt(1945);
    }

    public void a(ChunkCoordIntPair pos) {
        if (this.a()) {
            for (int i2 = this.c.ao(); i2 < this.c.ap(); ++i2) {
                long l2 = RegionFileSection.a(pos, i2);
                if (!this.f.contains(l2)) continue;
                this.d(pos);
                return;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.moonrise$close();
    }
}

