/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.destroystokyo.paper.exception.ServerInternalException;
import com.destroystokyo.paper.util.SneakyThrow;
import com.google.common.annotations.VisibleForTesting;
import com.mojang.logging.LogUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.InflaterInputStream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.storage.RegionFileBitSet;
import net.minecraft.world.level.chunk.storage.RegionFileCache;
import net.minecraft.world.level.chunk.storage.RegionFileCompression;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import org.slf4j.Logger;

public class RegionFile
implements AutoCloseable {
    private static final Logger c = LogUtils.getLogger();
    private static final int d = 4096;
    @VisibleForTesting
    protected static final int a = 1024;
    private static final int e = 5;
    private static final int f = 0;
    private static final ByteBuffer g = ByteBuffer.allocateDirect(1);
    private static final String h = ".mcc";
    private static final int i = 128;
    private static final int j = 256;
    private static final int k = 0;
    final RegionStorageInfo l;
    private final Path m;
    private final FileChannel n;
    private final Path o;
    final RegionFileCompression p;
    private final ByteBuffer q;
    private final IntBuffer r;
    private final IntBuffer s;
    @VisibleForTesting
    protected final RegionFileBitSet b;
    public static final int MAX_CHUNK_SIZE = 524288000;
    private final byte[] oversized = new byte[1024];
    private int oversizedCount;

    public RegionFile(RegionStorageInfo storageKey, Path directory, Path path, boolean dsync) throws IOException {
        this(storageKey, directory, path, RegionFileCompression.getCompressionFormat(), dsync);
    }

    public RegionFile(RegionStorageInfo storageKey, Path path, Path directory, RegionFileCompression compressionFormat, boolean dsync) throws IOException {
        this.q = ByteBuffer.allocateDirect(8192);
        this.b = new RegionFileBitSet();
        this.l = storageKey;
        this.m = path;
        this.initOversizedState();
        this.p = compressionFormat;
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            throw new IllegalArgumentException("Expected directory, got " + String.valueOf(directory.toAbsolutePath()));
        }
        this.o = directory;
        this.r = this.q.asIntBuffer();
        ((Buffer)this.r).limit(1024);
        ((Buffer)this.q).position(4096);
        this.s = this.q.asIntBuffer();
        this.n = dsync ? FileChannel.open(path, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.DSYNC) : FileChannel.open(path, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
        this.b.a(0, 2);
        ((Buffer)this.q).position(0);
        int i2 = this.n.read(this.q, 0L);
        if (i2 != -1) {
            if (i2 != 8192) {
                c.warn("Region file {} has truncated header: {}", (Object)path, (Object)i2);
            }
            long j2 = Files.size(path);
            for (int k2 = 0; k2 < 1024; ++k2) {
                int l2 = this.r.get(k2);
                if (l2 == 0) continue;
                int i1 = RegionFile.b(l2);
                int j1 = RegionFile.a(l2);
                if (j1 == 255) {
                    ByteBuffer realLen = ByteBuffer.allocate(4);
                    this.n.read(realLen, i1 * 4096);
                    j1 = (realLen.getInt(0) + 4) / 4096 + 1;
                }
                if (i1 < 2) {
                    c.warn("Region file {} has invalid sector at index: {}; sector {} overlaps with header", new Object[]{path, k2, i1});
                    this.r.put(k2, 0);
                    continue;
                }
                if (j1 == 0) {
                    c.warn("Region file {} has an invalid sector at index: {}; size has to be > 0", (Object)path, (Object)k2);
                    this.r.put(k2, 0);
                    continue;
                }
                if ((long)i1 * 4096L > j2) {
                    c.warn("Region file {} has an invalid sector at index: {}; sector {} is out of bounds", new Object[]{path, k2, i1});
                    this.r.put(k2, 0);
                    continue;
                }
                this.b.a(i1, j1);
            }
        }
    }

    public Path a() {
        return this.m;
    }

    private Path f(ChunkCoordIntPair chunkPos) {
        String s2 = "c." + chunkPos.e + "." + chunkPos.f + h;
        return this.o.resolve(s2);
    }

    @Nullable
    public synchronized DataInputStream a(ChunkCoordIntPair pos) throws IOException {
        int i2 = this.g(pos);
        if (i2 == 0) {
            return null;
        }
        int j2 = RegionFile.b(i2);
        int k2 = RegionFile.a(i2);
        if (k2 == 255) {
            ByteBuffer realLen = ByteBuffer.allocate(4);
            this.n.read(realLen, j2 * 4096);
            k2 = (realLen.getInt(0) + 4) / 4096 + 1;
        }
        int l2 = k2 * 4096;
        ByteBuffer bytebuffer = ByteBuffer.allocate(l2);
        this.n.read(bytebuffer, j2 * 4096);
        ((Buffer)bytebuffer).flip();
        if (bytebuffer.remaining() < 5) {
            c.error("Chunk {} header is truncated: expected {} but read {}", new Object[]{pos, l2, bytebuffer.remaining()});
            return null;
        }
        int i1 = bytebuffer.getInt();
        byte b0 = bytebuffer.get();
        if (i1 == 0) {
            c.warn("Chunk {} is allocated, but stream is missing", (Object)pos);
            return null;
        }
        int j1 = i1 - 1;
        if (RegionFile.a(b0)) {
            if (j1 != 0) {
                c.warn("Chunk has both internal and external streams");
            }
            return this.a(pos, RegionFile.b(b0));
        }
        if (j1 > bytebuffer.remaining()) {
            c.error("Chunk {} stream is truncated: expected {} but read {}", new Object[]{pos, j1, bytebuffer.remaining()});
            return null;
        }
        if (j1 < 0) {
            c.error("Declared size {} of chunk {} is negative", (Object)i1, (Object)pos);
            return null;
        }
        JvmProfiler.f.a(this.l, pos, this.p, j1);
        return this.a(pos, b0, RegionFile.a(bytebuffer, j1));
    }

    private static int c() {
        return (int)(SystemUtils.e() / 1000L);
    }

    private static boolean a(byte flags) {
        return (flags & 0x80) != 0;
    }

    private static byte b(byte flags) {
        return (byte)(flags & 0xFFFFFF7F);
    }

    @Nullable
    private DataInputStream a(ChunkCoordIntPair pos, byte flags, InputStream stream) throws IOException {
        RegionFileCompression regionfilecompression = RegionFileCompression.a(flags);
        if (regionfilecompression == RegionFileCompression.e) {
            String s2 = new DataInputStream(stream).readUTF();
            MinecraftKey minecraftkey = MinecraftKey.c(s2);
            if (minecraftkey != null) {
                c.error("Unrecognized custom compression {}", (Object)minecraftkey);
                return null;
            }
            c.error("Invalid custom compression id {}", (Object)s2);
            return null;
        }
        if (regionfilecompression == null) {
            c.error("Chunk {} has invalid chunk stream version {}", (Object)pos, (Object)flags);
            return null;
        }
        return new DataInputStream(regionfilecompression.a(stream));
    }

    @Nullable
    private DataInputStream a(ChunkCoordIntPair pos, byte flags) throws IOException {
        Path path = this.f(pos);
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            c.error("External chunk path {} is not file", (Object)path);
            return null;
        }
        return this.a(pos, flags, Files.newInputStream(path, new OpenOption[0]));
    }

    private static ByteArrayInputStream a(ByteBuffer buffer, int length) {
        return new ByteArrayInputStream(buffer.array(), buffer.position(), length);
    }

    private int a(int offset, int size) {
        return offset << 8 | size;
    }

    private static int a(int sectorData) {
        return sectorData & 0xFF;
    }

    private static int b(int sectorData) {
        return sectorData >> 8 & 0xFFFFFF;
    }

    private static int c(int byteCount) {
        return (byteCount + 4096 - 1) / 4096;
    }

    public boolean b(ChunkCoordIntPair pos) {
        int i2 = this.g(pos);
        if (i2 == 0) {
            return false;
        }
        int j2 = RegionFile.b(i2);
        int k2 = RegionFile.a(i2);
        ByteBuffer bytebuffer = ByteBuffer.allocate(5);
        try {
            this.n.read(bytebuffer, j2 * 4096);
            ((Buffer)bytebuffer).flip();
            if (bytebuffer.remaining() != 5) {
                return false;
            }
            int l2 = bytebuffer.getInt();
            byte b0 = bytebuffer.get();
            if (RegionFile.a(b0)) {
                if (!RegionFileCompression.b(RegionFile.b(b0))) {
                    return false;
                }
                if (!Files.isRegularFile(this.f(pos), new LinkOption[0])) {
                    return false;
                }
            } else {
                if (!RegionFileCompression.b(b0)) {
                    return false;
                }
                if (l2 == 0) {
                    return false;
                }
                int i1 = l2 - 1;
                if (i1 < 0 || i1 > 4096 * k2) {
                    return false;
                }
            }
            return true;
        }
        catch (IOException ioexception) {
            SneakyThrow.sneaky((Throwable)ioexception);
            return false;
        }
    }

    public DataOutputStream c(ChunkCoordIntPair pos) throws IOException {
        return new DataOutputStream(this.p.a(new ChunkBuffer(pos)));
    }

    public void b() throws IOException {
        this.n.force(true);
    }

    public void d(ChunkCoordIntPair pos) throws IOException {
        int i2 = RegionFile.h(pos);
        int j2 = this.r.get(i2);
        if (j2 != 0) {
            this.r.put(i2, 0);
            this.s.put(i2, RegionFile.c());
            this.e();
            Files.deleteIfExists(this.f(pos));
            this.b.b(RegionFile.b(j2), RegionFile.a(j2));
        }
    }

    protected synchronized void a(ChunkCoordIntPair pos, ByteBuffer buf) throws IOException {
        b regionfile_b;
        int k1;
        int i2 = RegionFile.h(pos);
        int j2 = this.r.get(i2);
        int k2 = RegionFile.b(j2);
        int l2 = RegionFile.a(j2);
        int i1 = buf.remaining();
        int j1 = RegionFile.c(i1);
        if (j1 >= 256) {
            Path path = this.f(pos);
            c.warn("Saving oversized chunk {} ({} bytes} to external file {}", new Object[]{pos, i1, path});
            j1 = 1;
            k1 = this.b.a(j1);
            regionfile_b = this.a(path, buf);
            ByteBuffer bytebuffer1 = this.d();
            this.n.write(bytebuffer1, k1 * 4096);
        } else {
            k1 = this.b.a(j1);
            regionfile_b = () -> Files.deleteIfExists(this.f(pos));
            this.n.write(buf, k1 * 4096);
        }
        this.r.put(i2, this.a(k1, j1));
        this.s.put(i2, RegionFile.c());
        this.e();
        regionfile_b.run();
        if (k2 != 0) {
            this.b.b(k2, l2);
        }
    }

    private ByteBuffer d() {
        ByteBuffer bytebuffer = ByteBuffer.allocate(5);
        bytebuffer.putInt(1);
        bytebuffer.put((byte)(this.p.b() | 0x80));
        ((Buffer)bytebuffer).flip();
        return bytebuffer;
    }

    private b a(Path path, ByteBuffer buf) throws IOException {
        Path path1 = Files.createTempFile(this.o, "tmp", (String)null, new FileAttribute[0]);
        FileChannel filechannel = FileChannel.open(path1, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        try {
            ((Buffer)buf).position(5);
            filechannel.write(buf);
        }
        catch (Throwable throwable) {
            ServerInternalException.reportInternalException((Throwable)throwable);
            if (filechannel != null) {
                try {
                    filechannel.close();
                }
                catch (Throwable throwable1) {
                    throwable.addSuppressed(throwable1);
                }
            }
            throw throwable;
        }
        if (filechannel != null) {
            filechannel.close();
        }
        return () -> Files.move(path1, path, StandardCopyOption.REPLACE_EXISTING);
    }

    private void e() throws IOException {
        ((Buffer)this.q).position(0);
        this.n.write(this.q, 0L);
    }

    private int g(ChunkCoordIntPair pos) {
        return this.r.get(RegionFile.h(pos));
    }

    public boolean e(ChunkCoordIntPair pos) {
        return this.g(pos) != 0;
    }

    private static int h(ChunkCoordIntPair pos) {
        return pos.j() + pos.k() * 32;
    }

    @Override
    public void close() throws IOException {
        try {
            this.f();
        }
        finally {
            try {
                this.n.force(true);
            }
            finally {
                this.n.close();
            }
        }
    }

    private void f() throws IOException {
        int j2;
        int i2 = (int)this.n.size();
        if (i2 != (j2 = RegionFile.c(i2) * 4096)) {
            ByteBuffer bytebuffer = g.duplicate();
            ((Buffer)bytebuffer).position(0);
            this.n.write(bytebuffer, j2 - 1);
        }
    }

    private synchronized void initOversizedState() throws IOException {
        Path metaFile = this.getOversizedMetaFile();
        if (Files.exists(metaFile, new LinkOption[0])) {
            byte[] read = Files.readAllBytes(metaFile);
            System.arraycopy(read, 0, this.oversized, 0, this.oversized.length);
            for (byte temp : this.oversized) {
                this.oversizedCount += temp;
            }
        }
    }

    private static int getChunkIndex(int x2, int z2) {
        return (x2 & 0x1F) + (z2 & 0x1F) * 32;
    }

    synchronized boolean isOversized(int x2, int z2) {
        return this.oversized[RegionFile.getChunkIndex(x2, z2)] == 1;
    }

    synchronized void setOversized(int x2, int z2, boolean oversized) throws IOException {
        Path oversizedMetaFile;
        Path oversizedFile;
        int offset = RegionFile.getChunkIndex(x2, z2);
        boolean previous = this.oversized[offset] == 1;
        this.oversized[offset] = (byte)(oversized ? 1 : 0);
        if (!previous && oversized) {
            ++this.oversizedCount;
        } else if (!oversized && previous) {
            --this.oversizedCount;
        }
        if (previous && !oversized && Files.exists(oversizedFile = this.getOversizedFile(x2, z2), new LinkOption[0])) {
            Files.delete(oversizedFile);
        }
        if (this.oversizedCount > 0) {
            if (previous != oversized) {
                this.writeOversizedMeta();
            }
        } else if (previous && Files.exists(oversizedMetaFile = this.getOversizedMetaFile(), new LinkOption[0])) {
            Files.delete(oversizedMetaFile);
        }
    }

    private void writeOversizedMeta() throws IOException {
        Files.write(this.getOversizedMetaFile(), this.oversized, new OpenOption[0]);
    }

    private Path getOversizedMetaFile() {
        return this.m.getParent().resolve(this.m.getFileName().toString().replaceAll("\\.mca$", "") + ".oversized.nbt");
    }

    private Path getOversizedFile(int x2, int z2) {
        return this.m.getParent().resolve(this.m.getFileName().toString().replaceAll("\\.mca$", "") + "_oversized_" + x2 + "_" + z2 + ".nbt");
    }

    synchronized NBTTagCompound getOversizedData(int x2, int z2) throws IOException {
        Path file = this.getOversizedFile(x2, z2);
        try (DataInputStream out = new DataInputStream(new BufferedInputStream(new InflaterInputStream(Files.newInputStream(file, new OpenOption[0]))));){
            NBTTagCompound nBTTagCompound = NBTCompressedStreamTools.a(out);
            return nBTTagCompound;
        }
    }

    private class ChunkBuffer
    extends ByteArrayOutputStream {
        private final ChunkCoordIntPair b;

        public ChunkBuffer(ChunkCoordIntPair chunkcoordintpair) {
            super(8096);
            super.write(0);
            super.write(0);
            super.write(0);
            super.write(0);
            super.write(RegionFile.this.p.b());
            this.b = chunkcoordintpair;
        }

        @Override
        public void write(int b2) {
            if (this.count > 524288000) {
                throw new RegionFileCache.RegionFileSizeException("Region file too large: " + this.count);
            }
            super.write(b2);
        }

        @Override
        public void write(byte[] b2, int off, int len) {
            if (this.count + len > 524288000) {
                throw new RegionFileCache.RegionFileSizeException("Region file too large: " + (this.count + len));
            }
            super.write(b2, off, len);
        }

        @Override
        public void close() throws IOException {
            ByteBuffer bytebuffer = ByteBuffer.wrap(this.buf, 0, this.count);
            int i2 = this.count - 5 + 1;
            JvmProfiler.f.b(RegionFile.this.l, this.b, RegionFile.this.p, i2);
            bytebuffer.putInt(0, i2);
            RegionFile.this.a(this.b, bytebuffer);
        }
    }

    private static interface b {
        public void run() throws IOException;
    }
}

