/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.vault;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.VaultBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.entity.vault.VaultClientData;
import net.minecraft.world.level.block.entity.vault.VaultConfig;
import net.minecraft.world.level.block.entity.vault.VaultServerData;
import net.minecraft.world.level.block.entity.vault.VaultSharedData;
import net.minecraft.world.level.block.entity.vault.VaultState;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.Vec3D;
import org.slf4j.Logger;

public class VaultBlockEntity
extends TileEntity {
    private static final Logger a = LogUtils.getLogger();
    private final VaultServerData b = new VaultServerData();
    private final VaultSharedData c = new VaultSharedData();
    private final VaultClientData d = new VaultClientData();
    private VaultConfig e = VaultConfig.b;

    public VaultBlockEntity(BlockPosition pos, IBlockData state) {
        super(TileEntityTypes.R, pos, state);
    }

    @Override
    @Nullable
    @Override
    public Packet<PacketListenerPlayOut> az_() {
        return PacketPlayOutTileEntityData.a(this);
    }

    @Override
    @Override
    public NBTTagCompound a(HolderLookup.a registryLookup) {
        return SystemUtils.a(new NBTTagCompound(), (? super T nbt) -> nbt.a("shared_data", VaultBlockEntity.a(VaultSharedData.b, this.c, registryLookup)));
    }

    @Override
    @Override
    protected void b(NBTTagCompound nbt, HolderLookup.a registryLookup) {
        super.b(nbt, registryLookup);
        nbt.a("config", VaultBlockEntity.a(VaultConfig.c, this.e, registryLookup));
        nbt.a("shared_data", VaultBlockEntity.a(VaultSharedData.b, this.c, registryLookup));
        nbt.a("server_data", VaultBlockEntity.a(VaultServerData.b, this.b, registryLookup));
    }

    private static <T> NBTBase a(Codec<T> codec, T value, HolderLookup.a registries) {
        return (NBTBase)codec.encodeStart(registries.a(DynamicOpsNBT.a), value).getOrThrow();
    }

    @Override
    @Override
    protected void a(NBTTagCompound nbt, HolderLookup.a registryLookup) {
        super.a(nbt, registryLookup);
        RegistryOps<NBTBase> dynamicOps = registryLookup.a(DynamicOpsNBT.a);
        if (nbt.e("server_data")) {
            VaultServerData.b.parse(dynamicOps, (Object)nbt.c("server_data")).resultOrPartial(arg_0 -> ((Logger)a).error(arg_0)).ifPresent(this.b::a);
        }
        if (nbt.e("config")) {
            VaultConfig.c.parse(dynamicOps, (Object)nbt.c("config")).resultOrPartial(arg_0 -> ((Logger)a).error(arg_0)).ifPresent(config -> {
                this.e = config;
            });
        }
        if (nbt.e("shared_data")) {
            VaultSharedData.b.parse(dynamicOps, (Object)nbt.c("shared_data")).resultOrPartial(arg_0 -> ((Logger)a).error(arg_0)).ifPresent(this.c::a);
        }
    }

    @Nullable
    public VaultServerData b() {
        return this.n == null || this.n.B ? null : this.b;
    }

    public VaultSharedData c() {
        return this.c;
    }

    public VaultClientData d() {
        return this.d;
    }

    public VaultConfig f() {
        return this.e;
    }

    @VisibleForTesting
    public void a(VaultConfig config) {
        this.e = config;
    }

    public static final class a {
        private static final int a = 20;
        private static final float b = 0.5f;
        private static final float c = 0.02f;
        private static final int d = 20;
        private static final int e = 20;

        public static void a(World world, BlockPosition pos, IBlockData state, VaultClientData clientData, VaultSharedData sharedData) {
            clientData.c();
            if (world.Z() % 20L == 0L) {
                net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.a(world, pos, state, sharedData);
            }
            net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.a(world, pos, sharedData, state.c(VaultBlock.d) != false ? Particles.L : Particles.aJ);
            net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.a(world, pos, sharedData);
        }

        public static void a(World world, BlockPosition pos, IBlockData state, VaultSharedData sharedData, ParticleParam particle) {
            net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.a(world, pos, state, sharedData);
            RandomSource randomSource = world.z;
            for (int i2 = 0; i2 < 20; ++i2) {
                Vec3D vec3 = net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.b(pos, randomSource);
                world.a(Particles.ae, vec3.a(), vec3.b(), vec3.c(), 0.0, 0.0, 0.0);
                world.a(particle, vec3.a(), vec3.b(), vec3.c(), 0.0, 0.0, 0.0);
            }
        }

        public static void a(World world, BlockPosition pos, ParticleParam particle) {
            RandomSource randomSource = world.z;
            for (int i2 = 0; i2 < 20; ++i2) {
                Vec3D vec3 = net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.a(pos, randomSource);
                Vec3D vec32 = new Vec3D(randomSource.k() * 0.02, randomSource.k() * 0.02, randomSource.k() * 0.02);
                world.a(particle, vec3.a(), vec3.b(), vec3.c(), vec32.a(), vec32.b(), vec32.c());
            }
        }

        private static void a(World world, BlockPosition pos, VaultSharedData sharedData, ParticleParam particle) {
            RandomSource randomSource = world.E_();
            if (randomSource.i() <= 0.5f) {
                Vec3D vec3 = net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.b(pos, randomSource);
                world.a(Particles.ae, vec3.a(), vec3.b(), vec3.c(), 0.0, 0.0, 0.0);
                if (net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.a(sharedData)) {
                    world.a(particle, vec3.a(), vec3.b(), vec3.c(), 0.0, 0.0, 0.0);
                }
            }
        }

        private static void a(World world, Vec3D pos, EntityHuman player) {
            RandomSource randomSource = world.z;
            Vec3D vec3 = pos.a(player.dm().b(0.0, player.dk() / 2.0f, 0.0));
            int i2 = MathHelper.a(randomSource, 2, 5);
            for (int j2 = 0; j2 < i2; ++j2) {
                Vec3D vec32 = vec3.a(randomSource, 1.0f);
                world.a(Particles.ba, pos.a(), pos.b(), pos.c(), vec32.a(), vec32.b(), vec32.c());
            }
        }

        private static void a(World world, BlockPosition pos, IBlockData state, VaultSharedData sharedData) {
            Set<UUID> set = sharedData.d();
            if (set.isEmpty()) {
                return;
            }
            Vec3D vec3 = net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.a(pos, state.c(VaultBlock.c));
            for (UUID uUID : set) {
                EntityHuman player = world.b(uUID);
                if (player == null || !net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.a(pos, sharedData, player)) continue;
                net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.a(world, vec3, player);
            }
        }

        private static boolean a(BlockPosition pos, VaultSharedData sharedData, EntityHuman player) {
            return player.do().j(pos) <= MathHelper.k(sharedData.e());
        }

        private static void a(World world, BlockPosition pos, VaultSharedData sharedData) {
            if (!net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.a(sharedData)) {
                return;
            }
            RandomSource randomSource = world.E_();
            if (randomSource.i() <= 0.02f) {
                world.a(pos, SoundEffects.AB, SoundCategory.e, randomSource.i() * 0.25f + 0.75f, randomSource.i() + 0.5f, false);
            }
        }

        public static boolean a(VaultSharedData sharedData) {
            return sharedData.b();
        }

        private static Vec3D a(BlockPosition pos, RandomSource random) {
            return Vec3D.a(pos).b(MathHelper.a(random, 0.4, 0.6), MathHelper.a(random, 0.4, 0.6), MathHelper.a(random, 0.4, 0.6));
        }

        private static Vec3D b(BlockPosition pos, RandomSource random) {
            return Vec3D.a(pos).b(MathHelper.a(random, 0.1, 0.9), MathHelper.a(random, 0.25, 0.75), MathHelper.a(random, 0.1, 0.9));
        }

        private static Vec3D a(BlockPosition pos, EnumDirection direction) {
            return Vec3D.c(pos).b((double)direction.j() * 0.5, 1.75, (double)direction.l() * 0.5);
        }
    }

    public static final class b {
        private static final int a = 14;
        private static final int b = 20;
        private static final int c = 15;

        public static void a(WorldServer world, BlockPosition pos, IBlockData state, VaultConfig config, VaultServerData serverData, VaultSharedData sharedData) {
            VaultState vaultState = state.c(VaultBlock.b);
            if (net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(world.Z(), vaultState)) {
                net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(world, vaultState, config, sharedData, pos);
            }
            IBlockData blockState = state;
            if (world.Z() >= serverData.c() && !state.equals(blockState = (IBlockData)blockState.a(VaultBlock.b, vaultState.a(world, pos, config, serverData, sharedData)))) {
                net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(world, pos, state, blockState, config, sharedData);
            }
            if (serverData.c || sharedData.c) {
                VaultBlockEntity.a(world, pos, state);
                if (sharedData.c) {
                    world.a(pos, state, blockState, 2);
                }
                serverData.c = false;
                sharedData.c = false;
            }
        }

        public static void a(WorldServer world, BlockPosition pos, IBlockData state, VaultConfig config, VaultServerData serverData, VaultSharedData sharedData, EntityHuman player, ItemStack stack) {
            VaultState vaultState = state.c(VaultBlock.b);
            if (!net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(config, vaultState)) {
                return;
            }
            if (!net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(config, stack)) {
                net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(world, serverData, pos, SoundEffects.AK);
                return;
            }
            if (serverData.a(player)) {
                net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(world, serverData, pos, SoundEffects.AG);
                return;
            }
            List<ItemStack> list = net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(world, config, pos, player);
            if (list.isEmpty()) {
                return;
            }
            player.b(StatisticList.c.b(stack.g()));
            stack.a(config.e().H(), (EntityLiving)player);
            net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(world, state, pos, config, serverData, sharedData, list);
            serverData.b(player);
            sharedData.a(world, pos, serverData, config, config.d());
        }

        static void a(WorldServer world, BlockPosition pos, IBlockData oldState, IBlockData newState, VaultConfig config, VaultSharedData sharedData) {
            VaultState vaultState = oldState.c(VaultBlock.b);
            VaultState vaultState2 = newState.c(VaultBlock.b);
            world.a(pos, newState, 3);
            vaultState.a(world, pos, vaultState2, config, sharedData, newState.c(VaultBlock.d));
        }

        static void a(WorldServer world, VaultState state, VaultConfig config, VaultSharedData sharedData, BlockPosition pos) {
            if (!net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(config, state)) {
                sharedData.a(ItemStack.l);
                return;
            }
            ItemStack itemStack = net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(world, pos, config.f().orElse(config.b()));
            sharedData.a(itemStack);
        }

        private static ItemStack a(WorldServer world, BlockPosition pos, ResourceKey<LootTable> lootTable) {
            LootParams lootParams;
            LootTable lootTable2 = world.o().be().b(lootTable);
            ObjectArrayList<ItemStack> list = lootTable2.a(lootParams = new LootParams.a(world).a(LootContextParameters.f, Vec3D.b(pos)).a(LootContextParameterSets.l), world.E_());
            if (list.isEmpty()) {
                return ItemStack.l;
            }
            return SystemUtils.a(list, world.E_());
        }

        private static void a(WorldServer world, IBlockData state, BlockPosition pos, VaultConfig config, VaultServerData serverData, VaultSharedData sharedData, List<ItemStack> itemsToEject) {
            serverData.a(itemsToEject);
            sharedData.a(serverData.f());
            serverData.b(world.Z() + 14L);
            net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(world, pos, state, (IBlockData)state.a(VaultBlock.b, VaultState.c), config, sharedData);
        }

        private static List<ItemStack> a(WorldServer world, VaultConfig config, BlockPosition pos, EntityHuman player) {
            LootTable lootTable = world.o().be().b(config.b());
            LootParams lootParams = new LootParams.a(world).a(LootContextParameters.f, Vec3D.b(pos)).a(player.gu()).a(LootContextParameters.a, player).a(LootContextParameterSets.l);
            return lootTable.a(lootParams);
        }

        private static boolean a(VaultConfig config, VaultState state) {
            return config.b() != LootTables.a && !config.e().e() && state != VaultState.a;
        }

        private static boolean a(VaultConfig config, ItemStack stack) {
            return ItemStack.c(stack, config.e()) && stack.H() >= config.e().H();
        }

        private static boolean a(long time, VaultState state) {
            return time % 20L == 0L && state == VaultState.b;
        }

        private static void a(WorldServer world, VaultServerData serverData, BlockPosition pos, SoundEffect sound) {
            if (world.Z() >= serverData.a() + 15L) {
                world.a(null, pos, sound, SoundCategory.e);
                serverData.a(world.Z());
            }
        }
    }
}

