/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.trialspawner;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.OminousItemSpawner;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.MobSpawnerData;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawner;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerConfig;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerData;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public final class TrialSpawnerState
extends Enum<TrialSpawnerState>
implements INamable {
    public static final /* enum */ TrialSpawnerState a = new TrialSpawnerState("inactive", 0, net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState$b.a, -1.0, false);
    public static final /* enum */ TrialSpawnerState b = new TrialSpawnerState("waiting_for_players", 4, net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState$b.b, 200.0, true);
    public static final /* enum */ TrialSpawnerState c = new TrialSpawnerState("active", 8, net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState$b.c, 1000.0, true);
    public static final /* enum */ TrialSpawnerState d = new TrialSpawnerState("waiting_for_reward_ejection", 8, net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState$b.b, -1.0, false);
    public static final /* enum */ TrialSpawnerState e = new TrialSpawnerState("ejecting_reward", 8, net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState$b.b, -1.0, false);
    public static final /* enum */ TrialSpawnerState f = new TrialSpawnerState("cooldown", 0, net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState$b.d, -1.0, false);
    private static final float g = 40.0f;
    private static final int h;
    private final String i;
    private final int j;
    private final double k;
    private final b l;
    private final boolean m;
    private static final /* synthetic */ TrialSpawnerState[] n;

    public static TrialSpawnerState[] values() {
        return (TrialSpawnerState[])n.clone();
    }

    public static TrialSpawnerState valueOf(String string) {
        return Enum.valueOf(TrialSpawnerState.class, string);
    }

    private TrialSpawnerState(String id, int luminance, b particleEmitter, double displayRotationSpeed, boolean playsSound) {
        this.i = id;
        this.j = luminance;
        this.l = particleEmitter;
        this.k = displayRotationSpeed;
        this.m = playsSound;
    }

    TrialSpawnerState a(BlockPosition pos, TrialSpawner logic, WorldServer world) {
        TrialSpawnerData trialSpawnerData = logic.f();
        TrialSpawnerConfig trialSpawnerConfig = logic.b();
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (trialSpawnerData.a(logic, world, b) == null) {
                    yield this;
                }
                yield b;
            }
            case 1 -> {
                if (!logic.a(world)) {
                    trialSpawnerData.a();
                    yield this;
                }
                if (!trialSpawnerData.a(logic, world.z)) {
                    yield a;
                }
                trialSpawnerData.a(world, pos, logic);
                if (trialSpawnerData.c.isEmpty()) {
                    yield this;
                }
                yield c;
            }
            case 2 -> {
                if (!logic.a(world)) {
                    trialSpawnerData.a();
                    yield b;
                }
                if (!trialSpawnerData.a(logic, world.z)) {
                    yield a;
                }
                int i = trialSpawnerData.a(pos);
                trialSpawnerData.a(world, pos, logic);
                if (logic.e()) {
                    this.a(world, pos, logic);
                }
                if (trialSpawnerData.a(trialSpawnerConfig, i)) {
                    if (trialSpawnerData.b()) {
                        trialSpawnerData.e = world.Z() + (long)logic.g();
                        trialSpawnerData.g = 0;
                        trialSpawnerData.f = 0L;
                        yield d;
                    }
                } else if (trialSpawnerData.a(world, trialSpawnerConfig, i)) {
                    logic.c(world, pos).ifPresent(uuid -> {
                        trialSpawnerData.d.add((UUID)uuid);
                        ++trialSpawnerData.g;
                        trialSpawnerData.f = world.Z() + (long)trialSpawnerConfig.g();
                        trialSpawnerConfig.h().b(world.E_()).ifPresent(spawnData -> {
                            trialSpawnerData.h = Optional.of((MobSpawnerData)spawnData.b());
                            logic.j();
                        });
                    });
                }
                yield this;
            }
            case 3 -> {
                if (trialSpawnerData.a(world, 40.0f, logic.g())) {
                    world.a(null, pos, SoundEffects.mk, SoundCategory.e);
                    yield e;
                }
                yield this;
            }
            case 4 -> {
                if (!trialSpawnerData.b(world, h, logic.g())) {
                    yield this;
                }
                if (trialSpawnerData.c.isEmpty()) {
                    world.a(null, pos, SoundEffects.ml, SoundCategory.e);
                    trialSpawnerData.i = Optional.empty();
                    yield f;
                }
                if (trialSpawnerData.i.isEmpty()) {
                    trialSpawnerData.i = trialSpawnerConfig.i().a(world.E_());
                }
                trialSpawnerData.i.ifPresent(lootTable -> logic.a(world, pos, (ResourceKey<LootTable>)lootTable));
                trialSpawnerData.c.remove(trialSpawnerData.c.iterator().next());
                yield this;
            }
            case 5 -> {
                trialSpawnerData.a(world, pos, logic);
                if (!trialSpawnerData.c.isEmpty()) {
                    trialSpawnerData.g = 0;
                    trialSpawnerData.f = 0L;
                    yield c;
                }
                if (trialSpawnerData.a(world)) {
                    logic.b(world, pos);
                    trialSpawnerData.a();
                    yield b;
                }
                yield this;
            }
        };
    }

    private void a(WorldServer world, BlockPosition pos2, TrialSpawner logic) {
        TrialSpawnerConfig trialSpawnerConfig;
        TrialSpawnerData trialSpawnerData = logic.f();
        ItemStack itemStack = trialSpawnerData.a(world, trialSpawnerConfig = logic.b(), pos2).a(world.z).orElse(ItemStack.l);
        if (itemStack.e()) {
            return;
        }
        if (this.a(world, trialSpawnerData)) {
            TrialSpawnerState.a(world, pos2, logic, trialSpawnerData).ifPresent(pos -> {
                OminousItemSpawner ominousItemSpawner = OminousItemSpawner.a(world, itemStack);
                ominousItemSpawner.f((Vec3D)pos);
                world.b(ominousItemSpawner);
                float f2 = (world.E_().i() - world.E_().i()) * 0.2f + 1.0f;
                world.a(null, BlockPosition.a(pos), SoundEffects.mf, SoundCategory.e, 1.0f, f2);
                trialSpawnerData.e = world.Z() + logic.d().a();
            });
        }
    }

    private static Optional<Vec3D> a(WorldServer world, BlockPosition pos, TrialSpawner logic, TrialSpawnerData data) {
        List<EntityHuman> list = data.c.stream().map(world::b).filter(Objects::nonNull).filter(player -> !player.f() && !player.R_() && player.bE() && player.g(pos.b()) <= (double)MathHelper.h(logic.h())).toList();
        if (list.isEmpty()) {
            return Optional.empty();
        }
        Entity entity = TrialSpawnerState.a(list, data.d, logic, pos, world);
        if (entity == null) {
            return Optional.empty();
        }
        return TrialSpawnerState.a(entity, world);
    }

    private static Optional<Vec3D> a(Entity entity, WorldServer world) {
        Vec3D vec32;
        Vec3D vec3 = entity.dm();
        MovingObjectPositionBlock blockHitResult = world.a(new RayTrace(vec3, vec32 = vec3.a(EnumDirection.b, (double)(entity.dk() + 2.0f + (float)world.z.a(4))), RayTrace.BlockCollisionOption.c, RayTrace.FluidCollisionOption.a, VoxelShapeCollision.a()));
        Vec3D vec33 = blockHitResult.a().b().a(EnumDirection.a, 1.0);
        BlockPosition blockPos = BlockPosition.a(vec33);
        if (!world.a_(blockPos).k(world, blockPos).c()) {
            return Optional.empty();
        }
        return Optional.of(vec33);
    }

    @Nullable
    private static Entity a(List<EntityHuman> players, Set<UUID> entityUuids, TrialSpawner logic, BlockPosition pos, WorldServer world) {
        List<Entity> list;
        Stream<Entity> stream = entityUuids.stream().map(world::a).filter(Objects::nonNull).filter(entity -> entity.bE() && entity.g(pos.b()) <= (double)MathHelper.h(logic.h()));
        List<Entity> list2 = list = world.z.h() ? stream.toList() : players;
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return list.getFirst();
        }
        return SystemUtils.a(list, world.z);
    }

    private boolean a(WorldServer world, TrialSpawnerData data) {
        return world.Z() >= data.e;
    }

    public int a() {
        return this.j;
    }

    public double b() {
        return this.k;
    }

    public boolean d() {
        return this.k >= 0.0;
    }

    public boolean e() {
        return this.m;
    }

    public void a(World world, BlockPosition pos, boolean ominous) {
        this.l.emit(world, world.E_(), pos, ominous);
    }

    @Override
    @Override
    public String c() {
        return this.i;
    }

    private static /* synthetic */ TrialSpawnerState[] f() {
        return new TrialSpawnerState[]{a, b, c, d, e, f};
    }

    static {
        n = TrialSpawnerState.f();
        h = MathHelper.d(30.0f);
    }

    static interface b {
        public static final b a = (world, random, pos, ominous) -> {};
        public static final b b = (world, random, pos, ominous) -> {
            if (random.a(2) == 0) {
                Vec3D vec3 = pos.b().a(random, 0.9f);
                net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState$b.a(ominous ? Particles.L : Particles.aJ, vec3, world);
            }
        };
        public static final b c = (world, random, pos, ominous) -> {
            Vec3D vec3 = pos.b().a(random, 1.0f);
            net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState$b.a(Particles.ae, vec3, world);
            net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState$b.a(ominous ? Particles.L : Particles.F, vec3, world);
        };
        public static final b d = (world, random, pos, ominous) -> {
            Vec3D vec3 = pos.b().a(random, 0.9f);
            if (random.a(3) == 0) {
                net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState$b.a(Particles.ae, vec3, world);
            }
            if (world.Z() % 20L == 0L) {
                Vec3D vec32 = pos.b().b(0.0, 0.5, 0.0);
                int i2 = world.E_().a(4) + 20;
                for (int j2 = 0; j2 < i2; ++j2) {
                    net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState$b.a(Particles.ae, vec32, world);
                }
            }
        };

        private static void a(ParticleType type, Vec3D pos, World world) {
            world.a(type, pos.a(), pos.b(), pos.c(), 0.0, 0.0, 0.0);
        }

        public void emit(World var1, RandomSource var2, BlockPosition var3, boolean var4);
    }

    static class a {
        private static final int a = 0;
        private static final int b = 4;
        private static final int c = 8;

        private a() {
        }
    }

    static class c {
        private static final double a = -1.0;
        private static final double b = 200.0;
        private static final double c = 1000.0;

        private c() {
        }
    }
}

