/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.trialspawner;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.dispenser.DispenseBehaviorItem;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.MobSpawnerData;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.TrialSpawnerBlock;
import net.minecraft.world.level.block.entity.trialspawner.PlayerDetector;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerConfig;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerData;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public final class TrialSpawner {
    public static final String a = "normal_config";
    public static final String b = "ominous_config";
    public static final int c = 40;
    private static final int d = 36000;
    private static final int e = 14;
    private static final int f = 47;
    private static final int g = MathHelper.h(47);
    private static final float h = 0.02f;
    private final TrialSpawnerConfig i;
    private final TrialSpawnerConfig j;
    private final TrialSpawnerData k;
    private final int l;
    private final int m;
    public final b n;
    private PlayerDetector o;
    private final PlayerDetector.a p;
    private boolean q;
    private boolean r;

    public Codec<TrialSpawner> a() {
        return RecordCodecBuilder.create(instance -> instance.group((App)TrialSpawnerConfig.b.optionalFieldOf(a, (Object)TrialSpawnerConfig.a).forGetter(TrialSpawner::c), (App)TrialSpawnerConfig.b.optionalFieldOf(b, (Object)TrialSpawnerConfig.a).forGetter(TrialSpawner::n), (App)TrialSpawnerData.b.forGetter(TrialSpawner::f), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).optionalFieldOf("target_cooldown_length", (Object)36000).forGetter(TrialSpawner::g), (App)Codec.intRange((int)1, (int)128).optionalFieldOf("required_player_range", (Object)14).forGetter(TrialSpawner::h)).apply((Applicative)instance, (config, trialSpawnerConfig, trialSpawnerData, integer, integer2) -> new TrialSpawner((TrialSpawnerConfig)config, (TrialSpawnerConfig)trialSpawnerConfig, (TrialSpawnerData)trialSpawnerData, (int)integer, (int)integer2, this.n, this.o, this.p)));
    }

    public TrialSpawner(b trialSpawner, PlayerDetector entityDetector, PlayerDetector.a entitySelector) {
        this(TrialSpawnerConfig.a, TrialSpawnerConfig.a, new TrialSpawnerData(), 36000, 14, trialSpawner, entityDetector, entitySelector);
    }

    public TrialSpawner(TrialSpawnerConfig normalConfig, TrialSpawnerConfig ominousConfig, TrialSpawnerData data, int cooldownLength, int entityDetectionRange, b trialSpawner, PlayerDetector entityDetector, PlayerDetector.a entitySelector) {
        this.i = normalConfig;
        this.j = ominousConfig;
        this.k = data;
        this.m = cooldownLength;
        this.l = entityDetectionRange;
        this.n = trialSpawner;
        this.o = entityDetector;
        this.p = entitySelector;
    }

    public TrialSpawnerConfig b() {
        return this.r ? this.j : this.i;
    }

    @VisibleForTesting
    public TrialSpawnerConfig c() {
        return this.i;
    }

    @VisibleForTesting
    public TrialSpawnerConfig d() {
        return this.j;
    }

    private TrialSpawnerConfig n() {
        return !this.j.equals(this.i) ? this.j : TrialSpawnerConfig.a;
    }

    public void a(WorldServer world, BlockPosition pos) {
        world.a(pos, (IBlockData)world.a_(pos).a(TrialSpawnerBlock.c, true), 3);
        world.c(3020, pos, 1);
        this.r = true;
        this.k.a(this, world);
    }

    public void b(WorldServer world, BlockPosition pos) {
        world.a(pos, (IBlockData)world.a_(pos).a(TrialSpawnerBlock.c, false), 3);
        this.r = false;
    }

    public boolean e() {
        return this.r;
    }

    public TrialSpawnerData f() {
        return this.k;
    }

    public int g() {
        return this.m;
    }

    public int h() {
        return this.l;
    }

    public TrialSpawnerState i() {
        return this.n.d();
    }

    public void a(World world, TrialSpawnerState spawnerState) {
        this.n.a(world, spawnerState);
    }

    public void j() {
        this.n.f();
    }

    public PlayerDetector k() {
        return this.o;
    }

    public PlayerDetector.a l() {
        return this.p;
    }

    public boolean a(World world) {
        if (this.q) {
            return true;
        }
        if (world.al() == EnumDifficulty.a) {
            return false;
        }
        return world.ab().b(GameRules.e);
    }

    public Optional<UUID> c(WorldServer world, BlockPosition pos) {
        MobSpawnerData.a customSpawnRules;
        double f2;
        RandomSource randomSource = world.E_();
        MobSpawnerData spawnData = this.k.b(this, world.E_());
        NBTTagCompound compoundTag = spawnData.d();
        NBTTagList listTag = compoundTag.c("Pos", 6);
        Optional<EntityTypes<?>> optional = EntityTypes.a(compoundTag);
        if (optional.isEmpty()) {
            return Optional.empty();
        }
        int i2 = listTag.size();
        double d2 = i2 >= 1 ? listTag.h(0) : (double)pos.u() + (randomSource.j() - randomSource.j()) * (double)this.b().b() + 0.5;
        double e2 = i2 >= 2 ? listTag.h(1) : (double)(pos.v() + randomSource.a(3) - 1);
        double d3 = f2 = i2 >= 3 ? listTag.h(2) : (double)pos.w() + (randomSource.j() - randomSource.j()) * (double)this.b().b() + 0.5;
        if (!world.b(optional.get().a(d2, e2, f2))) {
            return Optional.empty();
        }
        Vec3D vec3 = new Vec3D(d2, e2, f2);
        if (!TrialSpawner.a((World)world, pos.b(), vec3)) {
            return Optional.empty();
        }
        BlockPosition blockPos = BlockPosition.a(vec3);
        if (!EntityPositionTypes.a(optional.get(), world, EnumMobSpawn.q, blockPos, world.E_())) {
            return Optional.empty();
        }
        if (spawnData.b().isPresent() && !(customSpawnRules = spawnData.b().get()).a(blockPos, world)) {
            return Optional.empty();
        }
        Entity entity2 = EntityTypes.a(compoundTag, world, (Entity entity) -> {
            entity.b(d2, e2, f2, randomSource.i() * 360.0f, 0.0f);
            return entity;
        });
        if (entity2 == null) {
            return Optional.empty();
        }
        if (entity2 instanceof EntityInsentient) {
            boolean bl;
            EntityInsentient mob = (EntityInsentient)entity2;
            if (!mob.a((IWorldReader)world)) {
                return Optional.empty();
            }
            boolean bl2 = bl = spawnData.a().f() == 1 && spawnData.a().b("id", 8);
            if (bl) {
                mob.a((WorldAccess)world, world.d_(mob.do()), EnumMobSpawn.q, null);
            }
            mob.fR();
            spawnData.c().ifPresent(mob::a);
        }
        if (!world.e(entity2)) {
            return Optional.empty();
        }
        a flameParticle = this.r ? net.minecraft.world.level.block.entity.trialspawner.TrialSpawner$a.b : net.minecraft.world.level.block.entity.trialspawner.TrialSpawner$a.a;
        world.c(3011, pos, flameParticle.a());
        world.c(3012, blockPos, flameParticle.a());
        world.a(entity2, GameEvent.t, blockPos);
        return Optional.of(entity2.cz());
    }

    public void a(WorldServer world, BlockPosition pos, ResourceKey<LootTable> lootTable) {
        LootParams lootParams;
        LootTable lootTable2 = world.o().be().b(lootTable);
        ObjectArrayList<ItemStack> objectArrayList = lootTable2.a(lootParams = new LootParams.a(world).a(LootContextParameterSets.b));
        if (!objectArrayList.isEmpty()) {
            for (ItemStack itemStack : objectArrayList) {
                DispenseBehaviorItem.a(world, itemStack, 2, EnumDirection.b, Vec3D.c(pos).a(EnumDirection.b, 1.2));
            }
            world.c(3014, pos, 0);
        }
    }

    public void a(World world, BlockPosition pos, boolean ominous) {
        RandomSource randomSource;
        TrialSpawnerState trialSpawnerState = this.i();
        trialSpawnerState.a(world, pos, ominous);
        if (trialSpawnerState.d()) {
            double d2 = Math.max(0L, this.k.f - world.Z());
            this.k.l = this.k.k;
            this.k.k = (this.k.k + trialSpawnerState.b() / (d2 + 200.0)) % 360.0;
        }
        if (trialSpawnerState.e() && (randomSource = world.E_()).i() <= 0.02f) {
            SoundEffect soundEvent = ominous ? SoundEffects.mj : SoundEffects.mi;
            world.a(pos, soundEvent, SoundCategory.e, randomSource.i() * 0.25f + 0.75f, randomSource.i() + 0.5f, false);
        }
    }

    public void a(WorldServer world, BlockPosition pos, boolean ominous) {
        TrialSpawnerState trialSpawnerState2;
        this.r = ominous;
        TrialSpawnerState trialSpawnerState = this.i();
        if (this.k.d.removeIf(uuid -> TrialSpawner.a(world, pos, uuid))) {
            this.k.f = world.Z() + (long)this.b().g();
        }
        if ((trialSpawnerState2 = trialSpawnerState.a(pos, this, world)) != trialSpawnerState) {
            this.a((World)world, trialSpawnerState2);
        }
    }

    private static boolean a(WorldServer world, BlockPosition pos, UUID uuid) {
        Entity entity = world.a(uuid);
        return entity == null || !entity.bE() || !entity.dO().af().equals(world.af()) || entity.do().j(pos) > (double)g;
    }

    private static boolean a(World world, Vec3D spawnerPos, Vec3D spawnPos) {
        MovingObjectPositionBlock blockHitResult = world.a(new RayTrace(spawnPos, spawnerPos, RayTrace.BlockCollisionOption.c, RayTrace.FluidCollisionOption.a, VoxelShapeCollision.a()));
        return blockHitResult.a().equals(BlockPosition.a(spawnerPos)) || blockHitResult.c() == MovingObjectPosition.EnumMovingObjectType.a;
    }

    public static void a(World world, BlockPosition pos, RandomSource random, ParticleType particle) {
        for (int i2 = 0; i2 < 20; ++i2) {
            double d2 = (double)pos.u() + 0.5 + (random.j() - 0.5) * 2.0;
            double e2 = (double)pos.v() + 0.5 + (random.j() - 0.5) * 2.0;
            double f2 = (double)pos.w() + 0.5 + (random.j() - 0.5) * 2.0;
            world.a(Particles.ae, d2, e2, f2, 0.0, 0.0, 0.0);
            world.a(particle, d2, e2, f2, 0.0, 0.0, 0.0);
        }
    }

    public static void a(World world, BlockPosition pos, RandomSource random) {
        for (int i2 = 0; i2 < 20; ++i2) {
            double d2 = (double)pos.u() + 0.5 + (random.j() - 0.5) * 2.0;
            double e2 = (double)pos.v() + 0.5 + (random.j() - 0.5) * 2.0;
            double f2 = (double)pos.w() + 0.5 + (random.j() - 0.5) * 2.0;
            double g2 = random.k() * 0.02;
            double h2 = random.k() * 0.02;
            double j2 = random.k() * 0.02;
            world.a(Particles.be, d2, e2, f2, g2, h2, j2);
            world.a(Particles.L, d2, e2, f2, g2, h2, j2);
        }
    }

    public static void a(World world, BlockPosition pos, RandomSource random, int playerCount, ParticleParam particle) {
        for (int i2 = 0; i2 < 30 + Math.min(playerCount, 10) * 5; ++i2) {
            double d2 = (double)(2.0f * random.i() - 1.0f) * 0.65;
            double e2 = (double)(2.0f * random.i() - 1.0f) * 0.65;
            double f2 = (double)pos.u() + 0.5 + d2;
            double g2 = (double)pos.v() + 0.1 + (double)random.i() * 0.8;
            double h2 = (double)pos.w() + 0.5 + e2;
            world.a(particle, f2, g2, h2, 0.0, 0.0, 0.0);
        }
    }

    public static void b(World world, BlockPosition pos, RandomSource random) {
        for (int i2 = 0; i2 < 20; ++i2) {
            double d2 = (double)pos.u() + 0.4 + random.j() * 0.2;
            double e2 = (double)pos.v() + 0.4 + random.j() * 0.2;
            double f2 = (double)pos.w() + 0.4 + random.j() * 0.2;
            double g2 = random.k() * 0.02;
            double h2 = random.k() * 0.02;
            double j2 = random.k() * 0.02;
            world.a(Particles.aJ, d2, e2, f2, g2, h2, j2 * 0.25);
            world.a(Particles.ae, d2, e2, f2, g2, h2, j2);
        }
    }

    @Deprecated(forRemoval=true)
    @VisibleForTesting
    public void a(PlayerDetector detector) {
        this.o = detector;
    }

    @Deprecated(forRemoval=true)
    @VisibleForTesting
    public void m() {
        this.q = true;
    }

    public static interface b {
        public void a(World var1, TrialSpawnerState var2);

        public TrialSpawnerState d();

        public void f();
    }

    public static final class a
    extends Enum<a> {
        public static final /* enum */ a a = new a(Particles.F);
        public static final /* enum */ a b = new a(Particles.L);
        public final ParticleType c;
        private static final /* synthetic */ a[] d;

        public static a[] values() {
            return (a[])d.clone();
        }

        public static a valueOf(String string) {
            return Enum.valueOf(a.class, string);
        }

        private a(ParticleType particle) {
            this.c = particle;
        }

        public static a a(int index) {
            a[] flameParticles = net.minecraft.world.level.block.entity.trialspawner.TrialSpawner$a.values();
            if (index > flameParticles.length || index < 0) {
                return a;
            }
            return flameParticles[index];
        }

        public int a() {
            return this.ordinal();
        }

        private static /* synthetic */ a[] b() {
            return new a[]{a, b};
        }

        static {
            d = net.minecraft.world.level.block.entity.trialspawner.TrialSpawner$a.b();
        }
    }
}

