/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.EndFeatures;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntityEnderPortal;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenEndGatewayConfiguration;
import net.minecraft.world.phys.Vec3D;
import org.slf4j.Logger;

public class TileEntityEndGateway
extends TileEntityEnderPortal {
    private static final Logger a = LogUtils.getLogger();
    private static final int b = 200;
    private static final int c = 40;
    private static final int d = 2400;
    private static final int e = 1;
    private static final int f = 10;
    public long g;
    private int h;
    @Nullable
    public BlockPosition i;
    public boolean j;

    public TileEntityEndGateway(BlockPosition pos, IBlockData state) {
        super(TileEntityTypes.v, pos, state);
    }

    @Override
    protected void b(NBTTagCompound nbt, HolderLookup.a registryLookup) {
        super.b(nbt, registryLookup);
        nbt.a("Age", this.g);
        if (this.i != null) {
            nbt.a("exit_portal", GameProfileSerializer.a(this.i));
        }
        if (this.j) {
            nbt.a("ExactTeleport", true);
        }
    }

    @Override
    protected void a(NBTTagCompound nbt, HolderLookup.a registryLookup) {
        super.a(nbt, registryLookup);
        this.g = nbt.i("Age");
        GameProfileSerializer.a(nbt, "exit_portal").filter(World::l).ifPresent(blockposition -> {
            this.i = blockposition;
        });
        this.j = nbt.q("ExactTeleport");
    }

    public static void a(World world, BlockPosition pos, IBlockData state, TileEntityEndGateway blockEntity) {
        ++blockEntity.g;
        if (blockEntity.c()) {
            --blockEntity.h;
        }
    }

    public static void b(World world, BlockPosition pos, IBlockData state, TileEntityEndGateway blockEntity) {
        boolean flag = blockEntity.b();
        boolean flag1 = blockEntity.c();
        ++blockEntity.g;
        if (flag1) {
            --blockEntity.h;
        } else if (blockEntity.g % 2400L == 0L) {
            TileEntityEndGateway.c(world, pos, state, blockEntity);
        }
        if (flag != blockEntity.b() || flag1 != blockEntity.c()) {
            TileEntityEndGateway.a(world, pos, state);
        }
    }

    public boolean b() {
        return this.g < 200L;
    }

    public boolean c() {
        return this.h > 0;
    }

    public float a(float tickDelta) {
        return MathHelper.a(((float)this.g + tickDelta) / 200.0f, 0.0f, 1.0f);
    }

    public float b(float tickDelta) {
        return 1.0f - MathHelper.a(((float)this.h - tickDelta) / 40.0f, 0.0f, 1.0f);
    }

    public PacketPlayOutTileEntityData d() {
        return PacketPlayOutTileEntityData.a(this);
    }

    @Override
    public NBTTagCompound a(HolderLookup.a registryLookup) {
        return this.e(registryLookup);
    }

    public static void c(World world, BlockPosition pos, IBlockData state, TileEntityEndGateway blockEntity) {
        if (!world.B) {
            blockEntity.h = 40;
            world.a(pos, state.b(), 1, 0);
            TileEntityEndGateway.a(world, pos, state);
        }
    }

    @Override
    public boolean a_(int type, int data) {
        if (type == 1) {
            this.h = 40;
            return true;
        }
        return super.a_(type, data);
    }

    @Nullable
    public Vec3D a(WorldServer world, BlockPosition pos) {
        BlockPosition blockposition1;
        if (this.i == null && world.getTypeKey() == WorldDimension.d) {
            blockposition1 = TileEntityEndGateway.b(world, pos);
            blockposition1 = blockposition1.b(10);
            a.debug("Creating portal at {}", (Object)blockposition1);
            TileEntityEndGateway.a(world, blockposition1, WorldGenEndGatewayConfiguration.a(pos, false));
            this.a(blockposition1, this.j);
        }
        if (this.i != null) {
            blockposition1 = this.j ? this.i : TileEntityEndGateway.a((World)world, this.i);
            return blockposition1.c();
        }
        return null;
    }

    private static BlockPosition a(World world, BlockPosition pos) {
        BlockPosition blockposition1 = TileEntityEndGateway.a((IBlockAccess)world, pos.b(0, 2, 0), 5, false);
        a.debug("Best exit position for portal at {} is {}", (Object)pos, (Object)blockposition1);
        return blockposition1.d();
    }

    private static BlockPosition b(WorldServer world, BlockPosition pos) {
        Vec3D vec3d = TileEntityEndGateway.c(world, pos);
        Chunk chunk = TileEntityEndGateway.a((World)world, vec3d);
        BlockPosition blockposition1 = TileEntityEndGateway.a(chunk);
        if (blockposition1 == null) {
            BlockPosition blockposition2 = BlockPosition.a(vec3d.c + 0.5, 75.0, vec3d.e + 0.5);
            a.debug("Failed to find a suitable block to teleport to, spawning an island on {}", (Object)blockposition2);
            world.H_().c(Registries.aI).flatMap(iregistry -> iregistry.b(EndFeatures.f)).ifPresent(holder_c -> ((WorldGenFeatureConfigured)holder_c.a()).a(world, world.l().g(), RandomSource.a(blockposition2.a()), blockposition2));
            blockposition1 = blockposition2;
        } else {
            a.debug("Found suitable block to teleport to: {}", (Object)blockposition1);
        }
        return TileEntityEndGateway.a((IBlockAccess)world, blockposition1, 16, true);
    }

    private static Vec3D c(WorldServer world, BlockPosition pos) {
        Vec3D vec3d = new Vec3D(pos.u(), 0.0, pos.w()).d();
        boolean flag = true;
        Vec3D vec3d1 = vec3d.a(1024.0);
        int i2 = 16;
        while (!TileEntityEndGateway.a(world, vec3d1) && i2-- > 0) {
            a.debug("Skipping backwards past nonempty chunk at {}", (Object)vec3d1);
            vec3d1 = vec3d1.e(vec3d.a(-16.0));
        }
        i2 = 16;
        while (TileEntityEndGateway.a(world, vec3d1) && i2-- > 0) {
            a.debug("Skipping forward past empty chunk at {}", (Object)vec3d1);
            vec3d1 = vec3d1.e(vec3d.a(16.0));
        }
        a.debug("Found chunk at {}", (Object)vec3d1);
        return vec3d1;
    }

    private static boolean a(WorldServer world, Vec3D pos) {
        return TileEntityEndGateway.a((World)world, pos).a() == -1;
    }

    private static BlockPosition a(IBlockAccess world, BlockPosition pos, int searchRadius, boolean force) {
        BaseBlockPosition blockposition1 = null;
        for (int j2 = -searchRadius; j2 <= searchRadius; ++j2) {
            block1: for (int k2 = -searchRadius; k2 <= searchRadius; ++k2) {
                if (j2 == 0 && k2 == 0 && !force) continue;
                for (int l2 = world.am() - 1; l2 > (blockposition1 == null ? world.I_() : blockposition1.v()); --l2) {
                    BlockPosition blockposition2 = new BlockPosition(pos.u() + j2, l2, pos.w() + k2);
                    IBlockData iblockdata = world.a_(blockposition2);
                    if (!iblockdata.r(world, blockposition2) || !force && iblockdata.a(Blocks.F)) continue;
                    blockposition1 = blockposition2;
                    continue block1;
                }
            }
        }
        return blockposition1 == null ? pos : blockposition1;
    }

    private static Chunk a(World world, Vec3D pos) {
        return world.d(MathHelper.a(pos.c / 16.0), MathHelper.a(pos.e / 16.0));
    }

    @Nullable
    private static BlockPosition a(Chunk chunk) {
        ChunkCoordIntPair chunkcoordintpair = chunk.f();
        BlockPosition blockposition = new BlockPosition(chunkcoordintpair.d(), 30, chunkcoordintpair.e());
        int i2 = chunk.b() + 16 - 1;
        BlockPosition blockposition1 = new BlockPosition(chunkcoordintpair.f(), i2, chunkcoordintpair.g());
        BlockPosition blockposition2 = null;
        double d0 = 0.0;
        for (BlockPosition blockposition3 : BlockPosition.c(blockposition, blockposition1)) {
            IBlockData iblockdata = chunk.a_(blockposition3);
            BlockPosition blockposition4 = blockposition3.d();
            BlockPosition blockposition5 = blockposition3.b(2);
            if (!iblockdata.a(Blocks.fz) || chunk.a_(blockposition4).r(chunk, blockposition4) || chunk.a_(blockposition5).r(chunk, blockposition5)) continue;
            double d1 = blockposition3.c(0.0, 0.0, 0.0);
            if (blockposition2 != null && !(d1 < d0)) continue;
            blockposition2 = blockposition3;
            d0 = d1;
        }
        return blockposition2;
    }

    private static void a(WorldServer world, BlockPosition pos, WorldGenEndGatewayConfiguration config) {
        WorldGenerator.M.a(config, world, world.l().g(), RandomSource.a(), pos);
    }

    @Override
    public boolean a(EnumDirection direction) {
        return Block.a(this.n(), this.n, this.aD_(), direction, this.aD_().a(direction));
    }

    public int f() {
        int i2 = 0;
        for (EnumDirection enumdirection : EnumDirection.values()) {
            i2 += this.a(enumdirection) ? 1 : 0;
        }
        return i2;
    }

    public void a(BlockPosition pos, boolean exactTeleport) {
        this.j = exactTeleport;
        this.i = pos;
        this.e();
    }
}

