/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.SculkShriekerBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.event.block.Action;

public class SculkShriekerBlock
extends BlockTileEntity
implements IBlockWaterlogged {
    public static final MapCodec<SculkShriekerBlock> a = SculkShriekerBlock.b(SculkShriekerBlock::new);
    public static final BlockStateBoolean b = BlockProperties.F;
    public static final BlockStateBoolean c = BlockProperties.C;
    public static final BlockStateBoolean d = BlockProperties.G;
    protected static final VoxelShape e = Block.a(0.0, 0.0, 0.0, 16.0, 8.0, 16.0);
    public static final double f = e.c(EnumDirection.EnumAxis.b);

    public MapCodec<SculkShriekerBlock> a() {
        return a;
    }

    public SculkShriekerBlock(BlockBase.Info settings) {
        super(settings);
        this.k((IBlockData)((IBlockData)((IBlockData)this.E.b().a(b, false)).a(c, false)).a(d, false));
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{b});
        builder.a(new IBlockState[]{c});
        builder.a(new IBlockState[]{d});
    }

    @Override
    public void a(World world, BlockPosition pos, IBlockData state, Entity entity) {
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            EntityPlayer entityplayer = SculkShriekerBlockEntity.a(entity);
            if (entityplayer != null) {
                if (CraftEventFactory.callPlayerInteractEvent(entityplayer, Action.PHYSICAL, pos, null, null, null).isCancelled()) {
                    return;
                }
                worldserver.a(pos, TileEntityTypes.L).ifPresent(sculkshriekerblockentity -> sculkshriekerblockentity.a(worldserver, entityplayer));
            }
        }
        super.a(world, pos, state, entity);
    }

    @Override
    protected void a(IBlockData state, World world, BlockPosition pos, IBlockData newState, boolean moved) {
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (state.c(b).booleanValue() && !state.a(newState.b())) {
                worldserver.a(pos, TileEntityTypes.L).ifPresent(sculkshriekerblockentity -> sculkshriekerblockentity.a(worldserver));
            }
        }
        super.a(state, world, pos, newState, moved);
    }

    @Override
    protected void a(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
        if (state.c(b).booleanValue()) {
            world.a(pos, (IBlockData)state.a(b, false), 3);
            world.a(pos, TileEntityTypes.L).ifPresent(sculkshriekerblockentity -> sculkshriekerblockentity.a(world));
        }
    }

    @Override
    protected EnumRenderType a_(IBlockData state) {
        return EnumRenderType.c;
    }

    @Override
    protected VoxelShape b(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return e;
    }

    @Override
    protected VoxelShape f(IBlockData state, IBlockAccess world, BlockPosition pos) {
        return e;
    }

    @Override
    protected boolean f_(IBlockData state) {
        return true;
    }

    @Override
    @Nullable
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new SculkShriekerBlockEntity(pos, state);
    }

    @Override
    protected IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        if (state.c(c).booleanValue()) {
            world.a(pos, FluidTypes.c, FluidTypes.c.a(world));
        }
        return super.a(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    @Nullable
    public IBlockData a(BlockActionContext ctx) {
        return (IBlockData)this.o().a(c, ctx.q().b_(ctx.a()).a() == FluidTypes.c);
    }

    @Override
    protected Fluid b_(IBlockData state) {
        return state.c(c) != false ? FluidTypes.c.a(false) : super.b_(state);
    }

    @Override
    protected void a(IBlockData state, WorldServer world, BlockPosition pos, ItemStack tool, boolean dropExperience) {
        super.a(state, world, pos, tool, dropExperience);
    }

    @Override
    public int getExpDrop(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, ItemStack itemstack, boolean flag) {
        if (flag) {
            return this.tryDropExperience(worldserver, blockposition, itemstack, ConstantInt.a(5));
        }
        return 0;
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> a(World world, IBlockData state, TileEntityTypes<T> type) {
        return !world.B ? BlockTileEntity.a(type, TileEntityTypes.L, (World world1, BlockPosition blockposition, IBlockData iblockdata1, ? super E sculkshriekerblockentity) -> VibrationSystem.c.a(world1, sculkshriekerblockentity.gm(), sculkshriekerblockentity.gn())) : null;
    }
}

