/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCauldron;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockStates;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.CauldronLevelChangeEvent;

public class LayeredCauldronBlock
extends AbstractCauldronBlock {
    public static final MapCodec<LayeredCauldronBlock> d = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BiomeBase.Precipitation.d.fieldOf("precipitation").forGetter(layeredcauldronblock -> layeredcauldronblock.j), (App)CauldronInteraction.b.fieldOf("interactions").forGetter(layeredcauldronblock -> layeredcauldronblock.c), LayeredCauldronBlock.u()).apply((Applicative)instance, LayeredCauldronBlock::new));
    public static final int e = 1;
    public static final int f = 3;
    public static final BlockStateInteger g = BlockProperties.aK;
    private static final int h = 6;
    private static final double i = 3.0;
    private final BiomeBase.Precipitation j;

    public MapCodec<LayeredCauldronBlock> a() {
        return d;
    }

    public LayeredCauldronBlock(BiomeBase.Precipitation precipitation, CauldronInteraction.a behaviorMap, BlockBase.Info settings) {
        super(settings, behaviorMap);
        this.j = precipitation;
        this.k((IBlockData)this.E.b().a(g, 1));
    }

    @Override
    public boolean d(IBlockData state) {
        return state.c(g) == 3;
    }

    @Override
    protected boolean a(FluidType fluid) {
        return fluid == FluidTypes.c && this.j == BiomeBase.Precipitation.b;
    }

    @Override
    protected double b(IBlockData state) {
        return (6.0 + (double)state.c(g).intValue() * 3.0) / 16.0;
    }

    @Override
    protected void a(IBlockData state, World world, BlockPosition pos, net.minecraft.world.entity.Entity entity) {
        if (!new EntityInsideBlockEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(world, pos)).callEvent()) {
            return;
        }
        if (!world.B && entity.bR() && this.a(state, pos, entity)) {
            if ((entity instanceof EntityHuman || world.ab().b(GameRules.c)) && entity.a(world, pos) && !this.handleEntityOnFireInsideWithEvent(state, world, pos, entity)) {
                return;
            }
            entity.aD();
        }
    }

    @DoNotUse
    @Deprecated
    private void e(IBlockData state, World world, BlockPosition pos) {
        if (this.j == BiomeBase.Precipitation.c) {
            LayeredCauldronBlock.d((IBlockData)Blocks.fu.o().a(g, state.c(g)), world, pos);
        } else {
            LayeredCauldronBlock.d(state, world, pos);
        }
    }

    protected boolean handleEntityOnFireInsideWithEvent(IBlockData state, World world, BlockPosition pos, net.minecraft.world.entity.Entity entity) {
        if (this.j == BiomeBase.Precipitation.c) {
            return LayeredCauldronBlock.lowerFillLevel((IBlockData)Blocks.fu.o().a(g, state.c(g)), world, pos, entity, CauldronLevelChangeEvent.ChangeReason.EXTINGUISH);
        }
        return LayeredCauldronBlock.lowerFillLevel(state, world, pos, entity, CauldronLevelChangeEvent.ChangeReason.EXTINGUISH);
    }

    public static void d(IBlockData state, World world, BlockPosition pos) {
        LayeredCauldronBlock.lowerFillLevel(state, world, pos, null, CauldronLevelChangeEvent.ChangeReason.UNKNOWN);
    }

    public static boolean lowerFillLevel(IBlockData iblockdata, World world, BlockPosition blockposition, net.minecraft.world.entity.Entity entity, CauldronLevelChangeEvent.ChangeReason reason) {
        int i2 = iblockdata.c(g) - 1;
        IBlockData iblockdata1 = i2 == 0 ? Blocks.ft.o() : (IBlockData)iblockdata.a(g, i2);
        return LayeredCauldronBlock.changeLevel(iblockdata, world, blockposition, iblockdata1, entity, reason);
    }

    public static boolean changeLevel(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData newBlock, @Nullable net.minecraft.world.entity.Entity entity, CauldronLevelChangeEvent.ChangeReason reason) {
        return LayeredCauldronBlock.changeLevel(iblockdata, world, blockposition, newBlock, entity, reason, true);
    }

    public static boolean changeLevel(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData newBlock, @Nullable net.minecraft.world.entity.Entity entity, CauldronLevelChangeEvent.ChangeReason reason, boolean sendGameEvent) {
        CraftBlockState newState = CraftBlockStates.getBlockState(world, blockposition);
        newState.setData(newBlock);
        CauldronLevelChangeEvent event = new CauldronLevelChangeEvent(world.getWorld().getBlockAt(blockposition.u(), blockposition.v(), blockposition.w()), (Entity)(entity == null ? null : entity.getBukkitEntity()), reason, (BlockState)newState);
        world.getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        newState.update(true);
        if (sendGameEvent) {
            world.a(GameEvent.c, blockposition, GameEvent.a.a(newBlock));
        }
        return true;
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, BiomeBase.Precipitation precipitation) {
        if (BlockCauldron.a(world, precipitation) && state.c(g) != 3 && precipitation == this.j) {
            IBlockData iblockdata1 = (IBlockData)state.a(g);
            LayeredCauldronBlock.changeLevel(state, world, pos, iblockdata1, null, CauldronLevelChangeEvent.ChangeReason.NATURAL_FILL);
        }
    }

    @Override
    protected int a(IBlockData state, World world, BlockPosition pos) {
        return state.c(g);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{g});
    }

    @Override
    protected void a(IBlockData state, World world, BlockPosition pos, FluidType fluid) {
        if (!this.d(state)) {
            IBlockData iblockdata1 = (IBlockData)state.a(g, state.c(g) + 1);
            if (!LayeredCauldronBlock.changeLevel(state, world, pos, iblockdata1, null, CauldronLevelChangeEvent.ChangeReason.NATURAL_FILL)) {
                return;
            }
            world.c(1047, pos, 0);
        }
    }
}

