/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import io.papermc.paper.event.entity.EntityPortalReadyEvent;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.monster.EntityPigZombie;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.portal.BlockPortalShape;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.Location;
import org.bukkit.PortalType;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftPortalEvent;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftLocation;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityPortalEnterEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.slf4j.Logger;

public class BlockPortal
extends Block
implements Portal {
    public static final MapCodec<BlockPortal> a = BlockPortal.b(BlockPortal::new);
    public static final BlockStateEnum<EnumDirection.EnumAxis> b = BlockProperties.H;
    private static final Logger f = LogUtils.getLogger();
    protected static final int c = 2;
    protected static final VoxelShape d = Block.a(0.0, 0.0, 6.0, 16.0, 16.0, 10.0);
    protected static final VoxelShape e = Block.a(6.0, 0.0, 0.0, 10.0, 16.0, 16.0);

    public MapCodec<BlockPortal> a() {
        return a;
    }

    public BlockPortal(BlockBase.Info settings) {
        super(settings);
        this.k((IBlockData)this.E.b().a(b, EnumDirection.EnumAxis.a));
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        switch (state.c(b)) {
            case c: {
                return e;
            }
        }
        return d;
    }

    @Override
    protected void b(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
        if (world.spigotConfig.enableZombiePigmenPortalSpawns && world.D_().j() && world.ab().b(GameRules.e) && random.a(2000) < world.al().a()) {
            EntityPigZombie entity;
            while (world.a_(pos).a(this)) {
                pos = pos.e();
            }
            if (world.a_(pos).a((IBlockAccess)world, pos, EntityTypes.bx) && (entity = EntityTypes.bx.spawn(world, pos.d(), EnumMobSpawn.d, CreatureSpawnEvent.SpawnReason.NETHER_PORTAL)) != null) {
                entity.ay();
                entity.fromNetherPortal = true;
                if (world.paperConfig().entities.behavior.nerfPigmenFromNetherPortals) {
                    ((EntityInsentient)entity).aware = false;
                }
            }
        }
    }

    @Override
    protected IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        EnumDirection.EnumAxis enumdirection_enumaxis = direction.o();
        EnumDirection.EnumAxis enumdirection_enumaxis1 = state.c(b);
        boolean flag = enumdirection_enumaxis1 != enumdirection_enumaxis && enumdirection_enumaxis.d();
        return !flag && !neighborState.a(this) && !new BlockPortalShape(world, pos, enumdirection_enumaxis1).c() ? Blocks.a.o() : super.a(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    protected void a(IBlockData state, World world, BlockPosition pos, net.minecraft.world.entity.Entity entity) {
        if (!new EntityInsideBlockEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(world, pos)).callEvent()) {
            return;
        }
        if (entity.o(false)) {
            EntityPortalEnterEvent event = new EntityPortalEnterEvent((Entity)entity.getBukkitEntity(), new Location((org.bukkit.World)world.getWorld(), (double)pos.u(), (double)pos.v(), (double)pos.w()), PortalType.NETHER);
            world.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            entity.a(this, pos);
        }
    }

    @Override
    public int a(WorldServer world, net.minecraft.world.entity.Entity entity) {
        if (entity instanceof EntityHuman) {
            EntityHuman entityhuman = (EntityHuman)entity;
            return Math.max(1, world.ab().c(entityhuman.fZ().a ? GameRules.F : GameRules.E));
        }
        return 0;
    }

    @Override
    @Nullable
    public DimensionTransition a(WorldServer world, net.minecraft.world.entity.Entity entity, BlockPosition pos) {
        CraftPortalEvent event;
        ResourceKey<World> resourcekey = world.getTypeKey() == WorldDimension.c ? World.h : World.i;
        WorldServer worldserver1 = world.o().a(resourcekey);
        EntityPortalReadyEvent portalReadyEvent = new EntityPortalReadyEvent((Entity)entity.getBukkitEntity(), (org.bukkit.World)(worldserver1 == null ? null : worldserver1.getWorld()), PortalType.NETHER);
        if (!portalReadyEvent.callEvent()) {
            entity.aw = null;
            return null;
        }
        WorldServer worldServer = worldserver1 = portalReadyEvent.getTargetWorld() == null ? null : ((CraftWorld)portalReadyEvent.getTargetWorld()).getHandle();
        if (worldserver1 == null) {
            return new DimensionTransition(PlayerTeleportEvent.TeleportCause.NETHER_PORTAL);
        }
        boolean flag = worldserver1.getTypeKey() == WorldDimension.c;
        WorldBorder worldborder = worldserver1.C_();
        double d0 = DimensionManager.a(world.D_(), worldserver1.D_());
        BlockPosition blockposition1 = worldborder.b(entity.dt() * d0, entity.dv(), entity.dz() * d0);
        int portalSearchRadius = worldserver1.paperConfig().environment.portalSearchRadius;
        if (entity.dO().paperConfig().environment.portalSearchVanillaDimensionScaling && flag) {
            portalSearchRadius = (int)((double)portalSearchRadius / worldserver1.D_().k());
        }
        if ((event = entity.callPortalEvent(entity, CraftLocation.toBukkit(blockposition1, (org.bukkit.World)worldserver1.getWorld()), PlayerTeleportEvent.TeleportCause.NETHER_PORTAL, portalSearchRadius, 16)) == null) {
            return null;
        }
        worldserver1 = ((CraftWorld)event.getTo().getWorld()).getHandle();
        worldborder = worldserver1.C_();
        blockposition1 = worldborder.b(event.getTo().getX(), event.getTo().getY(), event.getTo().getZ());
        return this.getExitPortal(worldserver1, entity, pos, blockposition1, flag, worldborder, event.getSearchRadius(), event.getCanCreatePortal(), event.getCreationRadius());
    }

    @Nullable
    private DimensionTransition getExitPortal(WorldServer worldserver, net.minecraft.world.entity.Entity entity, BlockPosition blockposition, BlockPosition blockposition1, boolean flag, WorldBorder worldborder, int searchRadius, boolean canCreatePortal, int createRadius) {
        DimensionTransition.a dimensiontransition_a;
        BlockUtil.Rectangle blockutil_rectangle;
        Optional<BlockPosition> optional = worldserver.p().findClosestPortalPosition(blockposition1, worldborder, searchRadius);
        if (optional.isPresent()) {
            BlockPosition blockposition2 = optional.get();
            IBlockData iblockdata = worldserver.a_(blockposition2);
            blockutil_rectangle = BlockUtil.a(blockposition2, iblockdata.c(BlockProperties.H), 21, EnumDirection.EnumAxis.b, 21, (BlockPosition blockposition3) -> worldserver.a_((BlockPosition)blockposition3) == iblockdata);
            dimensiontransition_a = DimensionTransition.b.then(entity1 -> entity1.f(blockposition2));
        } else if (canCreatePortal) {
            EnumDirection.EnumAxis enumdirection_enumaxis = entity.dO().a_(blockposition).d(b).orElse(EnumDirection.EnumAxis.a);
            Optional<BlockUtil.Rectangle> optional1 = worldserver.p().createPortal(blockposition1, enumdirection_enumaxis, entity, createRadius);
            if (optional1.isEmpty()) {
                return null;
            }
            blockutil_rectangle = optional1.get();
            dimensiontransition_a = DimensionTransition.b.then(DimensionTransition.c);
        } else {
            return null;
        }
        return BlockPortal.a(entity, blockposition, blockutil_rectangle, worldserver, dimensiontransition_a);
    }

    private static DimensionTransition a(net.minecraft.world.entity.Entity entity, BlockPosition pos, BlockUtil.Rectangle exitPortalRectangle, WorldServer world, DimensionTransition.a postDimensionTransition) {
        Vec3D vec3d;
        EnumDirection.EnumAxis enumdirection_enumaxis;
        IBlockData iblockdata = entity.dO().a_(pos);
        if (iblockdata.b(BlockProperties.H)) {
            enumdirection_enumaxis = iblockdata.c(BlockProperties.H);
            BlockUtil.Rectangle blockutil_rectangle1 = BlockUtil.a(pos, enumdirection_enumaxis, 21, EnumDirection.EnumAxis.b, 21, (BlockPosition blockposition1) -> entity.dO().a_((BlockPosition)blockposition1) == iblockdata);
            vec3d = entity.a(enumdirection_enumaxis, blockutil_rectangle1);
        } else {
            enumdirection_enumaxis = EnumDirection.EnumAxis.a;
            vec3d = new Vec3D(0.5, 0.0, 0.0);
        }
        return BlockPortal.a(world, exitPortalRectangle, enumdirection_enumaxis, vec3d, entity, entity.dr(), entity.dE(), entity.dG(), postDimensionTransition);
    }

    private static DimensionTransition a(WorldServer world, BlockUtil.Rectangle exitPortalRectangle, EnumDirection.EnumAxis axis, Vec3D positionInPortal, net.minecraft.world.entity.Entity entity, Vec3D velocity, float yaw, float pitch, DimensionTransition.a postDimensionTransition) {
        BlockPosition blockposition = exitPortalRectangle.a;
        IBlockData iblockdata = world.a_(blockposition);
        EnumDirection.EnumAxis enumdirection_enumaxis1 = iblockdata.d(BlockProperties.H).orElse(EnumDirection.EnumAxis.a);
        double d0 = exitPortalRectangle.b;
        double d1 = exitPortalRectangle.c;
        EntitySize entitysize = entity.a(entity.at());
        int i2 = axis == enumdirection_enumaxis1 ? 0 : 90;
        Vec3D vec3d2 = axis == enumdirection_enumaxis1 ? velocity : new Vec3D(velocity.e, velocity.d, -velocity.c);
        double d2 = (double)entitysize.a() / 2.0 + (d0 - (double)entitysize.a()) * positionInPortal.a();
        double d3 = (d1 - (double)entitysize.b()) * positionInPortal.b();
        double d4 = 0.5 + positionInPortal.c();
        boolean flag = enumdirection_enumaxis1 == EnumDirection.EnumAxis.a;
        Vec3D vec3d3 = new Vec3D((double)blockposition.u() + (flag ? d2 : d4), (double)blockposition.v() + d3, (double)blockposition.w() + (flag ? d4 : d2));
        Vec3D vec3d4 = BlockPortalShape.a(vec3d3, world, entity, entitysize);
        return new DimensionTransition(world, vec3d4, vec3d2, yaw + (float)i2, pitch, postDimensionTransition, PlayerTeleportEvent.TeleportCause.NETHER_PORTAL);
    }

    @Override
    public Portal.a b() {
        return Portal.a.a;
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, RandomSource random) {
        if (random.a(100) == 0) {
            world.a((double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, SoundEffects.uH, SoundCategory.e, 0.5f, random.i() * 0.4f + 0.8f, false);
        }
        for (int i2 = 0; i2 < 4; ++i2) {
            double d0 = (double)pos.u() + random.j();
            double d1 = (double)pos.v() + random.j();
            double d2 = (double)pos.w() + random.j();
            double d3 = ((double)random.i() - 0.5) * 0.5;
            double d4 = ((double)random.i() - 0.5) * 0.5;
            double d5 = ((double)random.i() - 0.5) * 0.5;
            int j2 = random.a(2) * 2 - 1;
            if (!world.a_(pos.h()).a(this) && !world.a_(pos.i()).a(this)) {
                d0 = (double)pos.u() + 0.5 + 0.25 * (double)j2;
                d3 = random.i() * 2.0f * (float)j2;
            } else {
                d2 = (double)pos.w() + 0.5 + 0.25 * (double)j2;
                d5 = random.i() * 2.0f * (float)j2;
            }
            world.a(Particles.ac, d0, d1, d2, d3, d4, d5);
        }
    }

    @Override
    public ItemStack a(IWorldReader world, BlockPosition pos, IBlockData state) {
        return ItemStack.l;
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        switch (rotation) {
            case d: 
            case b: {
                switch (state.c(b)) {
                    case c: {
                        return (IBlockData)state.a(b, EnumDirection.EnumAxis.a);
                    }
                    case a: {
                        return (IBlockData)state.a(b, EnumDirection.EnumAxis.c);
                    }
                }
                return state;
            }
        }
        return state;
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{b});
    }
}

