/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.TileInventory;
import net.minecraft.world.entity.monster.piglin.PiglinAI;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.ContainerChest;
import net.minecraft.world.inventory.InventoryEnderChest;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockChestAbstract;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.DoubleBlockFinder;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityChest;
import net.minecraft.world.level.block.entity.TileEntityEnderChest;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockEnderChest
extends BlockChestAbstract<TileEntityEnderChest>
implements IBlockWaterlogged {
    public static final MapCodec<BlockEnderChest> b = BlockEnderChest.b(BlockEnderChest::new);
    public static final BlockStateDirection c = BlockFacingHorizontal.aE;
    public static final BlockStateBoolean d = BlockProperties.C;
    protected static final VoxelShape e = Block.a(1.0, 0.0, 1.0, 15.0, 14.0, 15.0);
    private static final IChatBaseComponent f = IChatBaseComponent.c("container.enderchest");

    @Override
    public MapCodec<BlockEnderChest> a() {
        return b;
    }

    protected BlockEnderChest(BlockBase.Info settings) {
        super(settings, () -> TileEntityTypes.d);
        this.k((IBlockData)((IBlockData)this.E.b().a(c, EnumDirection.c)).a(d, false));
    }

    @Override
    public DoubleBlockFinder.Result<? extends TileEntityChest> a(IBlockData state, World world, BlockPosition pos, boolean ignoreBlocked) {
        return DoubleBlockFinder.Combiner::b;
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return e;
    }

    @Override
    protected EnumRenderType a_(IBlockData state) {
        return EnumRenderType.b;
    }

    @Override
    public IBlockData a(BlockActionContext ctx) {
        Fluid fluidState = ctx.q().b_(ctx.a());
        return (IBlockData)((IBlockData)this.o().a(c, ctx.g().g())).a(d, fluidState.a() == FluidTypes.c);
    }

    @Override
    protected EnumInteractionResult a(IBlockData state, World world, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hit) {
        InventoryEnderChest playerEnderChestContainer = player.gl();
        TileEntity blockEntity = world.c_(pos);
        if (playerEnderChestContainer != null && blockEntity instanceof TileEntityEnderChest) {
            BlockPosition blockPos = pos.d();
            if (world.a_(blockPos).g(world, blockPos)) {
                return EnumInteractionResult.a(world.B);
            }
            if (world.B) {
                return EnumInteractionResult.a;
            }
            TileEntityEnderChest enderChestBlockEntity = (TileEntityEnderChest)blockEntity;
            playerEnderChestContainer.a(enderChestBlockEntity);
            player.a(new TileInventory((i2, inventory, playerx) -> ContainerChest.a(i2, inventory, playerEnderChestContainer), f));
            player.a(StatisticList.aj);
            PiglinAI.a(player, true);
            return EnumInteractionResult.c;
        }
        return EnumInteractionResult.a(world.B);
    }

    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new TileEntityEnderChest(pos, state);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> a(World world, IBlockData state, TileEntityTypes<T> type) {
        return world.B ? BlockEnderChest.a(type, TileEntityTypes.d, TileEntityEnderChest::a) : null;
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, RandomSource random) {
        for (int i2 = 0; i2 < 3; ++i2) {
            int j2 = random.a(2) * 2 - 1;
            int k2 = random.a(2) * 2 - 1;
            double d2 = (double)pos.u() + 0.5 + 0.25 * (double)j2;
            double e2 = (float)pos.v() + random.i();
            double f2 = (double)pos.w() + 0.5 + 0.25 * (double)k2;
            double g2 = random.i() * (float)j2;
            double h2 = ((double)random.i() - 0.5) * 0.125;
            double l2 = random.i() * (float)k2;
            world.a(Particles.ac, d2, e2, f2, g2, h2, l2);
        }
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return (IBlockData)state.a(c, rotation.a(state.c(c)));
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state.a(mirror.a(state.c(c)));
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(c, d);
    }

    @Override
    protected Fluid b_(IBlockData state) {
        return state.c(d) != false ? FluidTypes.c.a(false) : super.b_(state);
    }

    @Override
    protected IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        if (state.c(d).booleanValue()) {
            world.a(pos, FluidTypes.c, FluidTypes.c.a(world));
        }
        return super.a(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    protected boolean a(IBlockData state, PathMode type) {
        return false;
    }

    @Override
    protected void a(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
        TileEntity blockEntity = world.c_(pos);
        if (blockEntity instanceof TileEntityEnderChest) {
            ((TileEntityEnderChest)blockEntity).b();
        }
    }
}

