/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.block.BlockDirtSnow;
import net.minecraft.world.level.block.BlockGrass;
import net.minecraft.world.level.block.BlockSnow;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.lighting.LightEngine;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;

public abstract class BlockDirtSnowSpreadable
extends BlockDirtSnow {
    protected BlockDirtSnowSpreadable(BlockBase.Info settings) {
        super(settings);
    }

    private static boolean b(IBlockData state, IWorldReader world, BlockPosition pos) {
        BlockPosition blockposition1 = pos.d();
        IBlockData iblockdata1 = world.a_(blockposition1);
        if (iblockdata1.a(Blocks.dN) && iblockdata1.c(BlockSnow.c) == 1) {
            return true;
        }
        if (iblockdata1.u().e() == 8) {
            return false;
        }
        int i2 = LightEngine.a(world, state, pos, iblockdata1, blockposition1, EnumDirection.b, iblockdata1.b(world, blockposition1));
        return i2 < world.Q();
    }

    protected abstract MapCodec<? extends BlockDirtSnowSpreadable> a();

    private static boolean c(IBlockData state, IWorldReader world, BlockPosition pos) {
        BlockPosition blockposition1 = pos.d();
        return BlockDirtSnowSpreadable.b(state, world, pos) && !world.b_(blockposition1).a(TagsFluid.a);
    }

    @Override
    protected void b(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
        if (this instanceof BlockGrass && world.paperConfig().tickRates.grassSpread != 1 && (world.paperConfig().tickRates.grassSpread < 1 || (MinecraftServer.currentTick + pos.hashCode()) % world.paperConfig().tickRates.grassSpread != 0)) {
            return;
        }
        if (!BlockDirtSnowSpreadable.b(state, (IWorldReader)world, pos)) {
            if (CraftEventFactory.callBlockFadeEvent(world, pos, Blocks.j.o()).isCancelled()) {
                return;
            }
            world.b(pos, Blocks.j.o());
        } else if (world.A(pos.d()) >= 9) {
            IBlockData iblockdata1 = this.o();
            for (int i2 = 0; i2 < 4; ++i2) {
                BlockPosition blockposition1 = pos.b(random.a(3) - 1, random.a(5) - 3, random.a(3) - 1);
                if (!world.a_(blockposition1).a(Blocks.j) || !BlockDirtSnowSpreadable.c(iblockdata1, (IWorldReader)world, blockposition1)) continue;
                CraftEventFactory.handleBlockSpreadEvent(world, pos, blockposition1, (IBlockData)iblockdata1.a(BlockDirtSnow.c, world.a_(blockposition1.d()).a(Blocks.dN)));
            }
        }
    }
}

