/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.Climate;

public abstract class WorldChunkManager
implements BiomeResolver {
    public static final Codec<WorldChunkManager> a = BuiltInRegistries.Z.r().dispatchStable(WorldChunkManager::a, Function.identity());
    private final Supplier<Set<Holder<BiomeBase>>> b = Suppliers.memoize(() -> (Set)this.b().distinct().collect(ImmutableSet.toImmutableSet()));

    protected WorldChunkManager() {
    }

    protected abstract MapCodec<? extends WorldChunkManager> a();

    protected abstract Stream<Holder<BiomeBase>> b();

    public Set<Holder<BiomeBase>> c() {
        return this.b.get();
    }

    public Set<Holder<BiomeBase>> a(int x2, int y2, int z2, int radius, Climate.Sampler sampler) {
        int i2 = QuartPos.a(x2 - radius);
        int j2 = QuartPos.a(y2 - radius);
        int k2 = QuartPos.a(z2 - radius);
        int l2 = QuartPos.a(x2 + radius);
        int m2 = QuartPos.a(y2 + radius);
        int n2 = QuartPos.a(z2 + radius);
        int o2 = l2 - i2 + 1;
        int p2 = m2 - j2 + 1;
        int q2 = n2 - k2 + 1;
        HashSet set = Sets.newHashSet();
        for (int r2 = 0; r2 < q2; ++r2) {
            for (int s2 = 0; s2 < o2; ++s2) {
                for (int t2 = 0; t2 < p2; ++t2) {
                    int u2 = i2 + s2;
                    int v2 = j2 + t2;
                    int w2 = k2 + r2;
                    set.add(this.getNoiseBiome(u2, v2, w2, sampler));
                }
            }
        }
        return set;
    }

    @Nullable
    public Pair<BlockPosition, Holder<BiomeBase>> a(int x2, int y2, int z2, int radius, Predicate<Holder<BiomeBase>> predicate, RandomSource random, Climate.Sampler noiseSampler) {
        return this.a(x2, y2, z2, radius, 1, predicate, random, false, noiseSampler);
    }

    @Nullable
    public Pair<BlockPosition, Holder<BiomeBase>> a(BlockPosition origin, int radius, int horizontalBlockCheckInterval, int verticalBlockCheckInterval, Predicate<Holder<BiomeBase>> predicate, Climate.Sampler noiseSampler, IWorldReader world) {
        Set set = this.c().stream().filter(predicate).collect(Collectors.toUnmodifiableSet());
        if (set.isEmpty()) {
            return null;
        }
        int i2 = Math.floorDiv(radius, horizontalBlockCheckInterval);
        int[] is = MathHelper.a(origin.v(), world.I_() + 1, world.am(), verticalBlockCheckInterval).toArray();
        for (BlockPosition.MutableBlockPosition mutableBlockPos : BlockPosition.a(BlockPosition.c, i2, EnumDirection.f, EnumDirection.d)) {
            int j2 = origin.u() + mutableBlockPos.u() * horizontalBlockCheckInterval;
            int k2 = origin.w() + mutableBlockPos.w() * horizontalBlockCheckInterval;
            int l2 = QuartPos.a(j2);
            int m2 = QuartPos.a(k2);
            for (int n2 : is) {
                int o2 = QuartPos.a(n2);
                Holder<BiomeBase> holder = this.getNoiseBiome(l2, o2, m2, noiseSampler);
                if (!set.contains(holder)) continue;
                return Pair.of((Object)new BlockPosition(j2, n2, k2), holder);
            }
        }
        return null;
    }

    @Nullable
    public Pair<BlockPosition, Holder<BiomeBase>> a(int x2, int y2, int z2, int radius, int blockCheckInterval, Predicate<Holder<BiomeBase>> predicate, RandomSource random, boolean bl, Climate.Sampler noiseSampler) {
        int n2;
        int i2 = QuartPos.a(x2);
        int j2 = QuartPos.a(z2);
        int k2 = QuartPos.a(radius);
        int l2 = QuartPos.a(y2);
        Pair pair = null;
        int m2 = 0;
        for (int o2 = n2 = bl ? 0 : k2; o2 <= k2; o2 += blockCheckInterval) {
            int p2;
            int n3 = p2 = SharedConstants.ar ? 0 : -o2;
            while (p2 <= o2) {
                boolean bl2 = Math.abs(p2) == o2;
                for (int q2 = -o2; q2 <= o2; q2 += blockCheckInterval) {
                    int s2;
                    int r2;
                    Holder<BiomeBase> holder;
                    if (bl) {
                        boolean bl3;
                        boolean bl4 = bl3 = Math.abs(q2) == o2;
                        if (!bl3 && !bl2) continue;
                    }
                    if (!predicate.test(holder = this.getNoiseBiome(r2 = i2 + q2, l2, s2 = j2 + p2, noiseSampler))) continue;
                    if (pair == null || random.a(m2 + 1) == 0) {
                        BlockPosition blockPos = new BlockPosition(QuartPos.c(r2), y2, QuartPos.c(s2));
                        if (bl) {
                            return Pair.of((Object)blockPos, holder);
                        }
                        pair = Pair.of((Object)blockPos, holder);
                    }
                    ++m2;
                }
                p2 += blockCheckInterval;
            }
        }
        return pair;
    }

    @Override
    @Override
    public abstract Holder<BiomeBase> getNoiseBiome(int var1, int var2, int var3, Climate.Sampler var4);

    public void a(List<String> info, BlockPosition pos, Climate.Sampler noiseSampler) {
    }
}

