/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.JsonOps;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceDataJson;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.level.World;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;

public class CraftingManager
extends ResourceDataJson {
    private static final Gson a = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Logger b = LogUtils.getLogger();
    private final HolderLookup.a c;
    public Multimap<Recipes<?>, RecipeHolder<?>> d = ImmutableMultimap.of();
    public Map<MinecraftKey, RecipeHolder<?>> e = ImmutableMap.of();
    private boolean f;

    public CraftingManager(HolderLookup.a registryLookup) {
        super(a, Registries.c(Registries.bg));
        this.c = registryLookup;
    }

    @Override
    protected void a(Map<MinecraftKey, JsonElement> prepared, IResourceManager manager, GameProfilerFiller profiler) {
        this.f = false;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        ImmutableMap.Builder com_google_common_collect_immutablemap_builder = ImmutableMap.builder();
        RegistryOps registryops = this.c.a(JsonOps.INSTANCE);
        for (Map.Entry<MinecraftKey, JsonElement> entry : prepared.entrySet()) {
            MinecraftKey minecraftkey = entry.getKey();
            try {
                IRecipe irecipe = (IRecipe)IRecipe.h.parse(registryops, (Object)entry.getValue()).getOrThrow(JsonParseException::new);
                RecipeHolder<IRecipe> recipeholder = new RecipeHolder<IRecipe>(minecraftkey, irecipe);
                builder.put(irecipe.e(), recipeholder);
                com_google_common_collect_immutablemap_builder.put((Object)minecraftkey, recipeholder);
            }
            catch (JsonParseException | IllegalArgumentException jsonparseexception) {
                b.error("Parsing error loading recipe {}", (Object)minecraftkey, (Object)jsonparseexception);
            }
        }
        this.d = LinkedHashMultimap.create((Multimap)builder.build());
        this.e = Maps.newHashMap((Map)com_google_common_collect_immutablemap_builder.build());
        b.info("Loaded {} recipes", (Object)this.e.size());
    }

    public void addRecipe(RecipeHolder<?> irecipe) {
        AsyncCatcher.catchOp("Recipe Add");
        Collection map = this.d.get(irecipe.b().e());
        if (this.e.containsKey(irecipe.a())) {
            throw new IllegalStateException("Duplicate recipe ignored with ID " + String.valueOf(irecipe.a()));
        }
        map.add(irecipe);
        this.e.put(irecipe.a(), irecipe);
    }

    public boolean a() {
        return this.f;
    }

    public <I extends RecipeInput, T extends IRecipe<I>> Optional<RecipeHolder<T>> a(Recipes<T> type, I input, World world) {
        return this.a(type, input, world, (RecipeHolder)null);
    }

    public <I extends RecipeInput, T extends IRecipe<I>> Optional<RecipeHolder<T>> a(Recipes<T> type, I input, World world, @Nullable MinecraftKey id) {
        RecipeHolder<T> recipeholder = id != null ? this.a(type, id) : null;
        return this.a(type, input, world, recipeholder);
    }

    public <I extends RecipeInput, T extends IRecipe<I>> Optional<RecipeHolder<T>> a(Recipes<T> type, I input, World world, @Nullable RecipeHolder<T> recipe) {
        if (input.b()) {
            return Optional.empty();
        }
        if (recipe != null && recipe.b().a(input, world)) {
            return Optional.of(recipe);
        }
        List<RecipeHolder> list = this.c(type).stream().filter(recipeholder1 -> recipeholder1.b().a((RecipeInput)input, world)).toList();
        return list.isEmpty() ? Optional.empty() : Optional.of(list.getLast());
    }

    public <I extends RecipeInput, T extends IRecipe<I>> List<RecipeHolder<T>> a(Recipes<T> type) {
        return List.copyOf(this.c(type));
    }

    public <I extends RecipeInput, T extends IRecipe<I>> List<RecipeHolder<T>> b(Recipes<T> type, I input, World world) {
        return this.c(type).stream().filter(recipeholder -> recipeholder.b().a((RecipeInput)input, world)).sorted(Comparator.comparing(recipeholder -> recipeholder.b().a(world.H_()).t())).collect(Collectors.toList());
    }

    private <I extends RecipeInput, T extends IRecipe<I>> Collection<RecipeHolder<T>> c(Recipes<T> type) {
        return this.d.get(type);
    }

    public <I extends RecipeInput, T extends IRecipe<I>> NonNullList<ItemStack> c(Recipes<T> type, I input, World world) {
        return this.getRemainingItemsFor(type, input, world, null);
    }

    public <I extends RecipeInput, T extends IRecipe<I>> NonNullList<ItemStack> getRemainingItemsFor(Recipes<T> type, I input, World world, @Nullable RecipeHolder<T> previousRecipe) {
        Optional<RecipeHolder<T>> optional = this.a(type, input, world, previousRecipe);
        if (optional.isPresent()) {
            return optional.get().b().a(input);
        }
        NonNullList<ItemStack> nonnulllist = NonNullList.a(input.a(), ItemStack.l);
        for (int i2 = 0; i2 < nonnulllist.size(); ++i2) {
            nonnulllist.set(i2, input.a(i2));
        }
        return nonnulllist;
    }

    public Optional<RecipeHolder<?>> a(MinecraftKey id) {
        return Optional.ofNullable(this.e.get(id));
    }

    @Nullable
    private <T extends IRecipe<?>> RecipeHolder<T> a(Recipes<T> type, MinecraftKey id) {
        RecipeHolder<?> recipeholder = this.e.get(id);
        return recipeholder != null && recipeholder.b().e().equals(type) ? recipeholder : null;
    }

    public Collection<RecipeHolder<?>> b() {
        return this.d.values();
    }

    public Collection<RecipeHolder<?>> d() {
        return this.e.values();
    }

    public Stream<MinecraftKey> e() {
        return this.e.keySet().stream();
    }

    @VisibleForTesting
    protected static RecipeHolder<?> a(MinecraftKey id, JsonObject json, HolderLookup.a registryLookup) {
        IRecipe irecipe = (IRecipe)IRecipe.h.parse(registryLookup.a(JsonOps.INSTANCE), (Object)json).getOrThrow(JsonParseException::new);
        return new RecipeHolder<IRecipe>(id, irecipe);
    }

    public void a(Iterable<RecipeHolder<?>> recipes) {
        this.f = false;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        ImmutableMap.Builder com_google_common_collect_immutablemap_builder = ImmutableMap.builder();
        for (RecipeHolder<?> recipeholder : recipes) {
            Recipes<?> recipes1 = recipeholder.b().e();
            builder.put(recipes1, recipeholder);
            com_google_common_collect_immutablemap_builder.put((Object)recipeholder.a(), recipeholder);
        }
        this.d = LinkedHashMultimap.create((Multimap)builder.build());
        this.e = Maps.newHashMap((Map)com_google_common_collect_immutablemap_builder.build());
    }

    public boolean removeRecipe(MinecraftKey mcKey) {
        Iterator iter = this.d.values().iterator();
        while (iter.hasNext()) {
            RecipeHolder recipe = (RecipeHolder)iter.next();
            if (!recipe.a().equals(mcKey)) continue;
            iter.remove();
        }
        return this.e.remove(mcKey) != null;
    }

    public void clearRecipes() {
        this.d = LinkedHashMultimap.create();
        this.e = Maps.newHashMap();
    }

    public static <I extends RecipeInput, T extends IRecipe<I>> a<I, T> b(final Recipes<T> type) {
        return new a<I, T>(){
            @Nullable
            private MinecraftKey b;

            @Override
            public Optional<RecipeHolder<T>> a(I input, World world) {
                CraftingManager craftingmanager = world.r();
                Optional optional = craftingmanager.a(type, input, world, this.b);
                if (optional.isPresent()) {
                    RecipeHolder recipeholder = optional.get();
                    this.b = recipeholder.a();
                    return Optional.of(recipeholder);
                }
                return Optional.empty();
            }
        };
    }

    public static interface a<I extends RecipeInput, T extends IRecipe<I>> {
        public Optional<RecipeHolder<T>> a(I var1, World var2);
    }
}

