/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.armortrim;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.EnumChatFormat;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.item.component.TooltipProvider;

public class ArmorTrim
implements TooltipProvider {
    public static final Codec<ArmorTrim> a = RecordCodecBuilder.create(instance -> instance.group((App)TrimMaterial.c.fieldOf("material").forGetter(ArmorTrim::b), (App)TrimPattern.c.fieldOf("pattern").forGetter(ArmorTrim::a), (App)Codec.BOOL.optionalFieldOf("show_in_tooltip", (Object)true).forGetter(trim -> trim.f)).apply((Applicative)instance, ArmorTrim::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ArmorTrim> b = StreamCodec.a(TrimMaterial.d, ArmorTrim::b, TrimPattern.d, ArmorTrim::a, ByteBufCodecs.b, trim -> trim.f, ArmorTrim::new);
    private static final IChatBaseComponent c = IChatBaseComponent.c(SystemUtils.a("item", MinecraftKey.b("smithing_template.upgrade"))).a(EnumChatFormat.h);
    private final Holder<TrimMaterial> d;
    private final Holder<TrimPattern> e;
    public final boolean f;
    private final Function<Holder<ArmorMaterial>, MinecraftKey> g;
    private final Function<Holder<ArmorMaterial>, MinecraftKey> h;

    private ArmorTrim(Holder<TrimMaterial> material, Holder<TrimPattern> pattern, boolean showInTooltip, Function<Holder<ArmorMaterial>, MinecraftKey> leggingsModelIdGetter, Function<Holder<ArmorMaterial>, MinecraftKey> genericModelIdGetter) {
        this.d = material;
        this.e = pattern;
        this.f = showInTooltip;
        this.g = leggingsModelIdGetter;
        this.h = genericModelIdGetter;
    }

    public ArmorTrim(Holder<TrimMaterial> material, Holder<TrimPattern> pattern, boolean showInTooltip) {
        this.d = material;
        this.e = pattern;
        this.g = SystemUtils.b((T materialEntry) -> {
            MinecraftKey resourceLocation = ((TrimPattern)pattern.a()).a();
            String string = ArmorTrim.b(material, materialEntry);
            return resourceLocation.a(materialName -> "trims/models/armor/" + materialName + "_leggings_" + string);
        });
        this.h = SystemUtils.b((T materialEntry) -> {
            MinecraftKey resourceLocation = ((TrimPattern)pattern.a()).a();
            String string = ArmorTrim.b(material, materialEntry);
            return resourceLocation.a(materialName -> "trims/models/armor/" + materialName + "_" + string);
        });
        this.f = showInTooltip;
    }

    public ArmorTrim(Holder<TrimMaterial> material, Holder<TrimPattern> pattern) {
        this(material, pattern, true);
    }

    private static String b(Holder<TrimMaterial> material, Holder<ArmorMaterial> armorMaterial) {
        Map<Holder<ArmorMaterial>, String> map = material.a().d();
        String string = map.get(armorMaterial);
        if (string != null) {
            return string;
        }
        return material.a().a();
    }

    public boolean a(Holder<TrimPattern> pattern, Holder<TrimMaterial> material) {
        return pattern.equals(this.e) && material.equals(this.d);
    }

    public Holder<TrimPattern> a() {
        return this.e;
    }

    public Holder<TrimMaterial> b() {
        return this.d;
    }

    public MinecraftKey a(Holder<ArmorMaterial> armorMaterial) {
        return this.g.apply(armorMaterial);
    }

    public MinecraftKey b(Holder<ArmorMaterial> armorMaterial) {
        return this.h.apply(armorMaterial);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ArmorTrim) {
            ArmorTrim armorTrim = (ArmorTrim)object;
            return this.f == armorTrim.f && this.e.equals(armorTrim.e) && this.d.equals(armorTrim.d);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int i2 = this.d.hashCode();
        i2 = 31 * i2 + this.e.hashCode();
        i2 = 31 * i2 + (this.f ? 1 : 0);
        return i2;
    }

    @Override
    @Override
    public void a(Item.b context, Consumer<IChatBaseComponent> tooltip, TooltipFlag type) {
        if (!this.f) {
            return;
        }
        tooltip.accept(c);
        tooltip.accept(CommonComponents.a().b(this.e.a().a(this.d)));
        tooltip.accept(CommonComponents.a().b(this.d.a().e()));
    }

    public ArmorTrim a(boolean showInTooltip) {
        return new ArmorTrim(this.d, this.e, showInTooltip, this.g, this.h);
    }
}

